# coding: utf-8

"""
    RIME Rest API

    API methods for RIME. Must be authenticated with `rime-api-key` header.  # noqa: E501

    OpenAPI spec version: 1.0
    Contact: dev@robustintelligence.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from rime_sdk.swagger.swagger_client.api_client import ApiClient


class DataCollectorApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def data_collector_get_datapoints(self, data_stream_id_uuid, **kwargs):  # noqa: E501
        """GetDatapoints  # noqa: E501

        GetDatapoints returns all datapoints from a time period.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.data_collector_get_datapoints(data_stream_id_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str data_stream_id_uuid: String value of the object ID. (required)
        :param datetime time_interval_start_time:
        :param datetime time_interval_end_time:
        :return: StreamResultOfRimeGetDatapointsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.data_collector_get_datapoints_with_http_info(data_stream_id_uuid, **kwargs)  # noqa: E501
        else:
            (data) = self.data_collector_get_datapoints_with_http_info(data_stream_id_uuid, **kwargs)  # noqa: E501
            return data

    def data_collector_get_datapoints_with_http_info(self, data_stream_id_uuid, **kwargs):  # noqa: E501
        """GetDatapoints  # noqa: E501

        GetDatapoints returns all datapoints from a time period.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.data_collector_get_datapoints_with_http_info(data_stream_id_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str data_stream_id_uuid: String value of the object ID. (required)
        :param datetime time_interval_start_time:
        :param datetime time_interval_end_time:
        :return: StreamResultOfRimeGetDatapointsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['data_stream_id_uuid', 'time_interval_start_time', 'time_interval_end_time']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method data_collector_get_datapoints" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'data_stream_id_uuid' is set
        if ('data_stream_id_uuid' not in params or
                params['data_stream_id_uuid'] is None):
            raise ValueError("Missing the required parameter `data_stream_id_uuid` when calling `data_collector_get_datapoints`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'data_stream_id_uuid' in params:
            path_params['dataStreamId.uuid'] = params['data_stream_id_uuid']  # noqa: E501

        query_params = []
        if 'time_interval_start_time' in params:
            query_params.append(('timeInterval.startTime', params['time_interval_start_time']))  # noqa: E501
        if 'time_interval_end_time' in params:
            query_params.append(('timeInterval.endTime', params['time_interval_end_time']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['rime-api-key']  # noqa: E501

        return self.api_client.call_api(
            '/v1-beta/data-collector/datapoints/{dataStreamId.uuid}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='StreamResultOfRimeGetDatapointsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def data_collector_get_predictions(self, model_id_uuid, data_stream_id_uuid, **kwargs):  # noqa: E501
        """GetPredictions  # noqa: E501

        GetPredictions returns all predictions from a time period  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.data_collector_get_predictions(model_id_uuid, data_stream_id_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str model_id_uuid: String value of the object ID. (required)
        :param str data_stream_id_uuid: String value of the object ID. (required)
        :param datetime time_interval_start_time:
        :param datetime time_interval_end_time:
        :return: StreamResultOfRimeGetPredictionsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.data_collector_get_predictions_with_http_info(model_id_uuid, data_stream_id_uuid, **kwargs)  # noqa: E501
        else:
            (data) = self.data_collector_get_predictions_with_http_info(model_id_uuid, data_stream_id_uuid, **kwargs)  # noqa: E501
            return data

    def data_collector_get_predictions_with_http_info(self, model_id_uuid, data_stream_id_uuid, **kwargs):  # noqa: E501
        """GetPredictions  # noqa: E501

        GetPredictions returns all predictions from a time period  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.data_collector_get_predictions_with_http_info(model_id_uuid, data_stream_id_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str model_id_uuid: String value of the object ID. (required)
        :param str data_stream_id_uuid: String value of the object ID. (required)
        :param datetime time_interval_start_time:
        :param datetime time_interval_end_time:
        :return: StreamResultOfRimeGetPredictionsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['model_id_uuid', 'data_stream_id_uuid', 'time_interval_start_time', 'time_interval_end_time']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method data_collector_get_predictions" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'model_id_uuid' is set
        if ('model_id_uuid' not in params or
                params['model_id_uuid'] is None):
            raise ValueError("Missing the required parameter `model_id_uuid` when calling `data_collector_get_predictions`")  # noqa: E501
        # verify the required parameter 'data_stream_id_uuid' is set
        if ('data_stream_id_uuid' not in params or
                params['data_stream_id_uuid'] is None):
            raise ValueError("Missing the required parameter `data_stream_id_uuid` when calling `data_collector_get_predictions`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'model_id_uuid' in params:
            path_params['modelId.uuid'] = params['model_id_uuid']  # noqa: E501
        if 'data_stream_id_uuid' in params:
            path_params['dataStreamId.uuid'] = params['data_stream_id_uuid']  # noqa: E501

        query_params = []
        if 'time_interval_start_time' in params:
            query_params.append(('timeInterval.startTime', params['time_interval_start_time']))  # noqa: E501
        if 'time_interval_end_time' in params:
            query_params.append(('timeInterval.endTime', params['time_interval_end_time']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['rime-api-key']  # noqa: E501

        return self.api_client.call_api(
            '/v1-beta/data-collector/predictions/{modelId.uuid}/{dataStreamId.uuid}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='StreamResultOfRimeGetPredictionsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def data_collector_register_data_stream(self, body, project_id_uuid, **kwargs):  # noqa: E501
        """RegisterDataStream  # noqa: E501

        Registers a new data stream. A data stream is a location where data points are stored. All data points that are in the same registered data set must be stored in the same data stream.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.data_collector_register_data_stream(body, project_id_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param DatastreamProjectIdUuidBody body: (required)
        :param str project_id_uuid: String value of the object ID. (required)
        :return: RimeRegisterDataStreamResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.data_collector_register_data_stream_with_http_info(body, project_id_uuid, **kwargs)  # noqa: E501
        else:
            (data) = self.data_collector_register_data_stream_with_http_info(body, project_id_uuid, **kwargs)  # noqa: E501
            return data

    def data_collector_register_data_stream_with_http_info(self, body, project_id_uuid, **kwargs):  # noqa: E501
        """RegisterDataStream  # noqa: E501

        Registers a new data stream. A data stream is a location where data points are stored. All data points that are in the same registered data set must be stored in the same data stream.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.data_collector_register_data_stream_with_http_info(body, project_id_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param DatastreamProjectIdUuidBody body: (required)
        :param str project_id_uuid: String value of the object ID. (required)
        :return: RimeRegisterDataStreamResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'project_id_uuid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method data_collector_register_data_stream" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `data_collector_register_data_stream`")  # noqa: E501
        # verify the required parameter 'project_id_uuid' is set
        if ('project_id_uuid' not in params or
                params['project_id_uuid'] is None):
            raise ValueError("Missing the required parameter `project_id_uuid` when calling `data_collector_register_data_stream`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_id_uuid' in params:
            path_params['projectId.uuid'] = params['project_id_uuid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['rime-api-key']  # noqa: E501

        return self.api_client.call_api(
            '/v1-beta/data-collector/datastream/{projectId.uuid}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RimeRegisterDataStreamResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def data_collector_store_datapoints(self, body, data_stream_id_uuid, **kwargs):  # noqa: E501
        """StoreDatapoints  # noqa: E501

        Store multiple new datapoints into a data stream.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.data_collector_store_datapoints(body, data_stream_id_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param DataDataStreamIdUuidBody body: (required)
        :param str data_stream_id_uuid: String value of the object ID. (required)
        :return: RimeStoreDatapointsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.data_collector_store_datapoints_with_http_info(body, data_stream_id_uuid, **kwargs)  # noqa: E501
        else:
            (data) = self.data_collector_store_datapoints_with_http_info(body, data_stream_id_uuid, **kwargs)  # noqa: E501
            return data

    def data_collector_store_datapoints_with_http_info(self, body, data_stream_id_uuid, **kwargs):  # noqa: E501
        """StoreDatapoints  # noqa: E501

        Store multiple new datapoints into a data stream.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.data_collector_store_datapoints_with_http_info(body, data_stream_id_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param DataDataStreamIdUuidBody body: (required)
        :param str data_stream_id_uuid: String value of the object ID. (required)
        :return: RimeStoreDatapointsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'data_stream_id_uuid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method data_collector_store_datapoints" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `data_collector_store_datapoints`")  # noqa: E501
        # verify the required parameter 'data_stream_id_uuid' is set
        if ('data_stream_id_uuid' not in params or
                params['data_stream_id_uuid'] is None):
            raise ValueError("Missing the required parameter `data_stream_id_uuid` when calling `data_collector_store_datapoints`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'data_stream_id_uuid' in params:
            path_params['dataStreamId.uuid'] = params['data_stream_id_uuid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['rime-api-key']  # noqa: E501

        return self.api_client.call_api(
            '/v1-beta/data-collector/data/{dataStreamId.uuid}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RimeStoreDatapointsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def data_collector_store_predictions(self, body, model_id_uuid, **kwargs):  # noqa: E501
        """StorePredictions  # noqa: E501

        Store multiple new predictions.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.data_collector_store_predictions(body, model_id_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PredictionsModelIdUuidBody body: (required)
        :param str model_id_uuid: String value of the object ID. (required)
        :return: RimeStorePredictionsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.data_collector_store_predictions_with_http_info(body, model_id_uuid, **kwargs)  # noqa: E501
        else:
            (data) = self.data_collector_store_predictions_with_http_info(body, model_id_uuid, **kwargs)  # noqa: E501
            return data

    def data_collector_store_predictions_with_http_info(self, body, model_id_uuid, **kwargs):  # noqa: E501
        """StorePredictions  # noqa: E501

        Store multiple new predictions.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.data_collector_store_predictions_with_http_info(body, model_id_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PredictionsModelIdUuidBody body: (required)
        :param str model_id_uuid: String value of the object ID. (required)
        :return: RimeStorePredictionsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'model_id_uuid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method data_collector_store_predictions" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `data_collector_store_predictions`")  # noqa: E501
        # verify the required parameter 'model_id_uuid' is set
        if ('model_id_uuid' not in params or
                params['model_id_uuid'] is None):
            raise ValueError("Missing the required parameter `model_id_uuid` when calling `data_collector_store_predictions`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'model_id_uuid' in params:
            path_params['modelId.uuid'] = params['model_id_uuid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['rime-api-key']  # noqa: E501

        return self.api_client.call_api(
            '/v1-beta/data-collector/predictions/{modelId.uuid}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RimeStorePredictionsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
