# coding: utf-8

"""
    RIME Rest API

    API methods for RIME. Must be authenticated with `rime-api-key` header.  # noqa: E501

    OpenAPI spec version: 1.0
    Contact: dev@robustintelligence.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from rime_sdk.swagger.swagger_client.api_client import ApiClient


class ModelCardServiceApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def model_card_service_delete_model_card(self, model_card_id_uuid, **kwargs):  # noqa: E501
        """DeleteModelCard  # noqa: E501

        Delete Model Card.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.model_card_service_delete_model_card(model_card_id_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str model_card_id_uuid: String value of the object ID. (required)
        :return: RimeDeleteModelCardResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.model_card_service_delete_model_card_with_http_info(model_card_id_uuid, **kwargs)  # noqa: E501
        else:
            (data) = self.model_card_service_delete_model_card_with_http_info(model_card_id_uuid, **kwargs)  # noqa: E501
            return data

    def model_card_service_delete_model_card_with_http_info(self, model_card_id_uuid, **kwargs):  # noqa: E501
        """DeleteModelCard  # noqa: E501

        Delete Model Card.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.model_card_service_delete_model_card_with_http_info(model_card_id_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str model_card_id_uuid: String value of the object ID. (required)
        :return: RimeDeleteModelCardResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['model_card_id_uuid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method model_card_service_delete_model_card" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'model_card_id_uuid' is set
        if ('model_card_id_uuid' not in params or
                params['model_card_id_uuid'] is None):
            raise ValueError("Missing the required parameter `model_card_id_uuid` when calling `model_card_service_delete_model_card`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'model_card_id_uuid' in params:
            path_params['modelCardId.uuid'] = params['model_card_id_uuid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['rime-api-key']  # noqa: E501

        return self.api_client.call_api(
            '/v1-beta/modelcards/{modelCardId.uuid}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RimeDeleteModelCardResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def model_card_service_get_model_card(self, model_card_id_uuid, **kwargs):  # noqa: E501
        """GetModelCard  # noqa: E501

        Get Model Card By ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.model_card_service_get_model_card(model_card_id_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str model_card_id_uuid: String value of the object ID. (required)
        :return: RimeGetModelCardResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.model_card_service_get_model_card_with_http_info(model_card_id_uuid, **kwargs)  # noqa: E501
        else:
            (data) = self.model_card_service_get_model_card_with_http_info(model_card_id_uuid, **kwargs)  # noqa: E501
            return data

    def model_card_service_get_model_card_with_http_info(self, model_card_id_uuid, **kwargs):  # noqa: E501
        """GetModelCard  # noqa: E501

        Get Model Card By ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.model_card_service_get_model_card_with_http_info(model_card_id_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str model_card_id_uuid: String value of the object ID. (required)
        :return: RimeGetModelCardResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['model_card_id_uuid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method model_card_service_get_model_card" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'model_card_id_uuid' is set
        if ('model_card_id_uuid' not in params or
                params['model_card_id_uuid'] is None):
            raise ValueError("Missing the required parameter `model_card_id_uuid` when calling `model_card_service_get_model_card`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'model_card_id_uuid' in params:
            path_params['modelCardId.uuid'] = params['model_card_id_uuid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['rime-api-key']  # noqa: E501

        return self.api_client.call_api(
            '/v1-beta/modelcards/{modelCardId.uuid}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RimeGetModelCardResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def model_card_service_list_model_cards(self, project_id, **kwargs):  # noqa: E501
        """ListModelCards  # noqa: E501

        List Model Cards by Project.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.model_card_service_list_model_cards(project_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str project_id: Uniquely specifies a Project. (required)
        :return: RimeListModelCardsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.model_card_service_list_model_cards_with_http_info(project_id, **kwargs)  # noqa: E501
        else:
            (data) = self.model_card_service_list_model_cards_with_http_info(project_id, **kwargs)  # noqa: E501
            return data

    def model_card_service_list_model_cards_with_http_info(self, project_id, **kwargs):  # noqa: E501
        """ListModelCards  # noqa: E501

        List Model Cards by Project.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.model_card_service_list_model_cards_with_http_info(project_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str project_id: Uniquely specifies a Project. (required)
        :return: RimeListModelCardsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['project_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method model_card_service_list_model_cards" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'project_id' is set
        if ('project_id' not in params or
                params['project_id'] is None):
            raise ValueError("Missing the required parameter `project_id` when calling `model_card_service_list_model_cards`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_id' in params:
            path_params['projectId'] = params['project_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['rime-api-key']  # noqa: E501

        return self.api_client.call_api(
            '/v1-beta/modelcards/projects/{projectId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RimeListModelCardsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def model_card_service_update_model_card(self, body, model_card_model_card_id_uuid, **kwargs):  # noqa: E501
        """UpdateModelCard  # noqa: E501

        Update Model Card by ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.model_card_service_update_model_card(body, model_card_model_card_id_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ModelcardsModelCardModelCardIdUuidBody body: (required)
        :param str model_card_model_card_id_uuid: String value of the object ID. (required)
        :return: RimeUpdateModelCardResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.model_card_service_update_model_card_with_http_info(body, model_card_model_card_id_uuid, **kwargs)  # noqa: E501
        else:
            (data) = self.model_card_service_update_model_card_with_http_info(body, model_card_model_card_id_uuid, **kwargs)  # noqa: E501
            return data

    def model_card_service_update_model_card_with_http_info(self, body, model_card_model_card_id_uuid, **kwargs):  # noqa: E501
        """UpdateModelCard  # noqa: E501

        Update Model Card by ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.model_card_service_update_model_card_with_http_info(body, model_card_model_card_id_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ModelcardsModelCardModelCardIdUuidBody body: (required)
        :param str model_card_model_card_id_uuid: String value of the object ID. (required)
        :return: RimeUpdateModelCardResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'model_card_model_card_id_uuid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method model_card_service_update_model_card" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `model_card_service_update_model_card`")  # noqa: E501
        # verify the required parameter 'model_card_model_card_id_uuid' is set
        if ('model_card_model_card_id_uuid' not in params or
                params['model_card_model_card_id_uuid'] is None):
            raise ValueError("Missing the required parameter `model_card_model_card_id_uuid` when calling `model_card_service_update_model_card`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'model_card_model_card_id_uuid' in params:
            path_params['modelCard.modelCardId.uuid'] = params['model_card_model_card_id_uuid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['rime-api-key']  # noqa: E501

        return self.api_client.call_api(
            '/v1-beta/modelcards/{modelCard.modelCardId.uuid}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RimeUpdateModelCardResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
