# coding: utf-8

"""
    RIME Rest API

    API methods for RIME. Must be authenticated with `rime-api-key` header.  # noqa: E501

    OpenAPI spec version: 1.0
    Contact: dev@robustintelligence.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class RimeListDetectionEventsRequestQuery(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'firewall_id': 'RimeUUID',
        'event_object_id': 'str',
        'event_time_range': 'RimeTimeInterval',
        'severity': 'RimeSeverity',
        'event_types': 'list[DetectionEventType]',
        'risk_category_types': 'list[RiskscoreRiskCategoryType]',
        'test_categories': 'list[TestrunTestCategoryType]',
        'sort': 'RimeSortSpec'
    }

    attribute_map = {
        'firewall_id': 'firewallId',
        'event_object_id': 'eventObjectId',
        'event_time_range': 'eventTimeRange',
        'severity': 'severity',
        'event_types': 'eventTypes',
        'risk_category_types': 'riskCategoryTypes',
        'test_categories': 'testCategories',
        'sort': 'sort'
    }

    def __init__(self, firewall_id=None, event_object_id=None, event_time_range=None, severity=None, event_types=None, risk_category_types=None, test_categories=None, sort=None):  # noqa: E501
        """RimeListDetectionEventsRequestQuery - a model defined in Swagger"""  # noqa: E501
        self._firewall_id = None
        self._event_object_id = None
        self._event_time_range = None
        self._severity = None
        self._event_types = None
        self._risk_category_types = None
        self._test_categories = None
        self._sort = None
        self.discriminator = None
        if firewall_id is not None:
            self.firewall_id = firewall_id
        if event_object_id is not None:
            self.event_object_id = event_object_id
        if event_time_range is not None:
            self.event_time_range = event_time_range
        if severity is not None:
            self.severity = severity
        if event_types is not None:
            self.event_types = event_types
        if risk_category_types is not None:
            self.risk_category_types = risk_category_types
        if test_categories is not None:
            self.test_categories = test_categories
        if sort is not None:
            self.sort = sort

    @property
    def firewall_id(self):
        """Gets the firewall_id of this RimeListDetectionEventsRequestQuery.  # noqa: E501


        :return: The firewall_id of this RimeListDetectionEventsRequestQuery.  # noqa: E501
        :rtype: RimeUUID
        """
        return self._firewall_id

    @firewall_id.setter
    def firewall_id(self, firewall_id):
        """Sets the firewall_id of this RimeListDetectionEventsRequestQuery.


        :param firewall_id: The firewall_id of this RimeListDetectionEventsRequestQuery.  # noqa: E501
        :type: RimeUUID
        """

        self._firewall_id = firewall_id

    @property
    def event_object_id(self):
        """Gets the event_object_id of this RimeListDetectionEventsRequestQuery.  # noqa: E501

        Optional: return a series of detection events for a single object.  # noqa: E501

        :return: The event_object_id of this RimeListDetectionEventsRequestQuery.  # noqa: E501
        :rtype: str
        """
        return self._event_object_id

    @event_object_id.setter
    def event_object_id(self, event_object_id):
        """Sets the event_object_id of this RimeListDetectionEventsRequestQuery.

        Optional: return a series of detection events for a single object.  # noqa: E501

        :param event_object_id: The event_object_id of this RimeListDetectionEventsRequestQuery.  # noqa: E501
        :type: str
        """

        self._event_object_id = event_object_id

    @property
    def event_time_range(self):
        """Gets the event_time_range of this RimeListDetectionEventsRequestQuery.  # noqa: E501


        :return: The event_time_range of this RimeListDetectionEventsRequestQuery.  # noqa: E501
        :rtype: RimeTimeInterval
        """
        return self._event_time_range

    @event_time_range.setter
    def event_time_range(self, event_time_range):
        """Sets the event_time_range of this RimeListDetectionEventsRequestQuery.


        :param event_time_range: The event_time_range of this RimeListDetectionEventsRequestQuery.  # noqa: E501
        :type: RimeTimeInterval
        """

        self._event_time_range = event_time_range

    @property
    def severity(self):
        """Gets the severity of this RimeListDetectionEventsRequestQuery.  # noqa: E501


        :return: The severity of this RimeListDetectionEventsRequestQuery.  # noqa: E501
        :rtype: RimeSeverity
        """
        return self._severity

    @severity.setter
    def severity(self, severity):
        """Sets the severity of this RimeListDetectionEventsRequestQuery.


        :param severity: The severity of this RimeListDetectionEventsRequestQuery.  # noqa: E501
        :type: RimeSeverity
        """

        self._severity = severity

    @property
    def event_types(self):
        """Gets the event_types of this RimeListDetectionEventsRequestQuery.  # noqa: E501

        Optional: When the list is empty, returns all.  # noqa: E501

        :return: The event_types of this RimeListDetectionEventsRequestQuery.  # noqa: E501
        :rtype: list[DetectionEventType]
        """
        return self._event_types

    @event_types.setter
    def event_types(self, event_types):
        """Sets the event_types of this RimeListDetectionEventsRequestQuery.

        Optional: When the list is empty, returns all.  # noqa: E501

        :param event_types: The event_types of this RimeListDetectionEventsRequestQuery.  # noqa: E501
        :type: list[DetectionEventType]
        """

        self._event_types = event_types

    @property
    def risk_category_types(self):
        """Gets the risk_category_types of this RimeListDetectionEventsRequestQuery.  # noqa: E501

        Optional: When the list is empty, returns all.  # noqa: E501

        :return: The risk_category_types of this RimeListDetectionEventsRequestQuery.  # noqa: E501
        :rtype: list[RiskscoreRiskCategoryType]
        """
        return self._risk_category_types

    @risk_category_types.setter
    def risk_category_types(self, risk_category_types):
        """Sets the risk_category_types of this RimeListDetectionEventsRequestQuery.

        Optional: When the list is empty, returns all.  # noqa: E501

        :param risk_category_types: The risk_category_types of this RimeListDetectionEventsRequestQuery.  # noqa: E501
        :type: list[RiskscoreRiskCategoryType]
        """

        self._risk_category_types = risk_category_types

    @property
    def test_categories(self):
        """Gets the test_categories of this RimeListDetectionEventsRequestQuery.  # noqa: E501

        Optional: When the list is empty, return all.  # noqa: E501

        :return: The test_categories of this RimeListDetectionEventsRequestQuery.  # noqa: E501
        :rtype: list[TestrunTestCategoryType]
        """
        return self._test_categories

    @test_categories.setter
    def test_categories(self, test_categories):
        """Sets the test_categories of this RimeListDetectionEventsRequestQuery.

        Optional: When the list is empty, return all.  # noqa: E501

        :param test_categories: The test_categories of this RimeListDetectionEventsRequestQuery.  # noqa: E501
        :type: list[TestrunTestCategoryType]
        """

        self._test_categories = test_categories

    @property
    def sort(self):
        """Gets the sort of this RimeListDetectionEventsRequestQuery.  # noqa: E501


        :return: The sort of this RimeListDetectionEventsRequestQuery.  # noqa: E501
        :rtype: RimeSortSpec
        """
        return self._sort

    @sort.setter
    def sort(self, sort):
        """Sets the sort of this RimeListDetectionEventsRequestQuery.


        :param sort: The sort of this RimeListDetectionEventsRequestQuery.  # noqa: E501
        :type: RimeSortSpec
        """

        self._sort = sort

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(RimeListDetectionEventsRequestQuery, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, RimeListDetectionEventsRequestQuery):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
