# Generated by Django 4.1.7 on 2023-03-17 15:39

from django.db import migrations, models
import django.db.models.deletion
import taggit.managers
import utilities.json


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('extras', '0084_staging'),
        ('contenttypes', '0002_remove_content_type_name'),
        ('dcim', '0167_module_status'),
        ('virtualization', '0034_standardize_description_comments'),
    ]

    operations = [
        migrations.CreateModel(
            name='Drive',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False)),
                ('created', models.DateTimeField(auto_now_add=True, null=True)),
                ('last_updated', models.DateTimeField(auto_now=True, null=True)),
                ('custom_field_data', models.JSONField(blank=True, default=dict, encoder=utilities.json.CustomFieldJSONEncoder)),
                ('size', models.FloatField()),
                ('identifier', models.CharField(max_length=255)),
                ('description', models.CharField(blank=True, max_length=255)),
                ('cluster', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='cluster_drive', to='virtualization.cluster')),
                ('object_id', models.PositiveBigIntegerField()),
                ('content_type',
                 models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='contenttypes.contenttype')),
                ('tags', taggit.managers.TaggableManager(through='extras.TaggedItem', to='extras.Tag')),
            ],
            options={
                'ordering': ['size'],
            },
        ),
        migrations.CreateModel(
            name='Filesystem',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False)),
                ('created', models.DateTimeField(auto_now_add=True, null=True)),
                ('last_updated', models.DateTimeField(auto_now=True, null=True)),
                ('custom_field_data', models.JSONField(blank=True, default=dict, encoder=utilities.json.CustomFieldJSONEncoder)),
                ('filesystem', models.CharField(max_length=255, unique=True)),
                ('description', models.CharField(blank=True, max_length=255)),
                ('tags', taggit.managers.TaggableManager(through='extras.TaggedItem', to='extras.Tag')),
            ],
            options={
                'ordering': ('filesystem', 'description'),
            },
        ),
        migrations.CreateModel(
            name='LinuxDevice',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False)),
                ('created', models.DateTimeField(auto_now_add=True, null=True)),
                ('last_updated', models.DateTimeField(auto_now=True, null=True)),
                ('custom_field_data', models.JSONField(blank=True, default=dict, encoder=utilities.json.CustomFieldJSONEncoder)),
                ('device', models.CharField(max_length=255)),
                ('type', models.CharField(max_length=255)),
                ('size', models.FloatField()),
                ('object_id', models.PositiveBigIntegerField()),
                ('content_type', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='contenttypes.contenttype')),
                ('tags', taggit.managers.TaggableManager(through='extras.TaggedItem', to='extras.Tag')),
            ],
            options={
                'ordering': ['device', 'type', 'size', 'content_type', 'object_id'],
            },
        ),
        migrations.CreateModel(
            name='VolumeGroup',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False)),
                ('created', models.DateTimeField(auto_now_add=True, null=True)),
                ('last_updated', models.DateTimeField(auto_now=True, null=True)),
                ('custom_field_data', models.JSONField(blank=True, default=dict, encoder=utilities.json.CustomFieldJSONEncoder)),
                ('vg_name', models.CharField(max_length=255)),
                ('description', models.CharField(blank=True, max_length=255)),
                ('tags', taggit.managers.TaggableManager(through='extras.TaggedItem', to='extras.Tag')),
            ],
            options={
                'ordering': ('vg_name', 'description'),
            },
        ),
        migrations.CreateModel(
            name='TemplateConfigurationDrive',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False)),
                ('created', models.DateTimeField(auto_now_add=True, null=True)),
                ('last_updated', models.DateTimeField(auto_now=True, null=True)),
                ('custom_field_data', models.JSONField(blank=True, default=dict, encoder=utilities.json.CustomFieldJSONEncoder)),
                ('drive', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='drive_template_configuration', to='netbox_storage.drive')),
                ('platform', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='platform_template_configuration', to='dcim.platform')),
                ('tags', taggit.managers.TaggableManager(through='extras.TaggedItem', to='extras.Tag')),
            ],
            options={
                'ordering': ['platform', 'drive'],
            },
        ),
        migrations.CreateModel(
            name='StorageConfigurationDrive',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False)),
                ('created', models.DateTimeField(auto_now_add=True, null=True)),
                ('last_updated', models.DateTimeField(auto_now=True, null=True)),
                ('custom_field_data', models.JSONField(blank=True, default=dict, encoder=utilities.json.CustomFieldJSONEncoder)),
                ('drive', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='drive_storage_configuration', to='netbox_storage.drive')),
                ('tags', taggit.managers.TaggableManager(through='extras.TaggedItem', to='extras.Tag')),
                ('virtual_machine', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='virtual_machine_storage_configuration', to='virtualization.virtualmachine')),
            ],
            options={
                'ordering': ['virtual_machine', 'drive'],
            },
        ),
        migrations.CreateModel(
            name='PhysicalVolume',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False)),
                ('created', models.DateTimeField(auto_now_add=True, null=True)),
                ('last_updated', models.DateTimeField(auto_now=True, null=True)),
                ('custom_field_data', models.JSONField(blank=True, default=dict, encoder=utilities.json.CustomFieldJSONEncoder)),
                ('description', models.CharField(blank=True, max_length=255)),
                ('linux_device', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='linux_device_physicalvolume', to='netbox_storage.linuxdevice')),
                ('tags', taggit.managers.TaggableManager(through='extras.TaggedItem', to='extras.Tag')),
                ('vg', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='volumegroup_physicalvolume', to='netbox_storage.volumegroup')),
            ],
            options={
                'ordering': ('linux_device', 'description'),
            },
        ),
        migrations.CreateModel(
            name='Partition',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False)),
                ('created', models.DateTimeField(auto_now_add=True, null=True)),
                ('last_updated', models.DateTimeField(auto_now=True, null=True)),
                ('custom_field_data', models.JSONField(blank=True, default=dict, encoder=utilities.json.CustomFieldJSONEncoder)),
                ('size', models.FloatField()),
                ('letter', models.CharField(max_length=255)),
                ('description', models.CharField(blank=True, max_length=255)),
                ('drive', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='drive_partition', to='netbox_storage.drive')),
                ('fs_type', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='fs_partition', to='netbox_storage.filesystem')),
                ('tags', taggit.managers.TaggableManager(through='extras.TaggedItem', to='extras.Tag')),
            ],
            options={
                'ordering': ['drive', 'size', 'fs_type', 'letter', 'description'],
            },
        ),
        migrations.CreateModel(
            name='MountedVolume',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False)),
                ('created', models.DateTimeField(auto_now_add=True, null=True)),
                ('last_updated', models.DateTimeField(auto_now=True, null=True)),
                ('custom_field_data', models.JSONField(blank=True, default=dict, encoder=utilities.json.CustomFieldJSONEncoder)),
                ('mount_point', models.CharField(max_length=255)),
                ('options', models.CharField(blank=True, default='defaults', max_length=255)),
                ('description', models.CharField(blank=True, max_length=255)),
                ('fs_type', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='fs_mounted_volume', to='netbox_storage.filesystem')),
                ('linux_device', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='linux_device_mounted_volume', to='netbox_storage.linuxdevice')),
                ('tags', taggit.managers.TaggableManager(through='extras.TaggedItem', to='extras.Tag')),
            ],
            options={
                'ordering': ('linux_device', 'mount_point', 'fs_type', 'options', 'description'),
            },
        ),
        migrations.CreateModel(
            name='LogicalVolume',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False)),
                ('created', models.DateTimeField(auto_now_add=True, null=True)),
                ('last_updated', models.DateTimeField(auto_now=True, null=True)),
                ('custom_field_data', models.JSONField(blank=True, default=dict, encoder=utilities.json.CustomFieldJSONEncoder)),
                ('lv_name', models.CharField(max_length=255)),
                ('size', models.FloatField()),
                ('description', models.CharField(blank=True, max_length=255)),
                ('tags', taggit.managers.TaggableManager(through='extras.TaggedItem', to='extras.Tag')),
                ('vg', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='volumegroup_logicalvolume', to='netbox_storage.volumegroup')),
            ],
            options={
                'ordering': ('lv_name', 'description'),
            },
        ),
    ]
