from javaman import JManCon


class Pobles:
    url_pobles = '/pobles'

    def __init__(self, con: JManCon):
        self._con = con

    def list(self):
        res = self._con.get(url=self.url_pobles)
        return res.json()

    def get(self, poble_id: int):
        res = self._con.get(url=self.url_pobles + '/' + str(poble_id))
        return res.json()

    def crear(self, poble: dict):
        res = self._con.post(url=self.url_pobles, data=poble)
        return res.json()

    def troba(self, provincia_id: int, poble: str):
        tmp_url = self.url_pobles + '?poble_nom=' + poble + '&provincia_id=' + str(provincia_id)
        response = self._con.get(url=tmp_url)
        if response.status_code == 200:
            return response.json()
