# dofusdude
The last API for everything Dofus 🤯

### JS Quickstart
```js
var dofusdude = require("dofusdude-js");

new dofusdude.AllItemsApi().getItemsAllSearch(
  "en",
  "dofus2",
  "nidas",
  { filterTypeName: "hat" },
  (err, data, response) => {
    console.log(data[0]);
  }
);
```

### Client SDKs
- [Javascript](https://github.com/dofusdude/dofusdude-js) npm i dofusdude-js --save
- [Typescript](https://github.com/dofusdude/dofusdude-ts) npm i dofusdude-ts --save
- [Go](https://github.com/dofusdude/dodugo) go get -u github.com/dofusdude/dodugo
- [Python](https://github.com/dofusdude/dofusdude-py) pip install dofusdude

Everything, including this site, is generated out of the [Docs Repo](https://github.com/dofusdude/api-docs). Consider it the Single Source of Truth. If there is a problem with the SDKs, create an issue at the Docs Repo.

## Main Features
- 🥷 **seamless auto-update** load data in the background when a new Dofus version is released and serving it within 2 minutes with atomic data source switching. No downtime and no effects for the user, just always up-to-date.

- ⚡ **blazingly fast** all data in-memory, aggressive caching over short time spans, HTTP/2 multiplexing, written in Go, optimized for low latency, hosted on bare metal in 🇩🇪.

- 🩸 **Dofus 2 Beta** from stable to bleeding edge by replacing /dofus2 with /dofus2beta.

- 🗣️ **multilingual** supporting _en_, _fr_, _es_, _pt_ including the dropped languages from the Dofus website _de_ and _it_.

- 🧠 **search by relevance** allowing typos in name and description, handled by language specific text analysis and indexing by the powerful [Meilisearch](https://www.meilisearch.com) written in Rust.

- 🕵️ **complete** actual data from the game including items invisible to the encyclopedia like quest items.

- 🖼️ **HD images** rendering vector graphics into PNGs up to 800x800 px in the background.


## Current state
- Weapons ✅
- Equipment ✅
- Sets ✅
- Resources ✅
- Consumables ✅
- Pets ✅
- Mounts ✅
- Cosmetics/Ceremonial Items ✅
- Harnesses ✅
- Quest Items ✅
- Almanax ✅

- Monsters ❌
- Classes ❌
- Spells ❌
- Professions ❌


### Maybes? I don't know what for 🤷
- Sidekicks ❌
- Haven Bags ❌
- Map ❌


## Future
I want this project to be useful and not just add plain categories no one needs. More and more features will be added to enhance the quality based on the needs of you, the developers.

Examples:
_I need to know where I can drop the all the items I need to craft set X!_

_Please get a detailed always up-to-date spell description so I can calculate the damage for my set builder site!_

Nearly everything can be done. But I want to make sure somebody also wants it.

If you have anything or you are just interested in the project, join the [Discord](https://discord.gg/3EtHskZD8h).

### Versioning
Updating an API is a hard problem. This is why we'll keep it simple:

Everything you see here on this site, you can use now and forever. Updates could introduce new fields, new paths or parameter but never break backwards compatibility, so no field or parameter will be deleted. Ever.

There is one exception! **The API will _always_ choose being up-to-date over everything else**. So if Ankama decides to drop languages from the game like they did with their website, the API will loose support for them, too.

We can prevent this specific use case with a nice community but even then, it would be hidden behind a feature flag.

## Get started! 🥳
Scroll down and try it for yourself!

If you are ready to use them in your project, think about [generating a client 🧙](https://github.com/OpenAPITools/openapi-generator) or use one of our pre generated SDKs linked at the top.

Awesome Projects using this API:

- [KaellyBot](https://github.com/Kaysoro/KaellyBot) by Kaysoro
- [Dofus Craftlist](https://dofuscraftlist-dev.netlify.app) by Lystina
- [AlmanaxApp](https://almanaxapp.netlify.app) by Lystina
- [luwnarya.fr](https://luwnarya.fr)



This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 0.5.5
- Package version: 0.5.5
- Build package: org.openapitools.codegen.languages.PythonClientCodegen
For more information, please visit [https://discord.gg/3EtHskZD8h](https://discord.gg/3EtHskZD8h)

## Requirements.

Python >=3.6

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/dofusdude/dofusdude-py.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/dofusdude/dofusdude-py.git`)

Then import the package:
```python
import dofusdude
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import dofusdude
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python

import time
import dofusdude
from pprint import pprint
from dofusdude.api import all_items_api
from dofusdude.model.items_list_entry_typed import ItemsListEntryTyped
# Defining the host is optional and defaults to https://api.dofusdu.de
# See configuration.py for a list of all supported configuration parameters.
configuration = dofusdude.Configuration(
    host = "https://api.dofusdu.de"
)



# Enter a context with an instance of the API client
with dofusdude.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = all_items_api.AllItemsApi(api_client)
    language = "en" # str | a valid language code
    game = "dofus2" # str | 
    query = "hat" # str | case sensitive search query
    filter_type_name = "filter[type_name]_example" # str | only results with the translated type name across all item_subtypes (optional)
    filter_min_level = 1 # int | only results which level is equal or above this value (optional)
    filter_max_level = 1 # int | only results which level is equal or below this value (optional)

    try:
        # Search All Items
        api_response = api_instance.get_items_all_search(language, game, query, filter_type_name=filter_type_name, filter_min_level=filter_min_level, filter_max_level=filter_max_level)
        pprint(api_response)
    except dofusdude.ApiException as e:
        print("Exception when calling AllItemsApi->get_items_all_search: %s\n" % e)
```

## Documentation for API Endpoints

All URIs are relative to *https://api.dofusdu.de*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*AllItemsApi* | [**get_items_all_search**](docs/AllItemsApi.md#get_items_all_search) | **GET** /{game}/{language}/items/search | Search All Items
*AlmanaxApi* | [**get_almanax_date**](docs/AlmanaxApi.md#get_almanax_date) | **GET** /dofus2/{language}/almanax/{date} | Single Almanax Date
*AlmanaxApi* | [**get_almanax_range**](docs/AlmanaxApi.md#get_almanax_range) | **GET** /dofus2/{language}/almanax | Almanax Range
*ConsumablesApi* | [**get_items_consumables_list**](docs/ConsumablesApi.md#get_items_consumables_list) | **GET** /{game}/{language}/items/consumables | List Consumables
*ConsumablesApi* | [**get_items_consumables_search**](docs/ConsumablesApi.md#get_items_consumables_search) | **GET** /{game}/{language}/items/consumables/search | Search Consumables
*ConsumablesApi* | [**get_items_consumables_single**](docs/ConsumablesApi.md#get_items_consumables_single) | **GET** /{game}/{language}/items/consumables/{ankama_id} | Single Consumables
*CosmeticsApi* | [**get_cosmetics_list**](docs/CosmeticsApi.md#get_cosmetics_list) | **GET** /{game}/{language}/items/cosmetics | List Cosmetics
*CosmeticsApi* | [**get_cosmetics_search**](docs/CosmeticsApi.md#get_cosmetics_search) | **GET** /{game}/{language}/items/cosmetics/search | Search Cosmetics
*CosmeticsApi* | [**get_cosmetics_single**](docs/CosmeticsApi.md#get_cosmetics_single) | **GET** /{game}/{language}/items/cosmetics/{ankama_id} | Single Cosmetics
*EquipmentApi* | [**get_items_equipment_list**](docs/EquipmentApi.md#get_items_equipment_list) | **GET** /{game}/{language}/items/equipment | List Equipment
*EquipmentApi* | [**get_items_equipment_search**](docs/EquipmentApi.md#get_items_equipment_search) | **GET** /{game}/{language}/items/equipment/search | Search Equipment
*EquipmentApi* | [**get_items_equipment_single**](docs/EquipmentApi.md#get_items_equipment_single) | **GET** /{game}/{language}/items/equipment/{ankama_id} | Single Equipment
*MetaApi* | [**get_meta_almanax_bonuses**](docs/MetaApi.md#get_meta_almanax_bonuses) | **GET** /dofus2/meta/{language}/almanax/bonuses | Available Almanax Bonuses
*MetaApi* | [**get_meta_elements**](docs/MetaApi.md#get_meta_elements) | **GET** /dofus2/meta/elements | Effects and Condition Elements
*MountsApi* | [**get_mounts_list**](docs/MountsApi.md#get_mounts_list) | **GET** /{game}/{language}/mounts | List Mounts
*MountsApi* | [**get_mounts_search**](docs/MountsApi.md#get_mounts_search) | **GET** /{game}/{language}/mounts/search | Search Mounts
*MountsApi* | [**get_mounts_single**](docs/MountsApi.md#get_mounts_single) | **GET** /{game}/{language}/mounts/{ankama_id} | Single Mounts
*QuestItemsApi* | [**get_item_quest_single**](docs/QuestItemsApi.md#get_item_quest_single) | **GET** /{game}/{language}/items/quest/{ankama_id} | Single Quest Items
*QuestItemsApi* | [**get_items_quest_list**](docs/QuestItemsApi.md#get_items_quest_list) | **GET** /{game}/{language}/items/quest | List Quest Items
*QuestItemsApi* | [**get_items_quest_search**](docs/QuestItemsApi.md#get_items_quest_search) | **GET** /{game}/{language}/items/quest/search | Search Quest Items
*ResourcesApi* | [**get_items_resource_search**](docs/ResourcesApi.md#get_items_resource_search) | **GET** /{game}/{language}/items/resources/search | Search Resources
*ResourcesApi* | [**get_items_resources_list**](docs/ResourcesApi.md#get_items_resources_list) | **GET** /{game}/{language}/items/resources | List Resources
*ResourcesApi* | [**get_items_resources_single**](docs/ResourcesApi.md#get_items_resources_single) | **GET** /{game}/{language}/items/resources/{ankama_id} | Single Resources
*SetsApi* | [**get_sets_list**](docs/SetsApi.md#get_sets_list) | **GET** /{game}/{language}/sets | List Sets
*SetsApi* | [**get_sets_search**](docs/SetsApi.md#get_sets_search) | **GET** /{game}/{language}/sets/search | Search Sets
*SetsApi* | [**get_sets_single**](docs/SetsApi.md#get_sets_single) | **GET** /{game}/{language}/sets/{ankama_id} | Single Sets


## Documentation For Models

 - [AlmanaxEntry](docs/AlmanaxEntry.md)
 - [AlmanaxEntryBonus](docs/AlmanaxEntryBonus.md)
 - [AlmanaxEntryTribute](docs/AlmanaxEntryTribute.md)
 - [AlmanaxEntryTributeItem](docs/AlmanaxEntryTributeItem.md)
 - [ConditionEntry](docs/ConditionEntry.md)
 - [Cosmetic](docs/Cosmetic.md)
 - [EffectsEntry](docs/EffectsEntry.md)
 - [EffectsEntryType](docs/EffectsEntryType.md)
 - [Equipment](docs/Equipment.md)
 - [EquipmentParentSet](docs/EquipmentParentSet.md)
 - [EquipmentSet](docs/EquipmentSet.md)
 - [GetMetaAlmanaxBonuses200ResponseInner](docs/GetMetaAlmanaxBonuses200ResponseInner.md)
 - [ImageUrls](docs/ImageUrls.md)
 - [ItemListEntry](docs/ItemListEntry.md)
 - [ItemsListEntryTyped](docs/ItemsListEntryTyped.md)
 - [ItemsListEntryTypedType](docs/ItemsListEntryTypedType.md)
 - [ItemsListPaged](docs/ItemsListPaged.md)
 - [LinksPaged](docs/LinksPaged.md)
 - [Mount](docs/Mount.md)
 - [MountListEntry](docs/MountListEntry.md)
 - [MountsListPaged](docs/MountsListPaged.md)
 - [RecipeEntry](docs/RecipeEntry.md)
 - [Resource](docs/Resource.md)
 - [SetListEntry](docs/SetListEntry.md)
 - [SetsListPaged](docs/SetsListPaged.md)
 - [Weapon](docs/Weapon.md)
 - [WeaponRange](docs/WeaponRange.md)


## Documentation For Authorization

 All endpoints do not require authorization.

## Author

stelzo@steado.de


## Notes for Large OpenAPI documents
If the OpenAPI document is large, imports in dofusdude.apis and dofusdude.models may fail with a
RecursionError indicating the maximum recursion limit has been exceeded. In that case, there are a couple of solutions:

Solution 1:
Use specific imports for apis and models like:
- `from dofusdude.api.default_api import DefaultApi`
- `from dofusdude.model.pet import Pet`

Solution 2:
Before importing the package, adjust the maximum recursion limit as shown below:
```
import sys
sys.setrecursionlimit(1500)
import dofusdude
from dofusdude.apis import *
from dofusdude.models import *
```

