"""
    Dofusdude

    The last API for everything Dofus 🤯  ### JS Quickstart ```js var dofusdude = require(\"dofusdude-js\");  new dofusdude.AllItemsApi().getItemsAllSearch(   \"en\",   \"dofus2\",   \"nidas\",   { filterTypeName: \"hat\" },   (err, data, response) => {     console.log(data[0]);   } ); ```  ### Client SDKs - [Javascript](https://github.com/dofusdude/dofusdude-js) npm i dofusdude-js --save - [Typescript](https://github.com/dofusdude/dofusdude-ts) npm i dofusdude-ts --save - [Go](https://github.com/dofusdude/dodugo) go get -u github.com/dofusdude/dodugo - [Python](https://github.com/dofusdude/dofusdude-py) pip install dofusdude  Everything, including this site, is generated out of the [Docs Repo](https://github.com/dofusdude/api-docs). Consider it the Single Source of Truth. If there is a problem with the SDKs, create an issue at the Docs Repo.  ## Main Features - 🥷 **seamless auto-update** load data in the background when a new Dofus version is released and serving it within 2 minutes with atomic data source switching. No downtime and no effects for the user, just always up-to-date.  - ⚡ **blazingly fast** all data in-memory, aggressive caching over short time spans, HTTP/2 multiplexing, written in Go, optimized for low latency, hosted on bare metal in 🇩🇪.  - 🩸 **Dofus 2 Beta** from stable to bleeding edge by replacing /dofus2 with /dofus2beta.  - 🗣️ **multilingual** supporting _en_, _fr_, _es_, _pt_ including the dropped languages from the Dofus website _de_ and _it_.  - 🧠 **search by relevance** allowing typos in name and description, handled by language specific text analysis and indexing by the powerful [Meilisearch](https://www.meilisearch.com) written in Rust.  - 🕵️ **complete** actual data from the game including items invisible to the encyclopedia like quest items.  - 🖼️ **HD images** rendering vector graphics into PNGs up to 800x800 px in the background.   ## Current state - Weapons ✅ - Equipment ✅ - Sets ✅ - Resources ✅ - Consumables ✅ - Pets ✅ - Mounts ✅ - Cosmetics/Ceremonial Items ✅ - Harnesses ✅ - Quest Items ✅ - Almanax ✅  - Monsters ❌ - Classes ❌ - Spells ❌ - Professions ❌   ### Maybes? I don't know what for 🤷 - Sidekicks ❌ - Haven Bags ❌ - Map ❌   ## Future I want this project to be useful and not just add plain categories no one needs. More and more features will be added to enhance the quality based on the needs of you, the developers.  Examples: _I need to know where I can drop the all the items I need to craft set X!_  _Please get a detailed always up-to-date spell description so I can calculate the damage for my set builder site!_  Nearly everything can be done. But I want to make sure somebody also wants it.  If you have anything or you are just interested in the project, join the [Discord](https://discord.gg/3EtHskZD8h).  ### Versioning Updating an API is a hard problem. This is why we'll keep it simple:  Everything you see here on this site, you can use now and forever. Updates could introduce new fields, new paths or parameter but never break backwards compatibility, so no field or parameter will be deleted. Ever.  There is one exception! **The API will _always_ choose being up-to-date over everything else**. So if Ankama decides to drop languages from the game like they did with their website, the API will loose support for them, too.  We can prevent this specific use case with a nice community but even then, it would be hidden behind a feature flag.  ## Get started! 🥳 Scroll down and try it for yourself!  If you are ready to use them in your project, think about [generating a client 🧙](https://github.com/OpenAPITools/openapi-generator) or use one of our pre generated SDKs linked at the top.  Awesome Projects using this API:  - [KaellyBot](https://github.com/Kaysoro/KaellyBot) by Kaysoro - [Dofus Craftlist](https://dofuscraftlist-dev.netlify.app) by Lystina - [AlmanaxApp](https://almanaxapp.netlify.app) by Lystina - [luwnarya.fr](https://luwnarya.fr)    # noqa: E501

    The version of the OpenAPI document: 0.5.5
    Contact: stelzo@steado.de
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from dofusdude.api_client import ApiClient, Endpoint as _Endpoint
from dofusdude.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from dofusdude.model.equipment_set import EquipmentSet
from dofusdude.model.set_list_entry import SetListEntry
from dofusdude.model.sets_list_paged import SetsListPaged


class SetsApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client
        self.get_sets_list_endpoint = _Endpoint(
            settings={
                'response_type': (SetsListPaged,),
                'auth': [],
                'endpoint_path': '/{game}/{language}/sets',
                'operation_id': 'get_sets_list',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'language',
                    'game',
                    'sort_level',
                    'filter_min_highest_equipment_level',
                    'filter_max_highest_equipment_level',
                    'page_size',
                    'page_number',
                ],
                'required': [
                    'language',
                    'game',
                ],
                'nullable': [
                ],
                'enum': [
                    'language',
                    'game',
                    'sort_level',
                ],
                'validation': [
                    'language',
                    'filter_min_highest_equipment_level',
                    'filter_max_highest_equipment_level',
                    'page_size',
                    'page_number',
                ]
            },
            root_map={
                'validations': {
                    ('language',): {
                        'max_length': 2,
                        'min_length': 2,
                    },
                    ('filter_min_highest_equipment_level',): {

                        'inclusive_minimum': 0,
                    },
                    ('filter_max_highest_equipment_level',): {

                        'inclusive_minimum': 0,
                    },
                    ('page_size',): {

                        'inclusive_minimum': -1,
                    },
                    ('page_number',): {

                        'inclusive_minimum': 0,
                    },
                },
                'allowed_values': {
                    ('language',): {

                        "EN": "en",
                        "FR": "fr",
                        "DE": "de",
                        "IT": "it",
                        "ES": "es",
                        "PT": "pt"
                    },
                    ('game',): {

                        "DOFUS2": "dofus2",
                        "DOFUS2BETA": "dofus2beta"
                    },
                    ('sort_level',): {

                        "ASC": "asc",
                        "DESC": "desc"
                    },
                },
                'openapi_types': {
                    'language':
                        (str,),
                    'game':
                        (str,),
                    'sort_level':
                        (str,),
                    'filter_min_highest_equipment_level':
                        (int,),
                    'filter_max_highest_equipment_level':
                        (int,),
                    'page_size':
                        (int,),
                    'page_number':
                        (int,),
                },
                'attribute_map': {
                    'language': 'language',
                    'game': 'game',
                    'sort_level': 'sort[level]',
                    'filter_min_highest_equipment_level': 'filter[min_highest_equipment_level]',
                    'filter_max_highest_equipment_level': 'filter[max_highest_equipment_level]',
                    'page_size': 'page[size]',
                    'page_number': 'page[number]',
                },
                'location_map': {
                    'language': 'path',
                    'game': 'path',
                    'sort_level': 'query',
                    'filter_min_highest_equipment_level': 'query',
                    'filter_max_highest_equipment_level': 'query',
                    'page_size': 'query',
                    'page_number': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_sets_search_endpoint = _Endpoint(
            settings={
                'response_type': ([SetListEntry],),
                'auth': [],
                'endpoint_path': '/{game}/{language}/sets/search',
                'operation_id': 'get_sets_search',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'language',
                    'game',
                    'query',
                    'filter_min_highest_equipment_level',
                    'filter_max_highest_equipment_level',
                ],
                'required': [
                    'language',
                    'game',
                    'query',
                ],
                'nullable': [
                ],
                'enum': [
                    'language',
                    'game',
                ],
                'validation': [
                    'language',
                ]
            },
            root_map={
                'validations': {
                    ('language',): {
                        'max_length': 2,
                        'min_length': 2,
                    },
                },
                'allowed_values': {
                    ('language',): {

                        "EN": "en",
                        "FR": "fr",
                        "DE": "de",
                        "IT": "it",
                        "ES": "es",
                        "PT": "pt"
                    },
                    ('game',): {

                        "DOFUS2": "dofus2",
                        "DOFUS2BETA": "dofus2beta"
                    },
                },
                'openapi_types': {
                    'language':
                        (str,),
                    'game':
                        (str,),
                    'query':
                        (str,),
                    'filter_min_highest_equipment_level':
                        (int,),
                    'filter_max_highest_equipment_level':
                        (int,),
                },
                'attribute_map': {
                    'language': 'language',
                    'game': 'game',
                    'query': 'query',
                    'filter_min_highest_equipment_level': 'filter[min_highest_equipment_level]',
                    'filter_max_highest_equipment_level': 'filter[max_highest_equipment_level]',
                },
                'location_map': {
                    'language': 'path',
                    'game': 'path',
                    'query': 'query',
                    'filter_min_highest_equipment_level': 'query',
                    'filter_max_highest_equipment_level': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_sets_single_endpoint = _Endpoint(
            settings={
                'response_type': (EquipmentSet,),
                'auth': [],
                'endpoint_path': '/{game}/{language}/sets/{ankama_id}',
                'operation_id': 'get_sets_single',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'language',
                    'ankama_id',
                    'game',
                ],
                'required': [
                    'language',
                    'ankama_id',
                    'game',
                ],
                'nullable': [
                ],
                'enum': [
                    'language',
                    'game',
                ],
                'validation': [
                    'language',
                ]
            },
            root_map={
                'validations': {
                    ('language',): {
                        'max_length': 2,
                        'min_length': 2,
                    },
                },
                'allowed_values': {
                    ('language',): {

                        "EN": "en",
                        "FR": "fr",
                        "DE": "de",
                        "IT": "it",
                        "ES": "es",
                        "PT": "pt"
                    },
                    ('game',): {

                        "DOFUS2": "dofus2",
                        "DOFUS2BETA": "dofus2beta"
                    },
                },
                'openapi_types': {
                    'language':
                        (str,),
                    'ankama_id':
                        (int,),
                    'game':
                        (str,),
                },
                'attribute_map': {
                    'language': 'language',
                    'ankama_id': 'ankama_id',
                    'game': 'game',
                },
                'location_map': {
                    'language': 'path',
                    'ankama_id': 'path',
                    'game': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )

    def get_sets_list(
        self,
        language,
        game,
        **kwargs
    ):
        """List Sets  # noqa: E501

        Retrieve a list of sets.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_sets_list(language, game, async_req=True)
        >>> result = thread.get()

        Args:
            language (str): a valid language code
            game (str):

        Keyword Args:
            sort_level (str): sort the resulting list by level, default unsorted. [optional]
            filter_min_highest_equipment_level (int): only results where the equipment with the highest level is above or equal to this value. [optional]
            filter_max_highest_equipment_level (int): only results where the equipment with the highest level is below or equal to this value. [optional]
            page_size (int): size of the results from the list. -1 disables pagination and gets all in one response.. [optional]
            page_number (int): page number based on the current page[size]. So you could get page 1 with 8 entrys and page 2 would have entries 8 to 16.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            SetsListPaged
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['language'] = \
            language
        kwargs['game'] = \
            game
        return self.get_sets_list_endpoint.call_with_http_info(**kwargs)

    def get_sets_search(
        self,
        language,
        game,
        query,
        **kwargs
    ):
        """Search Sets  # noqa: E501

        Search in all names and descriptions of sets with a query.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_sets_search(language, game, query, async_req=True)
        >>> result = thread.get()

        Args:
            language (str): a valid language code
            game (str):
            query (str): case sensitive search query

        Keyword Args:
            filter_min_highest_equipment_level (int): only results where the equipment with the highest level is above or equal to this value. [optional]
            filter_max_highest_equipment_level (int): only results where the equipment with the highest level is below or equal to this value. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            [SetListEntry]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['language'] = \
            language
        kwargs['game'] = \
            game
        kwargs['query'] = \
            query
        return self.get_sets_search_endpoint.call_with_http_info(**kwargs)

    def get_sets_single(
        self,
        language,
        ankama_id,
        game,
        **kwargs
    ):
        """Single Sets  # noqa: E501

        Retrieve a specific set with id.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_sets_single(language, ankama_id, game, async_req=True)
        >>> result = thread.get()

        Args:
            language (str): a valid language code
            ankama_id (int): identifier
            game (str):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            EquipmentSet
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['language'] = \
            language
        kwargs['ankama_id'] = \
            ankama_id
        kwargs['game'] = \
            game
        return self.get_sets_single_endpoint.call_with_http_info(**kwargs)

