# ory-hydra-client
Welcome to the ORY Hydra HTTP API documentation. You will find documentation for all HTTP APIs here.

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: latest
- Package version: v1.4.1
- Build package: org.openapitools.codegen.languages.PythonClientCodegen

## Requirements.

Python 2.7 and 3.4+

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/ory/sdk.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/ory/sdk.git`)

Then import the package:
```python
import ory_hydra_client
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import ory_hydra_client
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python
from __future__ import print_function
import time
import ory_hydra_client
from ory_hydra_client.rest import ApiException
from pprint import pprint


# Defining host is optional and default to http://localhost
configuration.host = "http://localhost"
# Enter a context with an instance of the API client
with ory_hydra_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = ory_hydra_client.AdminApi(api_client)
    consent_challenge = 'consent_challenge_example' # str | 
body = ory_hydra_client.AcceptConsentRequest() # AcceptConsentRequest |  (optional)

    try:
        # Accept a consent request
        api_response = api_instance.accept_consent_request(consent_challenge, body=body)
        pprint(api_response)
    except ApiException as e:
        print("Exception when calling AdminApi->accept_consent_request: %s\n" % e)
    
```

## Documentation for API Endpoints

All URIs are relative to *http://localhost*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*AdminApi* | [**accept_consent_request**](docs/AdminApi.md#accept_consent_request) | **PUT** /oauth2/auth/requests/consent/accept | Accept a consent request
*AdminApi* | [**accept_login_request**](docs/AdminApi.md#accept_login_request) | **PUT** /oauth2/auth/requests/login/accept | Accept a login request
*AdminApi* | [**accept_logout_request**](docs/AdminApi.md#accept_logout_request) | **PUT** /oauth2/auth/requests/logout/accept | Accept a logout request
*AdminApi* | [**create_json_web_key_set**](docs/AdminApi.md#create_json_web_key_set) | **POST** /keys/{set} | Generate a new JSON Web Key
*AdminApi* | [**create_o_auth2_client**](docs/AdminApi.md#create_o_auth2_client) | **POST** /clients | Create an OAuth 2.0 client
*AdminApi* | [**delete_json_web_key**](docs/AdminApi.md#delete_json_web_key) | **DELETE** /keys/{set}/{kid} | Delete a JSON Web Key
*AdminApi* | [**delete_json_web_key_set**](docs/AdminApi.md#delete_json_web_key_set) | **DELETE** /keys/{set} | Delete a JSON Web Key Set
*AdminApi* | [**delete_o_auth2_client**](docs/AdminApi.md#delete_o_auth2_client) | **DELETE** /clients/{id} | Deletes an OAuth 2.0 Client
*AdminApi* | [**flush_inactive_o_auth2_tokens**](docs/AdminApi.md#flush_inactive_o_auth2_tokens) | **POST** /oauth2/flush | Flush Expired OAuth2 Access Tokens
*AdminApi* | [**get_consent_request**](docs/AdminApi.md#get_consent_request) | **GET** /oauth2/auth/requests/consent | Get consent request information
*AdminApi* | [**get_json_web_key**](docs/AdminApi.md#get_json_web_key) | **GET** /keys/{set}/{kid} | Fetch a JSON Web Key
*AdminApi* | [**get_json_web_key_set**](docs/AdminApi.md#get_json_web_key_set) | **GET** /keys/{set} | Retrieve a JSON Web Key Set
*AdminApi* | [**get_login_request**](docs/AdminApi.md#get_login_request) | **GET** /oauth2/auth/requests/login | Get a login request
*AdminApi* | [**get_logout_request**](docs/AdminApi.md#get_logout_request) | **GET** /oauth2/auth/requests/logout | Get a logout request
*AdminApi* | [**get_o_auth2_client**](docs/AdminApi.md#get_o_auth2_client) | **GET** /clients/{id} | Get an OAuth 2.0 Client.
*AdminApi* | [**get_version**](docs/AdminApi.md#get_version) | **GET** /version | Get service version
*AdminApi* | [**introspect_o_auth2_token**](docs/AdminApi.md#introspect_o_auth2_token) | **POST** /oauth2/introspect | Introspect OAuth2 tokens
*AdminApi* | [**is_instance_alive**](docs/AdminApi.md#is_instance_alive) | **GET** /health/alive | Check alive status
*AdminApi* | [**list_o_auth2_clients**](docs/AdminApi.md#list_o_auth2_clients) | **GET** /clients | List OAuth 2.0 Clients
*AdminApi* | [**list_subject_consent_sessions**](docs/AdminApi.md#list_subject_consent_sessions) | **GET** /oauth2/auth/sessions/consent | Lists all consent sessions of a subject
*AdminApi* | [**prometheus**](docs/AdminApi.md#prometheus) | **GET** /metrics/prometheus | Get snapshot metrics from the Hydra service. If you&#39;re using k8s, you can then add annotations to your deployment like so:
*AdminApi* | [**reject_consent_request**](docs/AdminApi.md#reject_consent_request) | **PUT** /oauth2/auth/requests/consent/reject | Reject a consent request
*AdminApi* | [**reject_login_request**](docs/AdminApi.md#reject_login_request) | **PUT** /oauth2/auth/requests/login/reject | Reject a login request
*AdminApi* | [**reject_logout_request**](docs/AdminApi.md#reject_logout_request) | **PUT** /oauth2/auth/requests/logout/reject | Reject a logout request
*AdminApi* | [**revoke_authentication_session**](docs/AdminApi.md#revoke_authentication_session) | **DELETE** /oauth2/auth/sessions/login | Invalidates all login sessions of a certain user Invalidates a subject&#39;s authentication session
*AdminApi* | [**revoke_consent_sessions**](docs/AdminApi.md#revoke_consent_sessions) | **DELETE** /oauth2/auth/sessions/consent | Revokes consent sessions of a subject for a specific OAuth 2.0 Client
*AdminApi* | [**update_json_web_key**](docs/AdminApi.md#update_json_web_key) | **PUT** /keys/{set}/{kid} | Update a JSON Web Key
*AdminApi* | [**update_json_web_key_set**](docs/AdminApi.md#update_json_web_key_set) | **PUT** /keys/{set} | Update a JSON Web Key Set
*AdminApi* | [**update_o_auth2_client**](docs/AdminApi.md#update_o_auth2_client) | **PUT** /clients/{id} | Update an OAuth 2.0 Client
*PublicApi* | [**disconnect_user**](docs/PublicApi.md#disconnect_user) | **GET** /oauth2/sessions/logout | OpenID Connect Front-Backchannel enabled Logout
*PublicApi* | [**discover_open_id_configuration**](docs/PublicApi.md#discover_open_id_configuration) | **GET** /.well-known/openid-configuration | OpenID Connect Discovery
*PublicApi* | [**is_instance_ready**](docs/PublicApi.md#is_instance_ready) | **GET** /health/ready | Check readiness status
*PublicApi* | [**oauth2_token**](docs/PublicApi.md#oauth2_token) | **POST** /oauth2/token | The OAuth 2.0 token endpoint
*PublicApi* | [**oauth_auth**](docs/PublicApi.md#oauth_auth) | **GET** /oauth2/auth | The OAuth 2.0 authorize endpoint
*PublicApi* | [**revoke_o_auth2_token**](docs/PublicApi.md#revoke_o_auth2_token) | **POST** /oauth2/revoke | Revoke OAuth2 tokens
*PublicApi* | [**userinfo**](docs/PublicApi.md#userinfo) | **GET** /userinfo | OpenID Connect Userinfo
*PublicApi* | [**well_known**](docs/PublicApi.md#well_known) | **GET** /.well-known/jwks.json | JSON Web Keys Discovery


## Documentation For Models

 - [AcceptConsentRequest](docs/AcceptConsentRequest.md)
 - [AcceptLoginRequest](docs/AcceptLoginRequest.md)
 - [CompletedRequest](docs/CompletedRequest.md)
 - [ConsentRequest](docs/ConsentRequest.md)
 - [ConsentRequestSession](docs/ConsentRequestSession.md)
 - [FlushInactiveOAuth2TokensRequest](docs/FlushInactiveOAuth2TokensRequest.md)
 - [GenericError](docs/GenericError.md)
 - [HealthNotReadyStatus](docs/HealthNotReadyStatus.md)
 - [HealthStatus](docs/HealthStatus.md)
 - [JSONWebKey](docs/JSONWebKey.md)
 - [JSONWebKeySet](docs/JSONWebKeySet.md)
 - [JsonWebKeySetGeneratorRequest](docs/JsonWebKeySetGeneratorRequest.md)
 - [LoginRequest](docs/LoginRequest.md)
 - [LogoutRequest](docs/LogoutRequest.md)
 - [OAuth2Client](docs/OAuth2Client.md)
 - [OAuth2TokenIntrospection](docs/OAuth2TokenIntrospection.md)
 - [Oauth2TokenResponse](docs/Oauth2TokenResponse.md)
 - [OpenIDConnectContext](docs/OpenIDConnectContext.md)
 - [PreviousConsentSession](docs/PreviousConsentSession.md)
 - [RejectRequest](docs/RejectRequest.md)
 - [UserinfoResponse](docs/UserinfoResponse.md)
 - [Version](docs/Version.md)
 - [WellKnown](docs/WellKnown.md)


## Documentation For Authorization


## basic

- **Type**: HTTP basic authentication


## oauth2

- **Type**: OAuth
- **Flow**: accessCode
- **Authorization URL**: /oauth2/auth
- **Scopes**: 
 - **offline**: A scope required when requesting refresh tokens (alias for `offline_access`)
 - **offline_access**: A scope required when requesting refresh tokens
 - **openid**: Request an OpenID Connect ID Token


## Author




