# python homework
    Display download traffic from the Internet in various countries around the world.
    Show the number of pc game users by country.
    by using data form https://store.steampowered.com/stats/content/

# dltraffic
    need import pandas as pd and import matplotlib.pyplot as plt
    python_requires='>=3.6'
    MIT License

# How to install
    $ pip install dltraffic

# How to run
    $ dltraffic

# example

![avatar](data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAjIAAAIoCAYAAABzgQGkAAAAOXRFWHRTb2Z0d2FyZQBNYXRwbG90bGliIHZlcnNpb24zLjcuMSwgaHR0cHM6Ly9tYXRwbG90bGliLm9yZy/bCgiHAAAACXBIWXMAAA9hAAAPYQGoP6dpAABzZUlEQVR4nO3dd3iN5/8H8PfJ3glJjJAtCInYo5QgZoyYLUqM2qtif2vvUYpSsSooRWOW2mJTsbckBCkVIyQSRJzcvz9y5fnlSILqec7JE+/XdZ2rzXPG55MheZ/7uZ/7VgkhBIiIiIgUyEDfDRARERF9KgYZIiIiUiwGGSIiIlIsBhkiIiJSLAYZIiIiUiwGGSIiIlIsBhkiIiJSLAYZIiIiUiwGGSIiIlIsBhki0rkJEyZApVLhyZMn+m5FJ7p27Qo3Nzd9tyG7uLg4mJmZ4fjx47LWuXbtGoyMjHDlyhVZ65AyMMiQol2+fBlt27aFq6srzMzMUKxYMTRo0AA//fSTxuOmTZuGrVu36qdJLejatSusrKxyvd/Kygpdu3bVXUN5XFhYGFQq1QdvHxMurl27hgkTJuDOnTuy9+3v76/Rn4mJCdzd3dGrVy/ExcV90mv++eefmDBhgnYbzcWkSZNQrVo11KxZUzrWtWtXjc/JxsYGfn5+mDNnDlJTU6XHZYbbzJuBgQGKFi2KZs2a4dSpUxp1ypQpg8DAQIwbN04nnxflbUb6boDoU504cQJ169aFi4sLevbsiSJFiiAuLg6nTp3C/PnzMXDgQOmx06ZNQ9u2bREUFKS/hklnateujTVr1mgc+/bbb1G1alX06tVLOva+cJjp2rVrmDhxIvz9/XUyqlK8eHFMnz4dAPDmzRtcu3YNoaGh2LNnD65fvw4LC4t/9Xp//vknFi1aJHuYefz4MVatWoVVq1Zlu8/U1BTLly8HADx//hybNm3CsGHDEBkZifXr12s8dvHixbCyskJ6ejri4uKwbNky1K5dG6dPn0b58uWlx/Xp0wdNmzbFrVu34OnpKevnRnkbgwwp1tSpU2Fra4vIyEjY2dlp3Pfo0SP9NPWZSElJgaWlpb7byJWHhwc8PDw0jvXp0wceHh745ptv9NTVx7G1tc3Wo7u7OwYMGIDjx4+jQYMGeurs/X799VcYGRmhefPm2e4zMjLS+Jz69euHatWqYcOGDZg7dy6cnJyk+9q2bQsHBwfp46CgIPj4+OD333/XCDIBAQEoUKAAVq1ahUmTJsnzSZEi8NQSKdatW7dQtmzZbCEGAAoVKiT9v0qlQkpKClatWiUNW2c9DXP//n10794dhQsXhqmpKcqWLYtffvlF4/XevHmDcePGoVKlSrC1tYWlpSW+/PJLREREaDzuzp07UKlU+OGHH7Bo0SJ4eHjAwsICDRs2RFxcHIQQmDx5MooXLw5zc3O0bNkSCQkJWv26AEBaWhomTpwILy8vmJmZwd7eHrVq1cK+ffs0Hnfjxg20bdsWBQsWhJmZGSpXrozt27drPCbzNM3hw4fRr18/FCpUCMWLFwcAvHjxAt999x3c3NxgamqKQoUKoUGDBjh37txH9fnkyRO0b98eNjY2sLe3x+DBg/H69Wvp/jp16sDPzy/H55YqVQqNGjX6N1+WbM6fP48mTZrAxsYGVlZWqF+/vsZpjLCwMLRr1w4AULduXenn59ChQwCAbdu2ITAwEE5OTjA1NYWnpycmT54MtVr9n/p6V5EiRQBkBAIAiIiIgEqlwpYtW7I9dt26dVCpVDh58iS6du2KRYsWAYDGaZtM6enpmDdvHsqWLQszMzMULlwYvXv3xrNnzzRe88yZM2jUqBEcHBxgbm4Od3d3dO/eXeMxW7duRbVq1T5qlMvAwAD+/v4A8MFTdu9+7pmMjY3h7++Pbdu2fbAe5W8ckSHFcnV1xcmTJ3HlyhX4+Pjk+rg1a9ZkO62QORQdHx+P6tWrQ6VSYcCAAXB0dMSuXbvQo0cPJCUl4bvvvgMAJCUlYfny5ejQoQN69uyJFy9eYMWKFWjUqFG2IW8AWLt2Ld68eYOBAwciISEBs2bNQvv27VGvXj0cOnQII0eORExMDH766ScMGzYsW3D6ryZMmIDp06dLn3dSUhLOnDmDc+fOSe/or169ipo1a6JYsWIYNWoULC0tsXHjRgQFBWHTpk1o1aqVxmv269cPjo6OGDduHFJSUgBkjHKEh4djwIABKFOmDJ4+fYpjx47h+vXrqFix4gf7bN++Pdzc3DB9+nScOnUKCxYswLNnz7B69WoAQOfOndGzZ89s3+PIyEhERUVhzJgxn/w1unr1Kr788kvY2NhgxIgRMDY2xpIlS+Dv74/Dhw+jWrVqqF27NgYNGoQFCxbgf//7H7y9vQFA+m9YWBisrKwQEhICKysrHDx4EOPGjUNSUhJmz579SX2p1WppEnRaWhquX7+O8ePHo0SJEtLcE39/fzg7O2Pt2rXZvk9r166Fp6cnatSoAQB48OAB9u3bl+1UGwD07t0bYWFh6NatGwYNGoTY2FgsXLgQ58+fx/Hjx2FsbIxHjx6hYcOGcHR0xKhRo2BnZ4c7d+5g8+bN0uukpaUhMjISffv2/ejP89atWwAAe3t7jeOZwT49PR3379/H5MmTYWZmhvbt22d7jUqVKmHbtm1ISkqCjY3NR9emfEYQKdTevXuFoaGhMDQ0FDVq1BAjRowQe/bsEW/evMn2WEtLSxEcHJzteI8ePUTRokXFkydPNI5//fXXwtbWVrx8+VIIIcTbt29FamqqxmOePXsmChcuLLp37y4di42NFQCEo6OjeP78uXR89OjRAoDw8/MTaWlp0vEOHToIExMT8fr16/d+rsHBwcLS0jLX+9/9/Pz8/ERgYOB7X7N+/frC19dXo3Z6err44osvhJeXl3Rs5cqVAoCoVauWePv2rcZr2Nraiv79+7+3Tk7Gjx8vAIgWLVpoHO/Xr58AIC5evCiEEOL58+fCzMxMjBw5UuNxgwYNEpaWliI5Ofmja777NQoKChImJibi1q1b0rEHDx4Ia2trUbt2benY77//LgCIiIiIbK+Z+fORVe/evYWFhYXG1zU4OFi4urp+sMc6deoIANlu3t7e4vbt2xqPHT16tDA1NdX4OXv06JEwMjIS48ePl471799f5PSr/ujRowKAWLt2rcbx3bt3axzfsmWLACAiIyNz7TsmJkYAED/99FO2+zJ/dh8/fiweP34sYmJixLRp04RKpRLlypWTHpf5M/Huzc7OTuzevTvHuuvWrRMAxF9//ZVrb5T/8dQSKVaDBg1w8uRJtGjRAhcvXsSsWbPQqFEjFCtWLNvpkZwIIbBp0yY0b94cQgg8efJEujVq1AiJiYnSKRJDQ0OYmJgAyHinmJCQgLdv36Jy5co5nkZp164dbG1tpY+rVasGAPjmm280hsirVauGN2/e4P79+//pa/EuOzs7XL16FdHR0Tnen5CQgIMHD6J9+/Z48eKF9Hk/ffoUjRo1QnR0dLaeevbsCUNDw2x1/vrrLzx48OCT+uzfv7/Gx5kTtP/8808AGfNFWrZsid9++w1CCAAZIxYbNmxAUFDQJ8/TUavV2Lt3L4KCgjTm0hQtWhQdO3bEsWPHkJSU9MHXMTc3l/4/8+v45Zdf4uXLl7hx48Yn9ebm5oZ9+/Zh37592LVrF+bNm4fExEQ0adIEjx8/lh7XpUsXpKamIjw8XDq2YcMGvH379qPmAf3++++wtbVFgwYNNH72K1WqBCsrK+m0aeap2x07diAtLS3H13r69CkAoECBAjnen5KSAkdHRzg6OqJEiRL43//+hxo1auR4amzTpk3Yt28f9u7di5UrV6JkyZJo06YNTpw4ke2xmfU+l8v4KWcMMqRoVapUwebNm/Hs2TOcPn0ao0ePxosXL9C2bVtcu3btvc99/Pgxnj9/jqVLl0q/ZDNv3bp1A6A5aXjVqlUoV66cNOfE0dERO3fuRGJiYrbXdnFx0fg4M9Q4OzvnePzdOQmfIuvch0mTJuH58+coWbIkfH19MXz4cFy6dEm6PyYmBkIIjB07NtvnPn78eADZJ0y7u7tnqzlr1ixcuXIFzs7OqFq1KiZMmIDbt29/dM9eXl4aH3t6esLAwEBj3kSXLl1w7949HD16FACwf/9+xMfHo3Pnzh9d512PHz/Gy5cvUapUqWz3eXt7S1fMfMjVq1fRqlUr2NrawsbGBo6OjlKIyOnn4mNYWloiICAAAQEBaNy4MQYPHozt27fj5s2bmDFjhvS40qVLo0qVKli7dq10bO3atahevTpKlCjxwTrR0dFITExEoUKFsv0MJCcnS9//OnXqoE2bNpg4cSIcHBzQsmVLrFy5UuPS6UyZYfNdZmZmUjg7cuQI4uLicPz48WwTsoGMK84CAgLQoEEDdO3aFQcOHIC1tbXGVYjv1sv6s0+fH86RoXzBxMQEVapUQZUqVVCyZEl069YNv//+u/RHOSfp6ekAMkZJgoODc3xMuXLlAGRckdG1a1cEBQVh+PDhKFSoEAwNDTF9+nTpXH9W745cfOh4bn8AMpmZmSE1NRVCiGy/tIUQeP36NczMzKRjtWvXxq1bt7Bt2zbs3bsXy5cvx48//ojQ0FB8++230uc+bNiwXCfMvvvHMOvoQ6b27dvjyy+/xJYtW7B3717Mnj0bM2fOxObNm9GkSZP3fk45yekPUqNGjVC4cGH8+uuvqF27Nn799VcUKVIEAQEB//r1ten58+eoU6cObGxsMGnSJHh6esLMzAznzp3DyJEjpa+xNmROMj9y5IjG8S5dumDw4MH4+++/kZqailOnTmHhwoUf9Zrp6ekoVKiQRhDKytHREUDG9yQ8PBynTp3CH3/8gT179qB79+6YM2cOTp06BSsrK2meS26B3NDQ8JO/X1ZWVqhWrRq2bduW7Wq5zHpZr3Kizw+DDOU7lStXBgD8888/0rGc/kA6OjrC2toaarX6g79kw8PD4eHhgc2bN2u81vuCkja5urri7du3uHXrVraAERMTA7VaDVdXV43jBQsWRLdu3dCtWzckJyejdu3amDBhAr799lvpnbCxsfF/DgRFixZFv3790K9fPzx69AgVK1bE1KlTPyrIREdHa4z0xMTEID09XWO9FkNDQ3Ts2BFhYWGYOXMmtm7dmuNprn/D0dERFhYWuHnzZrb7bty4AQMDA2n0LLd3+4cOHcLTp0+xefNm1K5dWzoeGxv7yX29j1qtRnJyssaxr7/+GiEhIfjtt9/w6tUrGBsb46uvvtJ4TG79e3p6Yv/+/ahZs2aOIfVd1atXR/Xq1TF16lSsW7cOnTp1wvr16/Htt9/CxcUF5ubmsn3ub9++BQAkJydrBJnY2FgYGBigZMmSstQlZeCpJVKsiIiIHEcyMudXZD1tYGlpiefPn2s8ztDQEG3atMGmTZtyXOo863yEzD+aWev99ddfOHny5H/6HD5WZijI6d125uW1WYND5pyFTFZWVihRooR0OqBQoULw9/fHkiVLNAJfpqyfe27UanW20yeFChWCk5NTjqcdcpLZe6bMFZnfDUGdO3fGs2fP0Lt3byQnJ//ntWAMDQ3RsGFDbNu2TeM0Vnx8PNatW4datWpJV8Fk/uHM6ecH0PyZePPmDX7++ef/1FtOIiIikJycnO1SdAcHBzRp0gS//vor1q5di8aNG2cbncit//bt20OtVmPy5MnZ6r19+1Z6/LNnz7L9O8u8Si/z+2xsbIzKlSvjzJkzn/op5iohIQEnTpxAkSJFNJZVAICzZ8+ibNmyGvPR6PPDERlSrIEDB+Lly5do1aoVSpcujTdv3uDEiRPYsGED3NzcpHkuQMbQ/P79+6XFt9zd3VGtWjXMmDEDERERqFatGnr27IkyZcogISEB586dw/79+6VLQZs1a4bNmzejVatWCAwMRGxsLEJDQ1GmTJls75LlUL58eXz77beYP38+oqOjpUuo9+3bhz///BPffvutxh+5MmXKwN/fH5UqVULBggVx5swZ6TLpTIsWLUKtWrXg6+uLnj17wsPDA/Hx8Th58iT+/vtvXLx48b09vXjxAsWLF0fbtm3h5+cHKysr7N+/H5GRkZgzZ85HfV6xsbFo0aIFGjdujJMnT+LXX39Fx44ds/3BrlChgrQomre390dd2v0hU6ZMwb59+1CrVi3069cPRkZGWLJkCVJTUzFr1izpceXLl4ehoSFmzpyJxMREmJqaol69evjiiy9QoEABBAcHY9CgQVCpVFizZs0HTxN+SGJiIn799VcAGYHi5s2bWLx4MczNzTFq1Khsj+/SpQvatm0LADmGkkqVKgEABg0ahEaNGsHQ0BBff/016tSpg969e2P69Om4cOECGjZsCGNjY0RHR+P333/H/Pnz0bZtW6xatQo///wzWrVqBU9PT7x48QLLli2DjY0NmjZtKtVp2bIlvv/++/98KXR4eDisrKwghMCDBw+wYsUKPHv2DKGhoRqjS2lpadLaRvSZ08OVUkRasWvXLtG9e3dRunRpYWVlJUxMTESJEiXEwIEDRXx8vMZjb9y4IWrXri3Mzc0FAI3LcOPj40X//v2Fs7OzMDY2FkWKFBH169cXS5culR6Tnp4upk2bJlxdXYWpqamoUKGC2LFjR7bLajMvv549e7ZG/YiICAFA/P777xrHMy9tft+lrZnUarWYP3++8PPzE2ZmZsLMzEz4+fmJBQsWCLVarfHYKVOmiKpVqwo7Ozthbm4uSpcuLaZOnZrt0vRbt26JLl26iCJFighjY2NRrFgx0axZMxEeHv7BHlNTU8Xw4cOFn5+fsLa2FpaWlsLPz0/8/PPPH/xcMi+1vXbtmmjbtq2wtrYWBQoUEAMGDBCvXr3K8TmzZs0SAMS0adM++Po5yekS/HPnzolGjRoJKysrYWFhIerWrStOnDiR7bnLli0THh4ewtDQUONS7OPHj4vq1asLc3Nz4eTkJC0BkPUxQnz65dcqlUoULFhQtGjRQpw9ezbH56SmpooCBQoIW1vbHL92b9++FQMHDhSOjo5CpVJluxR76dKlolKlSsLc3FxYW1sLX19fMWLECPHgwQPpa9ShQwfh4uIiTE1NRaFChUSzZs3EmTNnNF4nPj5eGBkZiTVr1mgc/9DSAZlyuvza0tJS1KhRQ2zcuDHb43ft2iUAiOjo6A++NuVvKiH+49sHIiIdmD9/PoYMGYI7d+5kuyrsc/b27Vs4OTmhefPmWLFihV576dGjB6KioqQrzOQUFBSU6+rG9HlhkCGiPE8IAT8/P9jb22fbFuJzFx4ejnbt2uHQoUOoU6eOXnu5d+8eSpYsiQMHDmjsgK1t169fh6+vLy5cuPDeVb3p88A5MkSUZ6WkpGD79u2IiIjA5cuXua9OFn/99RcuXbqEyZMno0KFCnoPMUDG+klZ98qSi7e3t3QlExGDDBHlWY8fP0bHjh1hZ2eH//3vf2jRooW+W8ozFi9ejF9//RXly5dHWFiYvtsh0hueWiIiIiLF4joyREREpFgMMkRERKRY+X6OTHp6Oh48eABra2tuLEZERKQQQgi8ePECTk5OMDDIfdwl3weZBw8eZNtxmIiIiJQhLi4OxYsXz/X+fB9krK2tAWR8If7LstlERESkO0lJSXB2dpb+jucm3weZzNNJNjY2DDJEREQK86FpIZzsS0RERIrFIENERESKxSBDREREisUgQ0RERIrFIENERESKxSBDREREisUgQ0RERIrFIENERESKxSBDREREisUgQ0RERIrFIENERESKxSBDREREisUgQ0RERIrFIENERESKZaTvBvICt1E7P/m5d2YEarETIiIi+jc4IkNERESKxSBDREREisUgQ0RERIrFIENERESKxSBDREREisUgQ0RERIql1yBz5MgRNG/eHE5OTlCpVNi6dWuuj+3Tpw9UKhXmzZuns/6IiIgob9NrkElJSYGfnx8WLVr03sdt2bIFp06dgpOTk446IyIiIiXQ64J4TZo0QZMmTd77mPv372PgwIHYs2cPAgO5+BwRERH9vzy9sm96ejo6d+6M4cOHo2zZsh/1nNTUVKSmpkofJyUlydUeERER6Vmenuw7c+ZMGBkZYdCgQR/9nOnTp8PW1la6OTs7y9ghERER6VOeDTJnz57F/PnzERYWBpVK9dHPGz16NBITE6VbXFycjF0SERGRPuXZIHP06FE8evQILi4uMDIygpGREe7evYuhQ4fCzc0t1+eZmprCxsZG40ZERET5U56dI9O5c2cEBARoHGvUqBE6d+6Mbt266akrIiIiykv0GmSSk5MRExMjfRwbG4sLFy6gYMGCcHFxgb29vcbjjY2NUaRIEZQqVUrXrRIREVEepNcgc+bMGdStW1f6OCQkBAAQHByMsLAwPXVFRERESqHXIOPv7w8hxEc//s6dO/I1Q0RERIqTZyf7EhEREX0IgwwREREpFoMMERERKRaDDBERESkWgwwREREpFoMMERERKRaDDBERESkWgwwREREpFoMMERERKRaDDBERESkWgwwREREpFoMMERERKRaDDBERESkWgwwREREpFoMMERERKRaDDBERESkWgwwREREpFoMMERERKRaDDBERESkWgwwREREpFoMMERERKRaDDBERESkWgwwREREpFoMMERERKRaDDBERESkWgwwREREpFoMMERERKRaDDBERESkWgwwREREpFoMMERERKRaDDBERESkWgwwREREpFoMMERERKRaDDBERESkWgwwREREpFoMMERERKRaDDBERESkWgwwREREpll6DzJEjR9C8eXM4OTlBpVJh69at0n1paWkYOXIkfH19YWlpCScnJ3Tp0gUPHjzQX8NERESUp+g1yKSkpMDPzw+LFi3Kdt/Lly9x7tw5jB07FufOncPmzZtx8+ZNtGjRQg+dEhERUV5kpM/iTZo0QZMmTXK8z9bWFvv27dM4tnDhQlStWhX37t2Di4uLLlokIiKiPEyvQebfSkxMhEqlgp2dXa6PSU1NRWpqqvRxUlKSDjojIiIifVDMZN/Xr19j5MiR6NChA2xsbHJ93PTp02FrayvdnJ2dddglERER6ZIigkxaWhrat28PIQQWL1783seOHj0aiYmJ0i0uLk5HXRIREZGu5flTS5kh5u7duzh48OB7R2MAwNTUFKampjrqjoiIiPQpTweZzBATHR2NiIgI2Nvb67slIiIiykP0GmSSk5MRExMjfRwbG4sLFy6gYMGCKFq0KNq2bYtz585hx44dUKvVePjwIQCgYMGCMDEx0VfbRERElEfoNcicOXMGdevWlT4OCQkBAAQHB2PChAnYvn07AKB8+fIaz4uIiIC/v7+u2iQiIqI8Sq9Bxt/fH0KIXO9/331EREREirhqiYiIiCgneXqy7+fAbdTOT37unRmBWuyEiIhIeTgiQ0RERIrFIENERESKxSBDREREisUgQ0RERIrFIENERESKxSBDREREisUgQ0RERIrFIENERESKxSBDREREisUgQ0RERIrFIENERESKxSBDREREisUgQ0RERIrFIENERESKxSBDREREisUgQ0RERIrFIENERESKxSBDREREisUgQ0RERIrFIENERESKxSBDREREisUgQ0RERIrFIENERESKxSBDREREisUgQ0RERIrFIENERESKxSBDREREisUgQ0RERIrFIENERESKxSBDREREisUgQ0RERIrFIENERESKxSBDREREisUgQ0RERIrFIENERESKpdcgc+TIETRv3hxOTk5QqVTYunWrxv1CCIwbNw5FixaFubk5AgICEB0drZ9miYiIKM/Ra5BJSUmBn58fFi1alOP9s2bNwoIFCxAaGoq//voLlpaWaNSoEV6/fq3jTomIiCgvMtJn8SZNmqBJkyY53ieEwLx58zBmzBi0bNkSALB69WoULlwYW7duxddff63LVomIiCgPyrNzZGJjY/Hw4UMEBARIx2xtbVGtWjWcPHky1+elpqYiKSlJ40ZERET5U54NMg8fPgQAFC5cWON44cKFpftyMn36dNja2ko3Z2dnWfskIiIi/cmzQeZTjR49GomJidItLi5O3y0RERGRTPJskClSpAgAID4+XuN4fHy8dF9OTE1NYWNjo3EjIiKi/CnPBhl3d3cUKVIEBw4ckI4lJSXhr7/+Qo0aNfTYGREREeUVer1qKTk5GTExMdLHsbGxuHDhAgoWLAgXFxd89913mDJlCry8vODu7o6xY8fCyckJQUFB+muaiIiI8gy9BpkzZ86gbt260schISEAgODgYISFhWHEiBFISUlBr1698Pz5c9SqVQu7d++GmZmZvlomIiKiPESvQcbf3x9CiFzvV6lUmDRpEiZNmqTDroiIiEgp8uwcGSIiIqIPYZAhIiIixWKQISIiIsVikCEiIiLF0utkX9Ivt1E7P/m5d2YEarETIiKiT8MRGSIiIlIsBhkiIiJSLAYZIiIiUiwGGSIiIlIsBhkiIiJSLAYZIiIiUiwGGSIiIlIsBhkiIiJSLAYZIiIiUiwGGSIiIlIsBhkiIiJSLAYZIiIiUiwGGSIiIlIsBhkiIiJSLAYZIiIiUiwGGSIiIlIsBhkiIiJSLAYZIiIiUiwGGSIiIlIsBhkiIiJSLAYZIiIiUiwGGSIiIlIsBhkiIiJSLAYZIiIiUiwGGSIiIlIsBhkiIiJSLAYZIiIiUiwGGSIiIlIsBhkiIiJSLAYZIiIiUiwGGSIiIlIsBhkiIiJSrE8KMnFxcfj777+lj0+fPo3vvvsOS5cu1VpjRERERB/ySUGmY8eOiIiIAAA8fPgQDRo0wOnTp/H9999j0qRJWmtOrVZj7NixcHd3h7m5OTw9PTF58mQIIbRWg4iIiJTrk4LMlStXULVqVQDAxo0b4ePjgxMnTmDt2rUICwvTWnMzZ87E4sWLsXDhQly/fh0zZ87ErFmz8NNPP2mtBhERESmX0ac8KS0tDaampgCA/fv3o0WLFgCA0qVL459//tFacydOnEDLli0RGBgIAHBzc8Nvv/2G06dPa60GERERKdcnjciULVsWoaGhOHr0KPbt24fGjRsDAB48eAB7e3utNffFF1/gwIEDiIqKAgBcvHgRx44dQ5MmTXJ9TmpqKpKSkjRuRERElD990ojMzJkz0apVK8yePRvBwcHw8/MDAGzfvl065aQNo0aNQlJSEkqXLg1DQ0Oo1WpMnToVnTp1yvU506dPx8SJE7XWAxEREeVdnxRk/P398eTJEyQlJaFAgQLS8V69esHCwkJrzW3cuBFr167FunXrULZsWVy4cAHfffcdnJycEBwcnONzRo8ejZCQEOnjpKQkODs7a60nIiIiyjs+KcgAgBACZ8+exa1bt9CxY0dYW1vDxMREq0Fm+PDhGDVqFL7++msAgK+vL+7evYvp06fnGmRMTU2l+TtERESUv31SkLl79y4aN26Me/fuITU1FQ0aNIC1tTVmzpyJ1NRUhIaGaqW5ly9fwsBAcxqPoaEh0tPTtfL6REREpGyfNNl38ODBqFy5Mp49ewZzc3PpeKtWrXDgwAGtNde8eXNMnToVO3fuxJ07d7BlyxbMnTsXrVq10loNIiIiUq5PGpE5evQoTpw4ARMTE43jbm5uuH//vlYaA4CffvoJY8eORb9+/fDo0SM4OTmhd+/eGDdunNZqEBERkXJ9UpBJT0+HWq3Odvzvv/+GtbX1f24qk7W1NebNm4d58+Zp7TWJiIgo//ikU0sNGzbUCBcqlQrJyckYP348mjZtqq3eiIiIiN7rk0Zk5syZg0aNGqFMmTJ4/fo1OnbsiOjoaDg4OOC3337Tdo9EREREOfqkIFO8eHFcvHgRGzZswMWLF5GcnIwePXqgU6dOGpN/iYiIiOT0SUHmyJEj+OKLL9CpUyeNVXbfvn2LI0eOoHbt2lprkIiIiCg3nzRHpm7dukhISMh2PDExEXXr1v3PTRERERF9jE8KMkIIqFSqbMefPn0KS0vL/9wUERER0cf4V6eWWrduDSDjKqWuXbtqbAWgVqtx6dIlfPHFF9rtkIiIiCgX/yrI2NraAsgYkbG2ttaY2GtiYoLq1aujZ8+e2u2QiIiIKBf/KsisXLkSQMYKvsOGDeNpJCIiItKrT5ojk56ejidPnmi7FyIiIqJ/5ZOCzPbt2+Hp6Yn69etj3bp1SE1N1XZfRERERB/0SUHm/PnziIyMRNmyZTF48GAUKVIEffv2RWRkpLb7IyIiIsrVJwUZAKhQoQIWLFiABw8eYMWKFfj7779Rs2ZNlCtXDvPnz0diYqI2+yQiIiLK5pODTCYhBNLS0vDmzRsIIVCgQAEsXLgQzs7O2LBhgzZ6JCIiIsrRJweZs2fPYsCAAShatCiGDBmCChUq4Pr16zh8+DCio6MxdepUDBo0SJu9EhEREWn4pCDj6+uL6tWrIzY2FitWrEBcXBxmzJiBEiVKSI/p0KEDHj9+rLVGiYiIiN71SZtGtm/fHt27d0exYsUghMjxMQ4ODkhPT/9PzRERERG9zyeNyIwdOxa7d++Gj48PzMzMYGZmBh8fHyxfvlzb/RERERHl6pNGZMaNG4e5c+di4MCBqFGjBgDg5MmTGDJkCO7du4dJkyZptUkiIiKinHxSkFm8eDGWLVuGDh06SMdatGiBcuXKYeDAgQwyREREpBOfdGopLS0NlStXzna8UqVKePv27X9uioiIiOhjfFKQ6dy5MxYvXpzt+NKlS9GpU6f/3BQRERHRx/joU0shISHS/6tUKixfvhx79+5F9erVAQB//fUX7t27hy5dumi/SyIiIqIcfHSQOX/+vMbHlSpVAgDcunULQMbl1g4ODrh69aoW2yMiIiLK3UcHmYiICDn7ICIiIvrX/vNeS0RERET6wiBDREREisUgQ0RERIrFIENERESKxSBDREREisUgQ0RERIrFIENERESKxSBDREREisUgQ0RERIrFIENERESKxSBDREREisUgQ0RERIrFIENERESKleeDzP379/HNN9/A3t4e5ubm8PX1xZkzZ/TdFhEREeUBRvpu4H2ePXuGmjVrom7duti1axccHR0RHR2NAgUK6Ls1IiIiygPydJCZOXMmnJ2dsXLlSumYu7u7HjsiIiKivCRPn1ravn07KleujHbt2qFQoUKoUKECli1b9t7npKamIikpSeNGRERE+VOeDjK3b9/G4sWL4eXlhT179qBv374YNGgQVq1aletzpk+fDltbW+nm7Oysw46JiIhIl/J0kElPT0fFihUxbdo0VKhQAb169ULPnj0RGhqa63NGjx6NxMRE6RYXF6fDjomIiEiX8nSQKVq0KMqUKaNxzNvbG/fu3cv1OaamprCxsdG4ERERUf6Up4NMzZo1cfPmTY1jUVFRcHV11VNHRERElJfk6SAzZMgQnDp1CtOmTUNMTAzWrVuHpUuXon///vpujYiIiPKAPB1kqlSpgi1btuC3336Dj48PJk+ejHnz5qFTp076bo2IiIjygDy9jgwANGvWDM2aNdN3G0RERJQH5ekRGSIiIqL3YZAhIiIixWKQISIiIsVikCEiIiLFYpAhIiIixWKQISIiIsVikCEiIiLFYpAhIiIixWKQISIiIsVikCEiIiLFYpAhIiIixWKQISIiIsVikCEiIiLFYpAhIiIixWKQISIiIsVikCEiIiLFYpAhIiIixWKQISIiIsVikCEiIiLFYpAhIiIixWKQISIiIsVikCEiIiLFYpAhIiIixTLSdwP0eXIbtfOTn3tnRqAWOyEiIiXjiAwREREpFoMMERERKRaDDBERESkWgwwREREpFoMMERERKRaDDBERESkWgwwREREpFoMMERERKRaDDBERESkWgwwREREpFoMMERERKRaDDBERESkWgwwREREpFoMMERERKZaRvhv4N2bMmIHRo0dj8ODBmDdvnr7bIYVyG7Xzk597Z0agFjshIqL/SjEjMpGRkViyZAnKlSun71aIiIgoj1BEkElOTkanTp2wbNkyFChQQN/tEBERUR6hiCDTv39/BAYGIiAg4IOPTU1NRVJSksaNiIiI8qc8P0dm/fr1OHfuHCIjIz/q8dOnT8fEiRNl7oqIiIjygjw9IhMXF4fBgwdj7dq1MDMz+6jnjB49GomJidItLi5O5i6JiIhIX/L0iMzZs2fx6NEjVKxYUTqmVqtx5MgRLFy4EKmpqTA0NNR4jqmpKUxNTXXdKhEREelBng4y9evXx+XLlzWOdevWDaVLl8bIkSOzhRgiIiL6vOTpIGNtbQ0fHx+NY5aWlrC3t892nIiIiD4/eXqODBEREdH75OkRmZwcOnRI3y0QERFRHsERGSIiIlIsBhkiIiJSLAYZIiIiUiwGGSIiIlIsBhkiIiJSLAYZIiIiUiwGGSIiIlIsBhkiIiJSLAYZIiIiUiwGGSIiIlIsBhkiIiJSLAYZIiIiUiwGGSIiIlIsBhkiIiJSLCN9N0D0OXEbtfOTn3tnRqAWOyEiyh84IkNERESKxREZos8ER4OIKD9ikCEi2TFEEZFceGqJiIiIFItBhoiIiBSLQYaIiIgUi0GGiIiIFItBhoiIiBSLQYaIiIgUi0GGiIiIFItBhoiIiBSLQYaIiIgUiyv7ElG+xlWFifI3jsgQERGRYjHIEBERkWIxyBAREZFiMcgQERGRYnGyLxGRTDjRmEh+HJEhIiIixWKQISIiIsVikCEiIiLF4hwZIqJ8iPNz6HPBERkiIiJSrDwdZKZPn44qVarA2toahQoVQlBQEG7evKnvtoiIiCiPyNNB5vDhw+jfvz9OnTqFffv2IS0tDQ0bNkRKSoq+WyMiIqI8IE/Pkdm9e7fGx2FhYShUqBDOnj2L2rVr66krIiIiyivydJB5V2JiIgCgYMGCuT4mNTUVqamp0sdJSUmy90VERET6kadPLWWVnp6O7777DjVr1oSPj0+uj5s+fTpsbW2lm7Ozsw67JCIiIl1SzIhM//79ceXKFRw7duy9jxs9ejRCQkKkj5OSkhhmiIh0iJd+ky4pIsgMGDAAO3bswJEjR1C8ePH3PtbU1BSmpqY66oyIiIj0KU8HGSEEBg4ciC1btuDQoUNwd3fXd0tERESUh+TpINO/f3+sW7cO27Ztg7W1NR4+fAgAsLW1hbm5uZ67IyIiIn3L05N9Fy9ejMTERPj7+6No0aLSbcOGDfpujYiIiPKAPD0iI4TQdwtERESUh+XpIENERPRv6POKKV6tpR95+tQSERER0ftwRIaIiEjhPufRII7IEBERkWIxyBAREZFiMcgQERGRYjHIEBERkWIxyBAREZFiMcgQERGRYjHIEBERkWIxyBAREZFiMcgQERGRYjHIEBERkWIxyBAREZFiMcgQERGRYnHTSCIiIvpk+t6wkiMyREREpFgMMkRERKRYDDJERESkWAwyREREpFgMMkRERKRYDDJERESkWAwyREREpFgMMkRERKRYDDJERESkWAwyREREpFgMMkRERKRYDDJERESkWAwyREREpFgMMkRERKRYDDJERESkWAwyREREpFgMMkRERKRYDDJERESkWAwyREREpFgMMkRERKRYDDJERESkWIoIMosWLYKbmxvMzMxQrVo1nD59Wt8tERERUR6Q54PMhg0bEBISgvHjx+PcuXPw8/NDo0aN8OjRI323RkRERHqW54PM3Llz0bNnT3Tr1g1lypRBaGgoLCws8Msvv+i7NSIiItIzI3038D5v3rzB2bNnMXr0aOmYgYEBAgICcPLkyRyfk5qaitTUVOnjxMREAEBSUlKuddJTX35yj+973Y/B2qzN2qzN2qzN2rnfJ4R4/4uIPOz+/fsCgDhx4oTG8eHDh4uqVavm+Jzx48cLALzxxhtvvPHGWz64xcXFvTcr5OkRmU8xevRohISESB+np6cjISEB9vb2UKlU/+q1kpKS4OzsjLi4ONjY2Gi7VdZmbdZmbdZmbdbOhRACL168gJOT03sfl6eDjIODAwwNDREfH69xPD4+HkWKFMnxOaampjA1NdU4Zmdn95/6sLGx0fkPAGuzNmuzNmuz9ude29bW9oOPydOTfU1MTFCpUiUcOHBAOpaeno4DBw6gRo0aeuyMiIiI8oI8PSIDACEhIQgODkblypVRtWpVzJs3DykpKejWrZu+WyMiIiI9y/NB5quvvsLjx48xbtw4PHz4EOXLl8fu3btRuHBh2Wubmppi/Pjx2U5V6QJrszZrszZrszZrf5hKiA9d10RERESUN+XpOTJERERE78MgQ0RERIrFIENERESKxSBDREREisUgQ0RERIqV5y+/1qekpCQcPHgQpUqVgre3t77bIco3Hj16hEePHiE9PV3jeLly5fTUkbyCg4PRo0cP1K5dW9+tEOU7DDJZtG/fHrVr18aAAQPw6tUrVK5cGXfu3IEQAuvXr0ebNm1k7yElJQWHDx/GvXv38ObNG437Bg0aJHv9z01ERATq1q2r7zY+G2fPnkVwcDCuX78u7WirUqkghIBKpYJardZzh/JITExEQEAAXF1d0a1bNwQHB6NYsWL6bgvPnz//z1u4/FuvX7+GmZmZTmvq07Vr13L8fd6iRQs9dSQftVqNsLAwHDhwIMc3KgcPHpSlLteRyaJIkSLYs2cP/Pz8sG7dOowfPx4XL17EqlWrsHTpUpw/f17W+ufPn0fTpk3x8uVLpKSkoGDBgnjy5AksLCxQqFAh3L59W9b6mV6+fJnjP7z8+G7Z1NQUxYsXl/64ODs766y2Wq3Gjz/+iI0bN+b49U5ISJC9h+fPnyM8PBy3bt3C8OHDUbBgQZw7dw6FCxeW5Q+tn58fPD09MXLkSBQuXDjbRq6urq5arwkAly5d+ujHyvVz/vjxY6xZswarVq3CtWvXEBAQgB49eqBly5YwNjaWpWZWM2fOhJubG7766isAGW/cNm3ahCJFiuDPP/+En5+fbLXT09MxdepUhIaGIj4+HlFRUfDw8MDYsWPh5uaGHj16yFY7q9evX2f7dybX/kO3b99Gq1atcPnyZSmsA5B+5vNjaB8wYADCwsIQGBiIokWLZvv3/eOPP8pT+L17Y39mzMzMxL1794QQQnTu3FmMHDlSCCHE3bt3haWlpez169SpI3r27CnUarWwsrISt27dEvfu3RO1a9cWmzZtkr3+o0ePRGBgoDAwMMjxpm3ly5cXFSpU+KibXB4/fizmzp0r/Pz8hJGRkWjYsKHYsGGDSE1Nla1mprFjx4qiRYuKH374QZiZmYnJkyeLHj16CHt7ezF//nzZ61+8eFE4OjqKEiVKCCMjI3Hr1i0hhBDff/+96Ny5syw1raysRHR0tCyv/T4qlUoYGBhI/33fTRfOnj0rBgwYIMzMzISDg4P47rvvRFRUlKw13dzcxPHjx4UQQuzdu1fY2dmJPXv2iB49eogGDRrIWnvixInCw8ND/Prrr8Lc3Fz6WVu/fr2oXr26rLVTUlJE//79haOjo06/382aNRMtW7YUjx8/FlZWVuLatWvi6NGjomrVquLIkSOy1c0qMjJSDB8+XHz11VeiVatWGjc52Nvbi507d8ry2u/DIJOFl5eX2LBhg0hOThaOjo7iwIEDQgghLly4IOzt7WWvb2trK27cuCH9/7Vr14QQQpw6dUqUKlVK9vodO3YUNWvWFJGRkcLS0lLs3btXrFmzRpQqVUrs2LFD6/UmTJjw0TddyPzjYm9vL+zt7cXAgQPFhQsXZKvn4eEhfV2trKxETEyMEEKI+fPniw4dOshWN1P9+vXF8OHDpfqZf1yOHz8uXF1dZanZsmVLER4eLstrv8+dO3ek25YtW4Snp6cIDQ0VFy9eFBcvXhShoaHCy8tLbNmyRfZeHjx4IGbMmCFKlSolLC0tRZcuXUT9+vWFkZGRmDt3rmx1s75RGzRokOjVq5cQQoibN28KOzs72eoKIYSnp6fYv3+/EELzZ+369euy1+7Xr5/w9vYW4eHhwtzcXPzyyy9i8uTJonjx4uLXX3+Vra69vb24ePGiEEIIGxsb6Xf7gQMHRPny5WWrm+m3334TxsbGolmzZsLExEQ0a9ZMlCxZUtja2oquXbvKUrNo0aLi5s2bsrz2+zDIZLFo0SJhZGQk7OzsRLly5YRarRZCCLFgwQLh7+8ve30HBwfpXZmXl5fYvXu3ECLjH7uFhYXs9YsUKSL++usvIYQQ1tbW0g/ktm3bRM2aNWWvnxfcv39fjB8/XpiamgpLS0thaGgoatWqJa5cuaL1WhYWFuLu3btCiIyv/dmzZ4UQQty6dUvY2Nhovd67bGxspPCU9Y/LnTt3hKmpqSw1Hz9+LJo2bSomTJggwsPDxbZt2zRuulClSpUc3zXu3LlTVKxYUZaab968EeHh4SIwMFAYGxuLSpUqicWLF4vExETpMZs3b5b1j3rRokWlEZmSJUuKjRs3CiGEuHHjhrC2tpatrhAZIerOnTtCCM2ftatXr8o+2u3s7CwiIiKEEBm/1zJHBFevXi2aNGkiW107Oztx+/ZtIUTGm5aDBw8KIYSIiYkR5ubmstXN5OvrKxYuXCiE+P+veXp6uujZs6cYN26cLDV/+OEH0a9fP5Geni7L6+eGk32z6NevH6pWrYq4uDg0aNAABgYZV6d7eHhgypQpstevUKECIiMj4eXlhTp16mDcuHF48uQJ1qxZAx8fH9nrp6SkoFChQgCAAgUK4PHjxyhZsiR8fX1x7tw52evrS1paGrZt24ZffvkF+/btQ+XKlbFw4UJ06NABjx8/xpgxY9CuXTtcu3ZNq3WLFy+Of/75By4uLvD09MTevXtRsWJFREZG6mSDN1NTUyQlJWU7HhUVBUdHR1lqnjx5EsePH8euXbuy3aeryb6XL1+Gu7t7tuPu7u5a/x5nKlq0KNLT09GhQwecPn0a5cuXz/aYunXryjrxtnXr1ujYsSO8vLzw9OlTNGnSBEDG3LwSJUrIVhcAypQpg6NHj2abAxUeHo4KFSrIWjshIQEeHh4AMubDZM49q1WrFvr27StbXR8fH1y8eBHu7u6oVq0aZs2aBRMTEyxdulTqR063bt1CYGAgAMDExAQpKSlQqVQYMmQI6tWrh4kTJ2q95rFjxxAREYFdu3ahbNmy2eZ+bd68Wes1AXCOTE5SU1PFjRs3RFpamk7rRkZGSqk9Pj5eNGrUSFhbW4uKFSvKeoojU+XKlaVRoObNm4vOnTuLv//+W4wYMUJ4eHhovV6BAgXE48ePhRAZ714KFCiQ600umaeSChYsKAYPHiwuX76c7TH//POPUKlUWq89cuRIMXXqVCFExlwBIyMjUaJECWFiYiLNz5JTjx49RFBQkHjz5o2wsrISt2/fFnfv3hUVKlQQgwcPlqWmq6ur6N+/v3j48KEsr/8xKlSoIDp37qwxDyo1NVV07txZtvlYq1evFq9evZLltT/WmzdvxOzZs8WgQYPEuXPnpONz584Vy5Ytk7X21q1bha2trZgxY4awsLAQs2fPFt9++60wMTERe/fulbW2r6+vOHTokBAi43Tq0KFDhRAZp3CLFSsmW93du3dLcxujo6NFqVKlhEqlEg4ODtK0BTkVK1ZMXLp0SQiR8TVYt26dEEKIEydOyDbi27Vr1/fe5MIgk0VKSoro3r27MDQ0FIaGhtLw54ABA8T06dP13J381qxZI1auXCmEEOLMmTPCwcFBGBgYCDMzM7F+/Xqt1wsLCxOvX78WQgixcuVKERYWlutNLvXq1RPr1q2T+shJWlqa9ItQTidOnBBz5swR27dvl72WEEI8f/5cBAQECDs7O2FoaCicnZ2FsbGxqF27tkhOTpalZta5QPry119/iUKFCglHR0dRv359Ub9+feHo6CgKFSoknVqVS3R0tNi9e7d4+fKlEELofAhen44cOSICAgKEo6OjMDc3FzVr1hR79uyRve7cuXOlyfP79u0TZmZmwtTUVBgYGIh58+bJXj+rp0+f6ux73qFDBzFnzhwhhBCTJk0Sjo6O4ttvvxWurq6yTfbVF15+ncXgwYNx/PhxzJs3D40bN8alS5fg4eGBbdu2YcKECbJffp3XvHz5Ejdu3ICLiwscHBz03Q7J5Pjx47h48SKSk5NRsWJFBAQEyFYrODgYX375Jb799lvZanyMlJQUrF27Fjdu3AAAeHt7o2PHjrC0tJSl3tOnT9G+fXtERERApVIhOjoaHh4e6N69OwoUKIA5c+bIUvdda9aswZIlS3D79m2cPHkSrq6umDdvHtzd3dGyZUud9KBvd+/exdmzZ1GiRIl8uaREpoSEBLx+/RpOTk5IT0/HrFmzcOLECXh5eWHMmDEoUKCAvlvUGgaZLFxdXbFhwwZUr14d1tbWuHjxIjw8PBATE4OKFSvmOJ9Am+Lj4zFs2DBpMaF3vzX5cd2BTPXq1UOdOnUwfvx4jePPnj1DmzZtZFtICQCio6MRERGR4wJO48aN02qt7du3f/Rj8+OCWVOnTsW8efMQGBgIX1/fbOfQ8+uij126dMGjR4+wfPlyeHt7S79b9uzZg5CQEFy9elX2HhYvXoxx48bhu+++w9SpU3HlyhV4eHggLCwMq1atQkREhOw9vHnzJsd/Zy4uLrLXBuRfjK9169YICwuDjY0NWrdu/d7HyjZfRM/Cw8NzXRtLrrmWnOybxePHj6XJrlllTpKSW9euXXHv3j2MHTs2x8WE5BASEoLJkyfD0tISISEh733s3LlzZevj0KFDuHz5Ms6fP4+1a9dK74zfvHmDw4cPy1Z32bJl6Nu3LxwcHFCkSBGNr7lKpdJ6kAkKCtL4OOtCWVmPAfIH10GDBqFEiRLZwsPChQsRExODefPmab3m8uXLYWVlhcOHD2f7vqpUKp0FGV2GVwDYu3cv9uzZg+LFi2sc9/Lywt27d7VeLyc//fQTli1bhqCgIMyYMUM6XrlyZQwbNkzW2tHR0ejevTtOnDihcVzoYEVntVqNadOm6WQxPltbW+nfr62trdZe92MlJSVJC/x96I23HAsBLliwAN9//z26du2Kbdu2oVu3brh16xYiIyPRv39/rdeT6PG0Vp7z5ZdfigULFgghhDT5UYiMOTKNGjWSvb6VlZU4f/687HWy8vf3F8+ePZP+P7db3bp1Ze1DpVKJCxcuiGrVqgkfHx8RGxsrhBDi4cOHsi5a5eLiImbMmCHb67/Pvn37RMWKFcXu3btFYmKiSExMFLt37xaVK1eWfQKkEEI4OTmJM2fOZDt+9uxZWSdB6tvSpUuFoaGhKFy4sPDz8xPly5eXbnJN9rWyspKWVsh6+XFkZKQoWLCgLDXfldsl0FFRUcLMzEzW2l988YWoXbu2+PPPP8X58+fFhQsXNG5y0udifLpmYGAg4uPjhRAi18UfM4/LoVSpUtKk4qw/Y2PHjhX9+/eXpaYQnOyr4ejRo8LKykr06dNHmJmZicGDB4sGDRoIS0vLHH/ha5u3t7fG1QSfE5VKJeLj48Xr169Fhw4dhIODg4iIiJA9yFhbW0v/2HStbNmy4ujRo9mOHzlyRJQuXVr2+qampjmushsdHS3bOjJZpaen62Wyqz7Ca5MmTcSYMWOEEP//JkmtVot27dqJNm3a6KQHb29vsXXrVqmHzJ/7BQsWyLp6thAZayZdv35d1hq50edifLp26NAh6WrbQ4cOvfcmB3NzcyksOzo6SiE1KipK1sDOU0tZ1KpVCxcuXMCMGTPg6+srretx8uRJ+Pr6yl5/3rx5GDVqFJYsWQI3NzfZ631I5u7fpUuXRunSpWWtlTkca2pqinXr1mHKlClo3LgxRo4cKWvddu3aYe/evejTp4+sdXJy69atHNcNsbW1xZ07d2SvX6JECezevRsDBgzQOL5r1y5Z17lYvXo1Zs+ejejoaABAyZIlMXz4cHTu3Fm2mlk9e/YM7dq100mtTLNmzUL9+vVx5swZvHnzBiNGjMDVq1eRkJCA48eP66SHkJAQ9O/fH69fv4YQAqdPn8Zvv/2G6dOnY/ny5bLWLlOmDJ48eSJrjdzcv38/x3Vy0tPTkZaWptVaFSpU+OgpAXLMF6lTp06O/68rRYoUQUJCAlxdXeHi4oJTp07Bz88PsbGx2U6haxODzDs8PT2xbNkyvdT+6quv8PLlS3h6esLCwiLbREi5NxHU5+7f7/6QjxkzBt7e3ggODpatJpDxx3zs2LE4deqUziefVqlSBSEhIVizZg0KFy4MIGPC9/Dhw1G1alXZ6mYKCQnBgAED8PjxY9SrVw8AcODAAcyZM0eW+TFAxjyrsWPHYsCAAahZsyaAjEW0+vTpgydPnmDIkCGy1M1KH+HVx8cHUVFRWLhwIaytrZGcnIzWrVujf//+KFq0qE56+Pbbb2Fubo4xY8bg5cuX6NixI5ycnDB//nx8/fXXstaeOXMmRowYgWnTpuX470yujRsB3S7G9+4cOH3avXs3rKysUKtWLQDAokWLsGzZMpQpUwaLFi2S5aqlevXqYfv27ahQoQK6deuGIUOGIDw8HGfOnPng5Of/glctZWFoaIh//vkn24Tfp0+folChQrJPvly1atV775f7j7o+d/++e/cuXFxcsr2buXLlCs6ePSvb557TCq+ZVCqVrDuOx8TEoFWrVoiKipJ23Y6Li4OXlxe2bt0q+2qrQMaVLFOnTsWDBw8AAG5ubpgwYQK6dOkiSz13d3dMnDgx2+uvWrUKEyZMQGxsrCx1s5o+fTrmzp2r0yunIiIiULdu3RzvW7RokbwTIXPw8uVLJCcn53hxgxwyV0l/99+30MFk323btiE4OBijR4/GpEmTMHHiRNy8eROrV6/Gjh070KBBA9lq65Ovry9mzpyJpk2b4vLly6hcuTKGDh2KiIgIlC5dGitXrtR6zfT0dKSnp8PIKGOMZP369dIl371794aJiYnWawIMMhoMDAzw8OHDbP+4Hzx4AE9PT7x69UpPnemGubm59Ee1S5cucHJywowZM3Dv3j2UKVMGycnJ+m4x3xFCYN++fRrrmQQEBOjkirWsHj9+DHNzc1hZWclax8zMDFeuXMkW0qKjo+Hr64vXr1/LWh/QT3gtUKAA9u/fj0qVKmkcnz9/PsaOHSv70g769qErD+U+DXL06FFMmjRJY72kcePGoWHDhrLW1ScrKytcuXJFenNy5coVhIeH49y5c2jatCkePnyo7xa1hqeWkHHJGJDxSyzz8tBMarUaR44ckW2OiL4vl8vK2dkZJ0+eRMGCBbF7926sX78eQMacAjnXXsh05syZXNcfyK9rLqhUKjRs2FDvv1Dl2lvpXSVKlMDGjRvxv//9T+P4hg0b4OXlpZMedDHq867Zs2ejSZMmGr9L5syZg0mTJmHnzp066UGf61TpY74GALx9+xbTpk1D9+7dsW/fPp3WVqvV+PHHH3P9nSb3VAETExO8fPkSALB//35pFLRgwYKyBudnz55hxYoVuH79OoCMU3vdunVDwYIFZavJIAPgxx9/BJDx7jg0NBSGhobSfSYmJnBzc0NoaKgstQsUKCCdzrKzs8vxnbguhl8B4LvvvkOnTp1gZWUFV1dX+Pv7AwCOHDki+2Tn9evXo0uXLmjUqBH27t2Lhg0bIioqCvHx8WjVqpWstf/++29s3749x182cq6dA2SsUXT48OEca8u9poo+/rBNnDgRX331FY4cOSLNkTl+/DgOHDiAjRs3ar1eXvHtt98iISEBAQEBOHbsGDZs2IBp06bhzz//lL4OctP1OlWXLl2Cj48PDAwMcOnSpfc+Vq4Vdo2MjDBr1izZTpW+z8SJE7F8+XIMHToUY8aMwffff487d+5g69atsqxV9K5atWohJCQENWvWxOnTp7FhwwYAGZvCvruekbYcOXIELVq0gI2NDSpXrgwgY6Bg0qRJ+OOPP1C7dm1Z6vLUUhZ169bF5s2bdbp08+HDh1GzZk0YGRnpffgVyBgVydz9O3NkaufOnbCzs5P1F265cuXQu3dv9O/fX1pV2d3dHb1790bRokVl2akVyJjc2qJFC3h4eODGjRvw8fGRJjhXrFhR1hWFz58/j6ZNm+Lly5dISUlBwYIF8eTJE1hYWKBQoUKyzs8BgCZNmuDevXsYMGBAjn/Y5Fqy/uzZs/jxxx+ld2ze3t4YOnSo7LsgZ6Wv8Dpy5EisWLECarUau3btQvXq1WWr9S5ra2scPXo0x5235ZD1VL2BgUGOiz8C8u963rJlS7Ru3Vr2OYbv8vT0xIIFCxAYGAhra2tcuHBBOnbq1CmsW7dO1vr37t1Dv379EBcXh0GDBkkL/w0ZMgRqtVo6E6FNvr6+qFGjBhYvXiwNCKjVavTr1w8nTpzA5cuXtV4TYJCh91Cr1bh8+TJcXV1lD3eWlpa4evUq3NzcYG9vj0OHDsHX1xfXr19HvXr18M8//8hSt2rVqmjSpAkmTpwoBahChQqhU6dOaNy4Mfr27StLXQDw9/dHyZIlERoaCltbW1y8eBHGxsb45ptvMHjwYFln+QO6/8OWV+gqvOb2h+KHH35A7dq1Na5M08WKxmXKlMHatWt1FhizTuD/0OrF715RpE2hoaGYOHEiOnXqhEqVKmXbT0uurUAsLS1x/fp1uLi4oGjRoti5cycqVqyI27dvo0KFCkhMTJSlrj6Zm5vjwoULKFWqlMbxmzdvonz58rLNM+WppXfo8zQDADx//hynT5/Ocel0uYdHv/vuO/j6+qJHjx5Qq9WoU6cOTpw4AQsLC+zYsUM61SSHAgUK4MWLFwCAYsWK4cqVK/D19cXz58+l87xyuH79On777TcAGcPQr169gpWVFSZNmoSWLVvKGmQuXLiAJUuWwMDAAIaGhkhNTYWHhwdmzZqF4OBg2YOMs7OzrGs7ZPo35+PlngcGAKNHj8awYcOk8Lpp0yaN8Kotmaes32VoaIjjx49L68foamsGXa9TlTWcyBlUPqRfv34Acv79LedoUPHixfHPP//AxcUFnp6e0rpkkZGRMDU1laXmu27duoWVK1fi1q1bmD9/PgoVKoRdu3bBxcUFZcuW1Xq9ihUr4vr169mCzPXr1+Hn56f1ehLZltpToP379wsLCwvh4+MjjIyMRPny5YWdnZ2wtbWVfYl+IYTYvn27sLa2FiqVStja2go7OzvpVqBAAdnrFytWTERGRgohhNiyZYtwcnISN2/eFGPGjBFffPGFrLX1teV84cKFxbVr14QQGSufbtu2TQghxIULF4SlpaVsdYUQwsHBQVq23svLS+zevVsIkbHiqIWFhay1hRBiz549omHDhtJ2EHLJban0nG66YGVlJWJiYoQQQtjZ2YkrV64IITK+566urjrpQR/s7OyEiYmJMDAwEFZWVqJAgQIaN124evWq2LVrl9i2bZvGLT8aOXKkmDp1qhAiYzsEIyMjUaJECWFiYiJGjhwpe/1Dhw4Jc3NzERAQIExMTKQVjadPny7batLr168XLi4uYvbs2eLo0aPi6NGjYvbs2cLNzU2sX79eXLx4UbppE08tZaHP0wxAxgqnTZs2xbRp02BhYSFrrZyYmZkhJiYGxYsXR69evWBhYYF58+YhNjYWfn5+ss5019eW80FBQQgMDETPnj0xbNgwbNu2DV27dpXmSu3fv1+WugDQsGFDdO3aFR07dkTPnj1x6dIlDBo0CGvWrMGzZ8/w119/yVYbyBgFe/nyJd6+fSvrAoxZ537duXMHo0aNQteuXVGjRg0AwMmTJ7Fq1SpMnz5dJ/MYihQpgoiICHh7e6NMmTKYMWMGWrRogYsXL6JmzZpaX2YgLS0NpUuXxo4dO+Dt7a3V1/439LlO1e3bt9GqVStcvnxZY66MrjZIzQtOnTol/U5r3ry57PVq1KiBdu3aISQkRPp75uHhgdOnT6N169b4+++/tV4zc72g3GR+77U+EqbVWKRw+n6nZmFhobd9f4TI2INmz5494u3bt8LZ2Vns2LFDCCHElStXZN2TJC0tTaxatUo8fPhQthq5uXXrlvTuIDk5WfTu3Vv4+vqK1q1bS3uGyCUyMlIcPHhQCCFEfHy8aNSokbC2thYVK1aUfSM9IYQICwt7700O9erVkzaVy2rt2rWiTp06stR8V8uWLcXSpUuFEEIMHTpUlChRQkyZMkVUrFhR1K9fX5aaTk5O0sjf56hZs2aiZcuW4vHjx8LKykpcu3ZNHD16VFStWlUcOXJE9vqHDh0SzZo1E56ensLT01M0b95c1rpv3rwR3bp1kzYe1gdLS0upftY9pmJjY2XbS+3OnTsffdMmBpks9HmaQQghWrVqJTZs2CB7ndyMHz9e2NraitKlSwsXFxfx+vVrIYQQK1askH2X2KybjVH+ZW5uLp1Oy+rmzZvC3NxcJz3oI7xOnTpVBAcHSxv66UpiYqLG/7/vJid7e3vpa25jYyNu3LghhBDiwIEDonz58rLWXrNmjTAyMhLt27cX8+fPF/Pnzxft27cXxsbGYu3atbLVtbGx0WuQKVasmDh+/LgQQjPIbN68WXh4eOitLzlwsm8W1atXx7Fjx+Dt7Y2mTZti6NChuHz5MjZv3izbZZLbt2+X/j8wMBDDhw/HtWvXclw6Xa7Z9ZkmTJgAHx8fxMXFoV27dtKENENDQ4waNUrW2lWrVsWFCxf0OikwOTk52wRrXUw+zQtev36dbXK7HJ+7s7Mzli1bhlmzZmkcX758ubRNg9yybohpaWkp2xpRWUVGRuLAgQPYu3cvfH19s105I9eCj3llnSq1Wg1ra2sAgIODAx48eIBSpUrB1dUVN2/elK0uAEydOhWzZs3S2Mdr0KBBmDt3LiZPnoyOHTvKUjcoKAhbt27Vyf5hOfn6668xcuRI/P7771CpVEhPT8fx48cxbNgw2S8cuXbtWo4XzMj1N4xzZLK4ffs2kpOTUa5cOaSkpGDo0KHSOc25c+fK8kf2Q+cUM+liQTx92rhxI0aPHo0hQ4bkeImkXAtmxcbGYsCAATh06JDG8vi6+OWuz5VWgYzF+EaOHImNGzfi6dOn2e6Xo/6ff/6JNm3aoESJEqhWrRoA4PTp04iOjsamTZvQtGlTrdfMC7p16/be++XY9wbIO+tUffnllxg6dCiCgoLQsWNHPHv2DGPGjMHSpUtx9uxZXLlyRbbapqamuHr1arZtMWJiYuDj4yPbthhTpkzBnDlzUL9+/Rx/p8l9pdqbN2/Qv39/hIWFQa1Ww8jICGq1Gh07dkRYWJjGwq/aoq+5UAwyJJk0adJ775dzNcr3BTo5A0XNmjUhhMDgwYNRuHDhbO9Y5fzlrq8F6TL1798fERERmDx5Mjp37oxFixbh/v37WLJkCWbMmIFOnTrJUjcuLg6LFy/W2F+qT58+so7IFChQ4KNXspV76fjP0Z49e5CSkoLWrVsjJiYGzZo1Q1RUFOzt7bFhwwZp93U5lChRAsOHD0fv3r01joeGhuKHH35ATEyMLHX1uSFtVvfu3cOVK1eQnJyMChUqyLoVSPPmzWFoaIjly5fD3d0dp0+fxtOnTzF06FD88MMP+PLLL2WpyyCThYeHByIjI2Fvb69x/Pnz59JCRnI4ePAgBgwYgFOnTmUbzk9MTMQXX3yB0NBQ2X4IMr27UFZaWhpiY2NhZGQET09PnDt3Trba+lowy8rKCmfPns227oEu6HtBOhcXF6xevRr+/v6wsbHBuXPnUKJECaxZswa//fYb/vzzT730JYcPXbGTla5XgNUlfeyDk5uEhIR/FTA/1eLFi/Hdd9+he/fu+OKLLwBkbIuxcuVK/PDDDxg4cKCs9T8nDg4OOHjwIMqVKwdbW1ucPn0apUqVwsGDBzF06FCcP39elrqcI5PFnTt3cnznn5qaivv378tWd968eejZs2eOcxJsbW3Ru3dvzJ07V/Ygk9MPWVJSErp27Sr7fkdWVlZSgIyLi8OyZcvw6tUrtGjRQtbPu0qVKoiLi9NLkNHVgnS5SUhIkOaL2NjYSCMRtWrVkm2pgdz23FGpVDAzM4OLi4ssi4XpO5y4u7u/9w+2Lt6dHzlyBM2bN4etra1O98FJS0uTVnz18fGRjssdnn788UcMGTIEffv2RZEiRTBnzhxpPy9vb28sX74coaGhsgWZSZMmYdiwYdmW0nj16hVmz54t+35LarUaYWFh0qnrd+f/ybH9ir7mQnFEBv8/4TYoKAirVq2Cra2tdJ9arcaBAwewb98+2b4Rrq6u2L17d65rTNy4cQMNGzbEvXv3ZKn/IZcvX0bz5s1x584d2V47Li4OXl5eWL9+PRo3boyUlBQYGBggJSUF4eHhCAoK0nptIGPlyz59+uCbb76Bj49PtgnWcs3NAYC9e/dizpw5Oltp9V3lypXDTz/9hDp16iAgIADly5fHDz/8gAULFmDWrFmyrTOR+Qf93fPnAGBsbIyvvvoKS5YskXXHdbVaja1bt0ojE2XLlkWLFi1kmTcAAPPnz9f4OC0tDefPn8fu3bsxfPhw2SfTA/rbBwfIGO3esmWLvKu7vsPc3BxLlizJcWJrcnIyGjVqhKdPn0qnOLXN0NBQmmid1dOnT1GoUCHZ58ANGDAAYWFhCAwMzPHUdW4rT/8XepsLpYcrpfIclUolrT6a+f+ZNxMTE1GyZEnxxx9/yFbf1NRUREdH53p/dHS0MDMzk63+hxw9elS2dWQaN24smjVrJo4dOyZ69+4tihUrJrp37y7UarVQq9WiX79+olq1arLUFkKIkydPCnd3d43veebPgdwrzep7pdW5c+eK+fPnCyGE2LdvnzAzMxOmpqbCwMBAzJs3T5aaW7duFaVKlRLLly8Xly5dEpcuXRLLly8X3t7eYv369eLXX38VxYsXF0OHDpWlvhAZ/568vLyEhYWFqFChgqhQoYKwsLAQpUqVktaR0pWFCxeKrl276qSWmZmZdNlzVjdu3JD998vy5ctF06ZNxdOnT2Wtk9Xvv/8uzMzMsq0cnJycLGrVqiVKliwp7t+/L1t9lUolHj16lO34gQMHhIODg2x1M9nb24udO3fKXier3bt3i02bNgkhhIiKihKlSpUSKpVKODg4iP3798tWlyMyWbi7uyMyMhIODg46revp6Yk5c+bkOuqwefNmDBs2TPbh53c3uRNC4J9//sGaNWtQu3ZtaU8ibcp6TjU5ORk2NjaIjIxEpUqVAGSMRlWvXh3Pnz/Xem0gY46At7c3RowYkeNkXzkvB9fnSqs5uXv3Ls6ePYsSJUrINhJVtWpVTJ48GY0aNdI4vmfPHowdOxanT5/G1q1bMXToUNy6dUuWHpo2bQohBNauXSud3nj69Cm++eYbGBgYYOfOnbLUzcnt27dRvnx5WVfNzlSzZk0MHz482++ZrVu3YsaMGTh16pRstStUqICYmBikpaXB1dU12xU8cs2/W758OQYPHoydO3fC398fKSkpaNy4MR4+fIhDhw6hWLFiWq+ZOe8nMTERNjY2Gr9T1Go1kpOT0adPHyxatEjrtbNycnLCoUOHULJkSVnrfIgu5kIxyOQBAwcOxKFDhxAZGZltOP3Vq1eoWrUq6tatK8u261m9O8vewMAAjo6OqFevHkaPHi2d+9QmAwMDPHz4UBp+zbqUNpBxibKTk5Nsw7CWlpa4ePFitksz87u0tDQ0btwYoaGhsl7F8C5zc3OcP38epUuX1jh+48YNVKhQAa9evcKdO3dQpkwZ2TYLtbS0xKlTp+Dr66txXK4tCt5n1qxZ+Pnnn2U5bfuuDRs2YMSIERg4cKC0LtapU6ewaNEizJgxQ+PUtraD7MSJE997//jx47VaL6tZs2Zh6tSp2LZtG8aNG4f79+/j8OHDKF68uCz1Vq1aBSEEunfvjnnz5mlMVTAxMYGbm5u0PYec5syZg9u3b2PhwoWyT6j+mA1ujYyMUKRIETRo0EDrWzRwsi8y9np5+vQpmjVrJh1bvXo1xo8fj5SUFAQFBeGnn36SbcfSMWPGYPPmzShZsiQGDBggTTy9ceMGFi1aBLVaje+//16W2lnFxsZmO/b69WssWrQIXl5eePjwoSx13/1HJvc/uqzq1auXJ4KMrhaky2RsbJzrxFs5lS5dGjNmzMDSpUthYmICICNUzZgxQwo39+/fR+HChWXrwdTUVNppPavk5GSpJ22ZNGkShg4dilq1amn8XAsh8PDhQzx+/Bg///yzVmvmpkOHDgCAESNG5HifbPvg4P1BRe730iNGjEBCQgLq168PNzc3HDp0SLYQA/z/SKq7u7u0ho8+HDt2DBEREdi1axfKli2bbf6fNhdhzBrWcpOeno7o6GgsX74cw4YN++ByH/8Ggwwyftn4+/tLQeby5cvo0aMHunbtCm9vb8yePRtOTk6YMGGCLPULFy6MEydOoG/fvhg9erTGJMhGjRph0aJFsv5iT01NxYQJE7Bv3z6YmppKw88rV67EmDFjYGhoKOvqlF27dpVC4uvXr9GnTx9p6Dk1NVW2ukDGugdDhgzB5cuXdb6asj4WpMvqm2++wYoVKzBjxgxZ62S1aNEitGjRAsWLF5fe9V++fBlqtRo7duwAkHG6pV+/frL10KxZM/Tq1QsrVqxA1apVAQB//fUX+vTpo/Xv98SJE9GnTx+0bNlSI8hkjnb6+/tnG52SS05vVHRl9uzZGD58eLbjarUa33zzjSynrd8dJTA2NoaDgwMGDx6scVyuVZWtra1x/fp1aeRv27ZtWLlyJcqUKYMJEyZoPTS/y87OTvarTTP9mwUdd+zYgX79+mk1yPDUEoCiRYvijz/+kC5J/P7773H48GEcO3YMAPD7779j/PjxuHbtmuy9PHv2DDExMRBCwMvLS7Zdn7MaOXIklixZgoCAAJw4cQKPHz9Gt27dcOrUKfzvf/9Du3btZLua40MrnmaSa+VTfS3EB+hvQbpMAwcOxOrVq+Hl5ZXjyqNz586Vpe6LFy+wdu1aREVFAQBKlSqFjh07ynLqMifPnz9H165d8ccff0jvlt++fYsWLVogLCzso95dfqx3T51+rgoVKoTp06ejR48e0jG1Wo2vv/4aV65cka4e0yZ9/26pUqUKRo0ahTZt2uD27dsoU6YMWrdujcjISAQGBmLevHmy1M3rnj9/ju7du2s1QDLIADAzM0N0dLS0smitWrXQpEkT6XTOnTt34Ovrm+NwdH7g4eGBefPmoUWLFrhy5QrKlSuHrl27YsWKFTo9zfO50deCdLdv34abmxvq16+f62NUKpUs60zoU3p6OmbPno3t27fjzZs3cHFxQXBwMFQqFby9vWU5vWhgYID4+Hg4Ojpq/bU/xc2bN/HTTz9JwcHb2xsDBw6UfR2lyMhINGzYEMuWLUPbtm3x9u1btG/fHjdu3MDBgwdRpEgRWevrg62tLc6dOwdPT0/MnDkTBw8exJ49e3D8+HF8/fXXiIuL00kfjx8/lpYOKVWqVJ75WdQmnlpCxqmd2NhYODs7482bNzh37pzG5LQXL15kO+WQn/z999/SVUI+Pj4wNTXFkCFD8n2IyW2hLl3Rx4J0AODl5YV//vkHERERAICvvvoKCxYskPX0ZVbR0dGIiIjIcZEuORcJmzp1KiZMmICAgACYm5vjzz//hK2tLX755RfZagJAyZIlP/hvSRfbImzatAlff/01KleuLE02PXXqFHx8fLB+/Xq0adNGttpVqlTBpk2bEBQUBBMTE6xYsQIxMTGIiIjQ2c+drgkhpJ/v/fv3S1MXnJ2d8eTJE9nrp6SkSKOumX0YGhqiS5cu+Omnn7It1KdkDDLIuBxz1KhRmDlzJrZu3QoLCwuN1WQvXboET09PPXYoL7VarXG+1sjICFZWVnrsSDeMjY3h4uKit804PTw8EBsbCxcXF5QuXRobN25E1apV8ccff8DOzk62uu8Owu7atQspKSmy1ctq2bJl6Nu3LxwcHFCkSBGNP/AqlUrWILN69Wr8/PPP0p47+/fvR2BgIJYvX/7Rm7d+iokTJ2r1dNWnGjFiBEaPHp1tbsL48eMxYsQIWYMMkDGxfvXq1WjTpg28vb1x+PBhnS91oUuVK1fGlClTEBAQgMOHD2Px4sUAMuYq6SK8hYSE4PDhw/jjjz9Qs2ZNABkTgAcNGoShQ4dK/eQHPLUE4MmTJ2jdujWOHTsGKysrrFq1SmOSVP369VG9enVMnTpVj13Kx8DAAE2aNJEm3P7xxx+oV69etjkTck2K06cVK1Zg8+bNWLNmjc73m/nxxx9haGiIQYMGYf/+/WjevDmEEHjz5g1+/PHHbJMSteVDl7zLydXVFf369cPIkSNlr/UuU1NTxMTEaGxOaWZmhpiYGNmuYslLc2QsLCxw6dKlbKfQoqOj4efnp/XL3XO7JPfUqVMoUaKERojJj79bLl26hE6dOuHevXsICQmRrtwaOHAgnj59inXr1sla38HBAeHh4fD399c4HhERgfbt2+Px48ey1tcljsgg4xt+5MgRJCYmwsrKKtvE1t9//z1fj1C8u/DaN998o6dOdG/hwoWIiYmBk5OTThfqAqBxJVhAQABu3LiBs2fPwsvLK9saJ9qkUqn0dsn7s2fP0K5dO53Uetfbt2+zrdNkbGyMtLQ02WrmpdOz/v7+OHr0aLYgc+zYMVn2M8ttFOrdxRDzq3LlyuW47cPs2bNlu3giq5cvX+Y48lOoUCHZ1mjSF47I0GdNHwt16Xu3c32OwPXo0QNVqlRBnz59tP7aH/Lu5w3k/Llr8/POSyMyoaGhGDduHNq3b6+xIN7vv/+OiRMnwsnJSXqsnMsOkG7Ur18f9vb2WL16tRTgX716heDgYCQkJGD//v167lB7GGSIdKxFixaoW7durmvzLFiwABEREdiyZYss9fV5Wer06dMxd+5cBAYG5rhuz6BBg7ReM5O+L8fVt4+dB6TNZQdyW5re1tYWJUuWxLBhw9CgQQOt1Mprsm6QmhO55+ZduXIFjRo1QmpqqrRZ58WLF2FmZoY9e/agbNmystbXJQYZ+uw9f/4c4eHhuHXrFoYPH46CBQvi3LlzKFy4sCx7seT13c7l9O42GFmpVCrZ9xMj3cptP7Hnz5/j7Nmz2LBhA8LDw7W+ZH1esG3bNo2PM3c8X7VqFSZOnKixpo5cXr58ibVr10o7fHt7e6NTp04wNzeXvbYuMcjQZ+3SpUsICAiAra0t7ty5g5s3b8LDwwNjxozBvXv3sHr1aq3XNDMzw5UrV3JdtyQmJga+vr549eqV1msT5SVz585FeHg4Tpw4oe9WdGbdunXYsGFDtqBDn46TfemzFhISgq5du2LWrFkaK8s2bdoUHTt2lKVmsWLF3htkLl26hKJFi8pSmz4vCxYsQK9evWBmZvbBTWflPK2Xm2bNmmHKlCk6r6tP1atXR69evWR57e3bt3/0Y/PTPKjPfkTmc/3GU4asq29mvQz57t27KFWqFF6/fq31mnllt3NdCQkJweTJk2FpaYmQkJD3PlaubRE+V+7u7jhz5gzs7e3z5Gm9y5cvo0GDBrJtSJvXvHr1CqNHj8auXbuk1Xa16d15UJkbgb57DJB/jo4uffYjMkFBQRofv/uNzzpZKz994ymDqakpkpKSsh2PioqSbSnvvLLbua6cP39eusT5/Pnzeu7m85J1o0h9bhqZmxUrVqB8+fL6bkMW7050FkLgxYsXMDc3x9q1a2WpmXWl7P3792PkyJGYNm2atJLzyZMnMWbMGEybNk2W+vry2Y/IZPWhb3x+nV3/Ofv222/x9OlTbNy4EQULFsSlS5dgaGiIoKAg1K5dW7aN3e7evYu+fftiz549Oe52/r53z/nVixcvdLZxJOlGbiNwiYmJOHfuHKKionDkyBFpi5T85N2Jzpk7nlerVg3379+XfVsUHx8fhIaGolatWhrHjx49il69esmyUae+MMhk8Tl94ylDYmIi2rZtizNnzuDFixdwcnLCw4cPUb16dezatSvb2irapo/dzvXhxx9/zPVycyAjxDRu3BjHjx/XYVf534dO5WUlx2m9unXr5njcxsYGpUqVQt++fT+b0P7ixQv89ttvWLFiBc6cOSP7CL+5uTkiIyOzBaZLly6hWrVq+epiAgaZLD6nbzxpOn78OC5evIjk5GRUrFgRAQEB+m4pXzE3N8eSJUvQpUuXbPclJyejUaNGePr0qXSZKGlHbkHiXflxt/O84siRI1ixYgU2bdoEJycntG7dGm3atEGVKlVkrVu7dm2YmZlhzZo10gq/8fHx6NKlC16/fo3Dhw/LWl+XGGSy+Jy+8Z+7V69e4cCBA9KOtKNHj0Zqaqp0v5GRESZNmpRtMi59mvDwcHTu3BkbNmzQmDSfkpKCRo0a4dGjRzh8+DCv1qJ84eHDhwgLC8OKFSuQlJSE9u3bIzQ0FBcvXkSZMmV00kNMTAxatWqFqKgoaX+xuLg4eHl5YevWrbleNalEDDJZfE7f+M9daGgodu7ciT/++ANAxsaJZcuWlRaKunHjBkaMGPHe0yH07yxfvhyDBw/Gzp074e/vj5SUFDRu3BgPHz7E4cOHNZbIJ1Kq5s2b48iRIwgMDESnTp3QuHFjGBoawtjYWKdBBsiYYLxv3z6NBfECAgLy1B5g2sAg847P5Rv/ufvyyy8xYsQIaUXRd3eA/vXXX7Fo0SKcPHlSn23mO7NmzcLUqVOxbds2jBs3Dvfv38fhw4dl2336c9e6dWuEhYXBxsYm192oM+XHHaj1wcjICIMGDULfvn3h5eUlHddHkPlcfPaXX79LpVKhYcOGqF27NkxNTRlg8qnM1XMzmZmZaazBULVqVfTv318freVrI0aMQEJCAurXrw83NzccOnSIIUZGtra20u+w3HajJu06duwYVqxYgUqVKsHb2xudO3fG119/rZdeDhw4gAMHDuDRo0cal2YDwC+//KKXnuTAEZks0tPTMXXqVISGhiI+Ph5RUVHw8PDA2LFj4ebmppO9MUg3zM3NceHCBWkNl3fduHED5cuXl2VBvM/Ru6MBf/75J/z8/LLtZcVRAcovUlJSsGHDBvzyyy84ffo01Go15s6di+7du+tkmYGJEydi0qRJqFy5MooWLZrtTblcm9LqA0dkspgyZQpWrVqFWbNmoWfPntJxHx8fzJs3j0EmHylevDiuXLmSa5C5dOkSRwq06N3RgA4dOuipEyLdsLS0RPfu3dG9e3fcvHkTK1aswIwZMzBq1Cg0aNDgX60q/ylCQ0MRFhaGzp07y1onL+CITBYlSpTAkiVLUL9+fY05Ezdu3ECNGjXw7NkzfbdIWjJ48GDs378fZ8+ezXGbgMqVKyMgIADz58/XU4dE2hUfH49hw4ZJpxre/dXPlcvlp1ar8ccff+CXX36RPcjY29vj9OnT8PT0lLVOXsAgk4W5uTlu3LgBV1dXjSBz7do1VK1aFcnJyfpukbQkPj4e5cuXh4mJCQYMGICSJUsCAG7evImFCxfi7du3OH/+vHQZPpHSNWnSBPfu3cOAAQNyPNXQsmVLPXVGchg5ciSsrKwwduxYfbciO55ayqJMmTI4evQoXF1dNY6Hh4ejQoUKeuqK5FC4cGGcOHECffv2xahRozS2CWjQoAF+/vlnhhjKV44dO4ajR4/m272NSNPr16+xdOlS7N+/H+XKlYOxsbHG/flpg1YGmSzGjRuH4OBg3L9/H+np6di8eTNu3ryJ1atXY8eOHfpuj7TM3d0du3fvRkJCAmJiYgBknF4sWLCgnjsj0j5nZ+dsp5Mo/7p06ZIUWq9cuaLfZmTGU0vvOHr0KCZNmqSxXP24cePQsGFDfbdGRPTJ9u7dizlz5mDJkiVwc3PTdztEWsMgQ0SUTxUoUEBjLkxKSgrevn0LCwuLbKcaEhISdN0eyeBDCx8CGafQN23apINudIOnlrLw8PBAZGQk7O3tNY4/f/4cFStWxO3bt/XUGZFy/ZurM7Luw0T/3bx58/TdAunY57jwIUdksjAwMMDDhw9RqFAhjePx8fFwcXHR2FSQiD5O1hWTgYx3g1l/7WQdMeAlwNqnVqvxww8/YPv27Xjz5g3q16+P8ePHS/uKESkdR2Sg+Y5xz549GolWrVbjwIEDPKdM9ImyLo2+f/9+jBw5EtOmTUONGjUAACdPnsSYMWMwbdo0fbWYr02bNg0TJkxAQEAAzM3NMX/+fDx69ChfLVFPnzeOyOD/3zG++04RyNjoy83NDXPmzEGzZs300R5RvuHj44PQ0FDUqlVL4/jRo0fRq1cvXL9+XU+d5V9eXl4YNmwYevfuDSAjTAYGBuLVq1fZRsuIlIgjMvj/d4zu7u6IjIyEg4ODnjsiyp9u3boFOzu7bMdtbW1x584dnffzObh37x6aNm0qfRwQEACVSoUHDx5wGw7KFxjHs4iNjWWIIZJRlSpVEBISgvj4eOlYfHw8hg8fjqpVq+qxs/zr7du32bbhMDY2Rlpamp46ItKuz/7U0oIFC9CrVy+YmZlhwYIF733soEGDdNQVUf4UExODVq1aISoqCs7OzgCAuLg4eHl5YevWrShRooSeO8x/DAwM0KRJE5iamkrH/vjjD9SrVw+WlpbSMe48Tkr12QcZd3d3nDlzBvb29nB3d8/1cSqVipdfE2mBEAL79u3DjRs3AADe3t7S6Q7Svm7dun3U41auXClzJ0Ty+OyDDBHpx+vXr2FqasoAQ0T/CefIEJHOpKenY/LkyShWrBisrKwQGxsLABg7dixWrFih5+6ISIl41VIWarUaYWFhOHDgAB49eqSx/gUAHDx4UE+dEeUPU6ZMwapVqzBr1iz07NlTOu7j44N58+ahR48eeuyOiJSIQSaLwYMHIywsDIGBgfDx8eGQN5GWrV69GkuXLkX9+vXRp08f6bifn580Z4aI6N9gkMli/fr12Lhxo8aaC0SkPffv38/xyqT09HReDkxEn4RzZLIwMTHh5Z9EMipTpgyOHj2a7Xh4eDgqVKigh46ISOk4IpPF0KFDMX/+fCxcuJCnlYhkMG7cOAQHB+P+/ftIT0/H5s2bcfPmTaxevRo7duzQd3tEpEC8/DqLVq1aISIiAgULFkTZsmVhbGyscT8XjCL6744ePYpJkybh4sWLSE5ORsWKFTFu3Dg0bNhQ360RkQIxyGTxoYWjuGAUERFR3sIgQ0Q64+HhgcjISNjb22scf/78OSpWrMjVs4noX+NkXyLSmTt37kCtVmc7npqaivv37+uhIyJSOk72BVCgQIEcJ/fa2tqiZMmSGDZsGBo0aKCHzojyh+3bt0v/v2fPHtja2kofq9VqHDhwAG5ubnrojIiUjqeWAKxatSrH48+fP8fZs2exYcMGhIeHo3nz5jrujCh/MDDIGPxVqVR491eOsbEx3NzcMGfOHDRr1kwf7RGRgjHIfIS5c+ciPDwcJ06c0HcrRIrm7u6OyMhIODg46LsVIsonGGQ+QlRUFKpXr46EhAR9t0JERERZcI7MR0hNTYWJiYm+2yBSpAULFqBXr14wMzPDggUL3vvYQYMG6agrIsovOCLzEb777jvcuHEDu3fv1ncrRIrj7u6OM2fOwN7eHu7u7rk+TqVS8fJrIvrXGGQAhISE5Hg8MTER586dQ1RUFI4cOYJKlSrpuDMiIiJ6H55aAnD+/Pkcj9vY2KBBgwbYvHnze99JEhERkX5wRIaIdEatViMsLAwHDhzAo0ePkJ6ernH/wYMH9dQZESkVR2SISGcGDx6MsLAwBAYGwsfHh7vME9F/xhEZItIZBwcHrF69Gk2bNtV3K0SUT3CvJSLSGRMTE5QoUULfbRBRPsIgQ0Q6M3ToUMyfPz/bNgVERJ+Kp5aISGdatWqFiIgIFCxYEGXLloWxsbHG/Zs3b9ZTZ0SkVJzsS0Q6Y2dnh1atWum7DSLKRzgiQ0RERIrFOTJERESkWDy1RESyK1CgQI5rxtja2qJkyZIYNmwYGjRooIfOiEjpeGqJiGS3atWqHI8/f/4cZ8+exYYNGxAeHo7mzZvruDMiUjoGGSLSu7lz5yI8PBwnTpzQdytEpDAMMkSkd1FRUahevToSEhL03QoRKQwn+xKR3qWmpsLExETfbRCRAjHIEJHerVixAuXLl9d3G0SkQLxqiYhkFxISkuPxxMREnDt3DlFRUThy5IiOuyKi/IBBhohkd/78+RyP29jYoEGDBti8eTPc3d113BUR5Qec7EtERESKxTkyREREpFgMMkRERKRYDDJERESkWAwyREREpFgMMkRERKRYDDJElG+EhYXBzs5O320QkQ4xyBCRTnTt2hUqlQoqlQrGxsZwd3fHiBEj8Pr1a63V+OqrrxAVFaW11yOivI8L4hGRzjRu3BgrV65EWloazp49i+DgYKhUKsycOVMrr29ubg5zc3OtvBYRKQNHZIhIZ0xNTVGkSBE4OzsjKCgIAQEB2LdvHwAgPT0d06dPh7u7O8zNzeHn54fw8HCN52/fvh1eXl4wMzND3bp1sWrVKqhUKjx//hxAzqeWFi9eDE9PT5iYmKBUqVJYs2aNxv0qlQrLly9Hq1atYGFhAS8vL2zfvl22rwERaReDDBHpxZUrV3DixAlp1+vp06dj9erVCA0NxdWrVzFkyBB88803OHz4MAAgNjYWbdu2RVBQEC5evIjevXvj+++/f2+NLVu2YPDgwRg6dCiuXLmC3r17o1u3boiIiNB43MSJE9G+fXtcunQJTZs2RadOnZCQkCDPJ05E2iWIiHQgODhYGBoaCktLS2FqaioACAMDAxEeHi5ev34tLCwsxIkTJzSe06NHD9GhQwchhBAjR44UPj4+Gvd///33AoB49uyZEEKIlStXCltbW+n+L774QvTs2VPjOe3atRNNmzaVPgYgxowZI32cnJwsAIhdu3Zp49MmIplxjgwR6UzdunWxePFipKSk4Mcff4SRkRHatGmDq1ev4uXLl2jQoIHG49+8eYMKFSoAAG7evIkqVapo3F+1atX31rt+/Tp69eqlcaxmzZqYP3++xrFy5cpJ/29paQkbGxs8evToX39+RKR7DDJEpDOWlpYoUaIEAOCXX36Bn58fVqxYAR8fHwDAzp07UaxYMY3nmJqayt6XsbGxxscqlQrp6emy1yWi/45Bhoj0wsDAAP/73/8QEhKCqKgomJqa4t69e6hTp06Ojy9VqhT+/PNPjWORkZHvreHt7Y3jx48jODhYOnb8+HGUKVPmv38CRJQnMMgQkd60a9cOw4cPx5IlSzBs2DAMGTIE6enpqFWrFhITE3H8+HHY2NggODgYvXv3xty5czFy5Ej06NEDFy5cQFhYGICMEZScDB8+HO3bt0eFChUQEBCAP/74A5s3b8b+/ft1+FkSkZwYZIhIb4yMjDBgwADMmjULsbGxcHR0xPTp03H79m3Y2dmhYsWK+N///gcAcHd3R3h4OIYOHYr58+ejRo0a+P7779G3b99cTz8FBQVh/vz5+OGHHzB48GC4u7tj5cqV8Pf31+FnSURyUgkhhL6bICL6FFOnTkVoaCji4uL03QoR6QlHZIhIMX7++WdUqVIF9vb2OH78OGbPno0BAwbouy0i0iMGGSJSjOjoaEyZMgUJCQlwcXHB0KFDMXr0aH23RUR6xFNLREREpFjcooCIiIgUi0GGiIiIFItBhoiIiBSLQYaIiIgUi0GGiIiIFItBhoiIiBSLQYaIiIgUi0GGiIiIFOv/AK3PbvF1LTQcAAAAAElFTkSuQmCC)