<a id="mypy-boto3-databrew"></a>

# mypy-boto3-databrew

[![PyPI - mypy-boto3-databrew](https://img.shields.io/pypi/v/mypy-boto3-databrew.svg?color=blue)](https://pypi.org/project/mypy-boto3-databrew)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-databrew.svg?color=blue)](https://pypi.org/project/mypy-boto3-databrew)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)
[![PyPI - Downloads](https://img.shields.io/pypi/dm/mypy-boto3-databrew?color=blue)](https://pypistats.org/packages/mypy-boto3-databrew)

![boto3.typed](https://github.com/vemel/mypy_boto3_builder/raw/master/logo.png)

Type annotations for
[boto3.GlueDataBrew 1.20.32](https://boto3.amazonaws.com/v1/documentation/api/1.20.32/reference/services/databrew.html#GlueDataBrew)
service compatible with [VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/),
[Emacs](https://www.gnu.org/software/emacs/),
[Sublime Text](https://www.sublimetext.com/),
[mypy](https://github.com/python/mypy),
[pyright](https://github.com/microsoft/pyright) and other tools.

Generated by
[mypy-boto3-builder 6.3.0](https://github.com/vemel/mypy_boto3_builder).

More information can be found on
[boto3-stubs](https://pypi.org/project/boto3-stubs/) page and in
[mypy-boto3-databrew docs](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_databrew/)

See how it helps to find and fix potential bugs:

![boto3-stubs demo](https://github.com/vemel/mypy_boto3_builder/raw/master/demo.gif)

- [mypy-boto3-databrew](#mypy-boto3-databrew)
  - [How to install](#how-to-install)
    - [VSCode extension](#vscode-extension)
    - [From PyPI with pip](#from-pypi-with-pip)
  - [Usage](#usage)
    - [VSCode](#vscode)
    - [PyCharm](#pycharm)
    - [Other IDEs](#other-ides)
    - [mypy](#mypy)
    - [pyright](#pyright)
  - [Explicit type annotations](#explicit-type-annotations)
    - [Client annotations](#client-annotations)
    - [Paginators annotations](#paginators-annotations)
    - [Literals](#literals)
    - [Typed dictionaries](#typed-dictionaries)
  - [Versioning](#versioning)
  - [Documentation](#documentation)
  - [Support and contributing](#support-and-contributing)

<a id="how-to-install"></a>

## How to install

<a id="vscode-extension"></a>

### VSCode extension

Add
[AWS Boto3](https://marketplace.visualstudio.com/items?itemName=Boto3typed.boto3-ide)
extension to your VSCode and run `AWS boto3: Quick Start` command.

Click `Modify` and select `boto3 common` and `GlueDataBrew`.

<a id="from-pypi-with-pip"></a>

### From PyPI with pip

Install `boto3-stubs` for `GlueDataBrew` service.

```bash
python -m pip install boto3-stubs[databrew]
```

<a id="usage"></a>

## Usage

<a id="vscode"></a>

### VSCode

- Install
  [Python extension](https://marketplace.visualstudio.com/items?itemName=ms-python.python)
- Install
  [Pylance extension](https://marketplace.visualstudio.com/items?itemName=ms-python.vscode-pylance)
- Set `Pylance` as your Python Language Server
- Install `boto-stubs[databrew]` in your environment:
  `python -m pip install 'boto3-stubs[databrew]'`

Both type checking and auto-complete should work for `GlueDataBrew` service. No
explicit type annotations required, write your `boto3` code as usual.

<a id="pycharm"></a>

### PyCharm

- Install `boto-stubs[databrew]` in your environment:
  `python -m pip install 'boto3-stubs[databrew]'`

Both type checking and auto-complete should work for `GlueDataBrew` service. No
explicit type annotations required, write your `boto3` code as usual.
Auto-complete can be slow on big projects or if you have a lot of installed
`boto3-stubs` submodules.

<a id="other-ides"></a>

### Other IDEs

Not tested, but as long as your IDE supports `mypy` or `pyright`, everything
should work.

<a id="mypy"></a>

### mypy

- Install `mypy`: `python -m pip install mypy`
- Install `boto-stubs[databrew]` in your environment:
  `python -m pip install 'boto3-stubs[databrew]'`
- Run `mypy` as usual

Type checking should work for `GlueDataBrew` service. No explicit type
annotations required, write your `boto3` code as usual.

<a id="pyright"></a>

### pyright

- Install `pyright`: `yarn global add pyright`
- Install `boto-stubs[databrew]` in your environment:
  `python -m pip install 'boto3-stubs[databrew]'`
- Optionally, you can install `boto3-stubs` to `typings` folder.

Type checking should work for `GlueDataBrew` service. No explicit type
annotations required, write your `boto3` code as usual.

<a id="explicit-type-annotations"></a>

## Explicit type annotations

<a id="client-annotations"></a>

### Client annotations

`GlueDataBrewClient` provides annotations for `boto3.client("databrew")`.

```python
import boto3

from mypy_boto3_databrew import GlueDataBrewClient

client: GlueDataBrewClient = boto3.client("databrew")

# now client usage is checked by mypy and IDE should provide code auto-complete

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: GlueDataBrewClient = session.client("databrew")
```

<a id="paginators-annotations"></a>

### Paginators annotations

`mypy_boto3_databrew.paginator` module contains type annotations for all
paginators.

```python
from mypy_boto3_databrew import GlueDataBrewClient
from mypy_boto3_databrew.paginator import (
    ListDatasetsPaginator,
    ListJobRunsPaginator,
    ListJobsPaginator,
    ListProjectsPaginator,
    ListRecipeVersionsPaginator,
    ListRecipesPaginator,
    ListRulesetsPaginator,
    ListSchedulesPaginator,
)

client: GlueDataBrewClient = boto3.client("databrew")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
list_datasets_paginator: ListDatasetsPaginator = client.get_paginator("list_datasets")
list_job_runs_paginator: ListJobRunsPaginator = client.get_paginator("list_job_runs")
list_jobs_paginator: ListJobsPaginator = client.get_paginator("list_jobs")
list_projects_paginator: ListProjectsPaginator = client.get_paginator("list_projects")
list_recipe_versions_paginator: ListRecipeVersionsPaginator = client.get_paginator("list_recipe_versions")
list_recipes_paginator: ListRecipesPaginator = client.get_paginator("list_recipes")
list_rulesets_paginator: ListRulesetsPaginator = client.get_paginator("list_rulesets")
list_schedules_paginator: ListSchedulesPaginator = client.get_paginator("list_schedules")
```

<a id="literals"></a>

### Literals

`mypy_boto3_databrew.literals` module contains literals extracted from shapes
that can be used in user code for type checking.

```python
from mypy_boto3_databrew.literals import (
    AnalyticsModeType,
    CompressionFormatType,
    DatabaseOutputModeType,
    EncryptionModeType,
    InputFormatType,
    JobRunStateType,
    JobTypeType,
    ListDatasetsPaginatorName,
    ListJobRunsPaginatorName,
    ListJobsPaginatorName,
    ListProjectsPaginatorName,
    ListRecipeVersionsPaginatorName,
    ListRecipesPaginatorName,
    ListRulesetsPaginatorName,
    ListSchedulesPaginatorName,
    LogSubscriptionType,
    OrderType,
    OrderedByType,
    OutputFormatType,
    ParameterTypeType,
    SampleModeType,
    SampleTypeType,
    SessionStatusType,
    SourceType,
    ThresholdTypeType,
    ThresholdUnitType,
    ValidationModeType,
    ServiceName,
    PaginatorName,
)

def check_value(value: AnalyticsModeType) -> bool:
    ...
```

<a id="typed-dictionaries"></a>

### Typed dictionaries

`mypy_boto3_databrew.type_defs` module contains structures and shapes assembled
to typed dictionaries for additional type checking.

```python
from mypy_boto3_databrew.type_defs import (
    AllowedStatisticsTypeDef,
    BatchDeleteRecipeVersionRequestRequestTypeDef,
    BatchDeleteRecipeVersionResponseTypeDef,
    ColumnSelectorTypeDef,
    ColumnStatisticsConfigurationTypeDef,
    ConditionExpressionTypeDef,
    CreateDatasetRequestRequestTypeDef,
    CreateDatasetResponseTypeDef,
    CreateProfileJobRequestRequestTypeDef,
    CreateProfileJobResponseTypeDef,
    CreateProjectRequestRequestTypeDef,
    CreateProjectResponseTypeDef,
    CreateRecipeJobRequestRequestTypeDef,
    CreateRecipeJobResponseTypeDef,
    CreateRecipeRequestRequestTypeDef,
    CreateRecipeResponseTypeDef,
    CreateRulesetRequestRequestTypeDef,
    CreateRulesetResponseTypeDef,
    CreateScheduleRequestRequestTypeDef,
    CreateScheduleResponseTypeDef,
    CsvOptionsTypeDef,
    CsvOutputOptionsTypeDef,
    DataCatalogInputDefinitionTypeDef,
    DataCatalogOutputTypeDef,
    DatabaseInputDefinitionTypeDef,
    DatabaseOutputTypeDef,
    DatabaseTableOutputOptionsTypeDef,
    DatasetParameterTypeDef,
    DatasetTypeDef,
    DatetimeOptionsTypeDef,
    DeleteDatasetRequestRequestTypeDef,
    DeleteDatasetResponseTypeDef,
    DeleteJobRequestRequestTypeDef,
    DeleteJobResponseTypeDef,
    DeleteProjectRequestRequestTypeDef,
    DeleteProjectResponseTypeDef,
    DeleteRecipeVersionRequestRequestTypeDef,
    DeleteRecipeVersionResponseTypeDef,
    DeleteRulesetRequestRequestTypeDef,
    DeleteRulesetResponseTypeDef,
    DeleteScheduleRequestRequestTypeDef,
    DeleteScheduleResponseTypeDef,
    DescribeDatasetRequestRequestTypeDef,
    DescribeDatasetResponseTypeDef,
    DescribeJobRequestRequestTypeDef,
    DescribeJobResponseTypeDef,
    DescribeJobRunRequestRequestTypeDef,
    DescribeJobRunResponseTypeDef,
    DescribeProjectRequestRequestTypeDef,
    DescribeProjectResponseTypeDef,
    DescribeRecipeRequestRequestTypeDef,
    DescribeRecipeResponseTypeDef,
    DescribeRulesetRequestRequestTypeDef,
    DescribeRulesetResponseTypeDef,
    DescribeScheduleRequestRequestTypeDef,
    DescribeScheduleResponseTypeDef,
    EntityDetectorConfigurationTypeDef,
    ExcelOptionsTypeDef,
    FilesLimitTypeDef,
    FilterExpressionTypeDef,
    FormatOptionsTypeDef,
    InputTypeDef,
    JobRunTypeDef,
    JobSampleTypeDef,
    JobTypeDef,
    JsonOptionsTypeDef,
    ListDatasetsRequestRequestTypeDef,
    ListDatasetsResponseTypeDef,
    ListJobRunsRequestRequestTypeDef,
    ListJobRunsResponseTypeDef,
    ListJobsRequestRequestTypeDef,
    ListJobsResponseTypeDef,
    ListProjectsRequestRequestTypeDef,
    ListProjectsResponseTypeDef,
    ListRecipeVersionsRequestRequestTypeDef,
    ListRecipeVersionsResponseTypeDef,
    ListRecipesRequestRequestTypeDef,
    ListRecipesResponseTypeDef,
    ListRulesetsRequestRequestTypeDef,
    ListRulesetsResponseTypeDef,
    ListSchedulesRequestRequestTypeDef,
    ListSchedulesResponseTypeDef,
    ListTagsForResourceRequestRequestTypeDef,
    ListTagsForResourceResponseTypeDef,
    MetadataTypeDef,
    OutputFormatOptionsTypeDef,
    OutputTypeDef,
    PaginatorConfigTypeDef,
    PathOptionsTypeDef,
    ProfileConfigurationTypeDef,
    ProjectTypeDef,
    PublishRecipeRequestRequestTypeDef,
    PublishRecipeResponseTypeDef,
    RecipeActionTypeDef,
    RecipeReferenceTypeDef,
    RecipeStepTypeDef,
    RecipeTypeDef,
    RecipeVersionErrorDetailTypeDef,
    ResponseMetadataTypeDef,
    RuleTypeDef,
    RulesetItemTypeDef,
    S3LocationTypeDef,
    S3TableOutputOptionsTypeDef,
    SampleTypeDef,
    ScheduleTypeDef,
    SendProjectSessionActionRequestRequestTypeDef,
    SendProjectSessionActionResponseTypeDef,
    StartJobRunRequestRequestTypeDef,
    StartJobRunResponseTypeDef,
    StartProjectSessionRequestRequestTypeDef,
    StartProjectSessionResponseTypeDef,
    StatisticOverrideTypeDef,
    StatisticsConfigurationTypeDef,
    StopJobRunRequestRequestTypeDef,
    StopJobRunResponseTypeDef,
    TagResourceRequestRequestTypeDef,
    ThresholdTypeDef,
    UntagResourceRequestRequestTypeDef,
    UpdateDatasetRequestRequestTypeDef,
    UpdateDatasetResponseTypeDef,
    UpdateProfileJobRequestRequestTypeDef,
    UpdateProfileJobResponseTypeDef,
    UpdateProjectRequestRequestTypeDef,
    UpdateProjectResponseTypeDef,
    UpdateRecipeJobRequestRequestTypeDef,
    UpdateRecipeJobResponseTypeDef,
    UpdateRecipeRequestRequestTypeDef,
    UpdateRecipeResponseTypeDef,
    UpdateRulesetRequestRequestTypeDef,
    UpdateRulesetResponseTypeDef,
    UpdateScheduleRequestRequestTypeDef,
    UpdateScheduleResponseTypeDef,
    ValidationConfigurationTypeDef,
    ViewFrameTypeDef,
)

def get_structure() -> AllowedStatisticsTypeDef:
    return {
      ...
    }
```

<a id="versioning"></a>

## Versioning

`mypy-boto3-databrew` version is the same as related `boto3` version and
follows [PEP 440](https://www.python.org/dev/peps/pep-0440/) format.

<a id="documentation"></a>

## Documentation

All type annotations can be found in
[mypy-boto3-databrew docs](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_databrew/)

<a id="support-and-contributing"></a>

## Support and contributing

This package is auto-generated. Please reports any bugs or request new features
in [mypy-boto3-builder](https://github.com/vemel/mypy_boto3_builder/issues/)
repository.
