"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.MyMongo = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const constructs_1 = require("constructs");
const k8s = require("./imports/k8s");
/**
 * (experimental) MongoDB Stateful Set class.
 *
 * @experimental
 */
class MyMongo extends constructs_1.Construct {
    /**
     * @experimental
     */
    constructor(scope, name, opts) {
        var _b, _c, _d, _e, _f, _g, _h, _j;
        super(scope, name);
        const volumerequest = {
            storage: k8s.Quantity.fromString(String(opts.volumeSize)),
        };
        const defaultReplicas = (_b = opts.defaultReplicas) !== null && _b !== void 0 ? _b : 3;
        const replicas = defaultReplicas;
        const imageName = opts.image;
        const namespace = (_c = opts.namespace) !== null && _c !== void 0 ? _c : 'default';
        this.namespace = namespace;
        var storageClassName = (_d = opts.storageClassName) !== null && _d !== void 0 ? _d : 'gp2-expandable';
        const volumeProvisioner = (_e = opts.volumeProvisioner) !== null && _e !== void 0 ? _e : 'kubernetes.io/aws-ebs';
        const storageClassParams = (_f = opts.storageClassParams) !== null && _f !== void 0 ? _f : { type: 'gp2', fsType: 'ext4' };
        const nodeSelectorParams = (_g = opts.nodeSelectorParams) !== null && _g !== void 0 ? _g : undefined;
        const resources = {
            limits: convertQuantity((_h = opts.resources) === null || _h === void 0 ? void 0 : _h.limits, {
                cpu: '400m',
                memory: '512Mi',
            }),
            requests: convertQuantity((_j = opts.resources) === null || _j === void 0 ? void 0 : _j.requests, {
                cpu: '200m',
                memory: '256Mi',
            }),
        };
        const labels = { db: name };
        if (opts.createStorageClass === true) {
            const storageClassOpts = {
                metadata: {
                    name: opts.storageClassName,
                },
                provisioner: volumeProvisioner,
                allowVolumeExpansion: true,
                reclaimPolicy: 'Retain',
                parameters: {
                    ...storageClassParams,
                },
            };
            const storageclass = new k8s.KubeStorageClass(this, 'storageclass', storageClassOpts);
            this.name = storageclass.name;
            var storageClassName = storageclass.name;
        }
        const serviceOpts = {
            metadata: {
                namespace: namespace,
                name: name,
            },
            spec: {
                type: 'ClusterIP',
                clusterIP: 'None',
                ports: [{ port: 27017, targetPort: k8s.IntOrString.fromNumber(27017) }],
                selector: labels,
            },
        };
        const svc = new k8s.KubeService(this, 'service', serviceOpts);
        this.name = svc.name;
        const clusterroleOpts = {
            metadata: {
                namespace: namespace,
                name: 'get-pods-role',
            },
            rules: [
                {
                    verbs: ['list'],
                    apiGroups: ['*'],
                    resources: ['pods'],
                },
            ],
        };
        const clusterrole = new k8s.KubeClusterRole(this, 'clusterrole', clusterroleOpts);
        this.name = clusterrole.name;
        const serviceaccountOpts = {
            metadata: {
                namespace: namespace,
                name: name,
            },
        };
        const sa = new k8s.KubeServiceAccount(this, 'serviceaccount', serviceaccountOpts);
        this.name = sa.name;
        const bindingOpts = {
            roleRef: {
                kind: 'ClusterRole',
                apiGroup: '',
                name: 'get-pods-role',
            },
            metadata: {
                namespace: namespace,
                name: name,
            },
            subjects: [
                {
                    kind: 'ServiceAccount',
                    name: name,
                    namespace: namespace,
                },
            ],
        };
        const clusterrolebinding = new k8s.KubeClusterRoleBinding(this, 'rolebinding', bindingOpts);
        this.name = clusterrolebinding.name;
        const pvcProps = {
            metadata: {
                name: name,
            },
            spec: {
                accessModes: ['ReadWriteOnce'],
                storageClassName: storageClassName,
                resources: {
                    requests: volumerequest,
                },
            },
        };
        const stsOpts = {
            metadata: {
                namespace: namespace,
                name: name,
            },
            spec: {
                serviceName: name,
                selector: { matchLabels: labels },
                replicas: replicas,
                template: {
                    metadata: { labels: labels },
                    spec: {
                        containers: [
                            {
                                name: 'mongo-sidecar',
                                image: 'cvallance/mongo-k8s-sidecar',
                                env: [
                                    {
                                        name: 'MONGO_SIDECAR_POD_LABELS',
                                        value: `db=${name}`,
                                    },
                                    {
                                        name: 'KUBE_NAMESPACE',
                                        value: namespace,
                                    },
                                    {
                                        name: 'MONGODB_DATABASE',
                                        value: 'admin',
                                    },
                                    {
                                        name: 'MONGODB_USERNAME',
                                        valueFrom: {
                                            secretKeyRef: {
                                                key: 'username',
                                                name: name,
                                            },
                                        },
                                    },
                                    {
                                        name: 'MONGODB_PASSWORD',
                                        valueFrom: {
                                            secretKeyRef: {
                                                key: 'password',
                                                name: name,
                                            },
                                        },
                                    },
                                ],
                            },
                            {
                                name: name,
                                image: imageName,
                                env: [
                                    {
                                        name: 'MONGO_INITDB_ROOT_USERNAME',
                                        valueFrom: {
                                            secretKeyRef: {
                                                key: 'username',
                                                name: name,
                                            },
                                        },
                                    },
                                    {
                                        name: 'MONGO_INITDB_ROOT_PASSWORD',
                                        valueFrom: {
                                            secretKeyRef: {
                                                key: 'password',
                                                name: name,
                                            },
                                        },
                                    },
                                ],
                                resources: resources,
                                ports: [
                                    {
                                        containerPort: 27017,
                                    },
                                ],
                                args: [
                                    '--replSet',
                                    'rs0',
                                    '--bind_ip',
                                    '0.0.0.0',
                                    '--dbpath',
                                    '/data/db',
                                    '--oplogSize',
                                    '128',
                                ],
                                volumeMounts: [
                                    {
                                        name: name,
                                        mountPath: '/data/db',
                                    },
                                ],
                            },
                        ],
                        terminationGracePeriodSeconds: 10,
                        serviceAccountName: name,
                        nodeSelector: nodeSelectorParams,
                        securityContext: {
                            fsGroup: 999,
                            runAsGroup: 999,
                            runAsUser: 999,
                        },
                    },
                },
                volumeClaimTemplates: [pvcProps],
            },
        };
        const sts = new k8s.KubeStatefulSet(this, 'sts', stsOpts);
        this.name = sts.name;
    }
}
exports.MyMongo = MyMongo;
_a = JSII_RTTI_SYMBOL_1;
MyMongo[_a] = { fqn: "cdk8s-mongo-sts.MyMongo", version: "0.0.7" };
/**
 * Converts a `ResourceQuantity` type to a k8s.Quantity map.
 *
 * If `user` is defined, the values provided there (or lack thereof) will be
 * passed on. This means that if the user, for example, did not specify a value
 * for `cpu`, this value will be omitted from the resource requirements. This is
 * intentional, in case the user intentionally wants to omit a constraint.
 *
 * If `user` is not defined, `defaults` are used.
 */
function convertQuantity(user, defaults) {
    // defaults
    if (!user) {
        return {
            cpu: k8s.Quantity.fromString(defaults.cpu),
            memory: k8s.Quantity.fromString(defaults.memory),
        };
    }
    const result = {};
    if (user.cpu) {
        result.cpu = k8s.Quantity.fromString(user.cpu);
    }
    if (user.memory) {
        result.memory = k8s.Quantity.fromString(user.memory);
    }
    return result;
}
//# sourceMappingURL=data:application/json;base64,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