# aind-tars-service-client

## aind-tars-service

Service to pull data from TARS.



This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 0.1.1
- Package version: 0.1.1
- Generator version: 7.13.0
- Build package: org.openapitools.codegen.languages.PythonClientCodegen

## Requirements.

Python 3.9+

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import aind_tars_service_client
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import aind_tars_service_client
```

### Tests

Execute `pytest` to run the tests.

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python

import aind_tars_service_client
from aind_tars_service_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = aind_tars_service_client.Configuration(
    host = "http://localhost"
)



# Enter a context with an instance of the API client
with aind_tars_service_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = aind_tars_service_client.DefaultApi(api_client)
    name = 'AiP20611' # str | 
    page_size = 1 # int | Number of items to return in a single page. (optional) (default to 1)
    limit = 1 # int | Limit number of items returned. Set to 0 to return all. (optional) (default to 1)

    try:
        # Get Molecules
        api_response = api_instance.get_molecules(name, page_size=page_size, limit=limit)
        print("The response of DefaultApi->get_molecules:\n")
        pprint(api_response)
    except ApiException as e:
        print("Exception when calling DefaultApi->get_molecules: %s\n" % e)

```

## Documentation for API Endpoints

All URIs are relative to *http://localhost*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*DefaultApi* | [**get_molecules**](docs/DefaultApi.md#get_molecules) | **GET** /molecules/{name} | Get Molecules
*DefaultApi* | [**get_viral_prep_lots**](docs/DefaultApi.md#get_viral_prep_lots) | **GET** /viral_prep_lots/{lot} | Get Viral Prep Lots
*DefaultApi* | [**get_viruses**](docs/DefaultApi.md#get_viruses) | **GET** /viruses/{name} | Get Viruses
*HealthcheckApi* | [**get_health**](docs/HealthcheckApi.md#get_health) | **GET** /healthcheck | Perform a Health Check


## Documentation For Models

 - [Alias](docs/Alias.md)
 - [HTTPValidationError](docs/HTTPValidationError.md)
 - [HealthCheck](docs/HealthCheck.md)
 - [MoleculeData](docs/MoleculeData.md)
 - [MoleculeType](docs/MoleculeType.md)
 - [PrepLotData](docs/PrepLotData.md)
 - [Species](docs/Species.md)
 - [TargetedCellPopulation](docs/TargetedCellPopulation.md)
 - [TargetedRoi](docs/TargetedRoi.md)
 - [Titers](docs/Titers.md)
 - [ValidationError](docs/ValidationError.md)
 - [ValidationErrorLocInner](docs/ValidationErrorLocInner.md)
 - [ViralPrep](docs/ViralPrep.md)
 - [ViralPrepType](docs/ViralPrepType.md)
 - [VirusData](docs/VirusData.md)


<a id="documentation-for-authorization"></a>
## Documentation For Authorization

Endpoints do not require authorization.


## Author




