# coding: utf-8

"""
    aind-tars-service

     ## aind-tars-service  Service to pull data from TARS.  

    The version of the OpenAPI document: 0.1.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from aind_tars_service_client.models.alias import Alias
from aind_tars_service_client.models.molecule_type import MoleculeType
from aind_tars_service_client.models.species import Species
from aind_tars_service_client.models.targeted_cell_population import TargetedCellPopulation
from aind_tars_service_client.models.targeted_roi import TargetedRoi
from typing import Optional, Set
from typing_extensions import Self

class MoleculeData(BaseModel):
    """
    MoleculeData
    """ # noqa: E501
    created_at: Optional[datetime] = Field(default=None, alias="createdAt")
    updated_at: Optional[datetime] = Field(default=None, alias="updatedAt")
    created_by: Optional[StrictStr] = Field(default=None, alias="createdBy")
    updated_by: Optional[StrictStr] = Field(default=None, alias="updatedBy")
    id: Optional[StrictStr] = None
    molecule_type: Optional[MoleculeType] = Field(default=None, alias="moleculeType")
    state: Optional[Any] = None
    aliases: Optional[List[Alias]] = None
    citations: Optional[List[Any]] = None
    rr_id: Optional[Any] = Field(default=None, alias="rrId")
    full_name: Optional[StrictStr] = Field(default=None, alias="fullName")
    addgene_id: Optional[Any] = Field(default=None, alias="addgeneId")
    mgi_id: Optional[Any] = Field(default=None, alias="mgiId")
    notes: Optional[Any] = None
    sequence: Optional[StrictStr] = None
    genes: Optional[List[Any]] = None
    loci: Optional[List[Any]] = None
    species: Optional[List[Species]] = None
    organizations: Optional[List[Any]] = None
    shipments: Optional[List[Any]] = None
    material_transfer_agreements: Optional[List[Any]] = Field(default=None, alias="materialTransferAgreements")
    gen_bank_files: Optional[List[StrictStr]] = Field(default=None, alias="genBankFiles")
    map_files: Optional[List[StrictStr]] = Field(default=None, alias="mapFiles")
    fasta_files: Optional[List[StrictStr]] = Field(default=None, alias="fastaFiles")
    parents: Optional[List[Any]] = None
    children: Optional[List[Any]] = None
    patents: Optional[List[Any]] = None
    creators: Optional[List[Any]] = None
    principal_investigator: Optional[Any] = Field(default=None, alias="principalInvestigator")
    targeted_cell_populations: Optional[List[TargetedCellPopulation]] = Field(default=None, alias="targetedCellPopulations")
    validated_cell_populations: Optional[List[Any]] = Field(default=None, alias="validatedCellPopulations")
    targeted_rois: Optional[List[TargetedRoi]] = Field(default=None, alias="targetedRois")
    validated_rois: Optional[List[Any]] = Field(default=None, alias="validatedRois")
    genome_coordinates: Optional[Any] = Field(default=None, alias="genomeCoordinates")
    __properties: ClassVar[List[str]] = ["createdAt", "updatedAt", "createdBy", "updatedBy", "id", "moleculeType", "state", "aliases", "citations", "rrId", "fullName", "addgeneId", "mgiId", "notes", "sequence", "genes", "loci", "species", "organizations", "shipments", "materialTransferAgreements", "genBankFiles", "mapFiles", "fastaFiles", "parents", "children", "patents", "creators", "principalInvestigator", "targetedCellPopulations", "validatedCellPopulations", "targetedRois", "validatedRois", "genomeCoordinates"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of MoleculeData from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of molecule_type
        if self.molecule_type:
            _dict['moleculeType'] = self.molecule_type.to_dict()
        # override the default output from pydantic by calling `to_dict()` of state
        if self.state:
            _dict['state'] = self.state.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in aliases (list)
        _items = []
        if self.aliases:
            for _item_aliases in self.aliases:
                if _item_aliases:
                    _items.append(_item_aliases.to_dict())
            _dict['aliases'] = _items
        # override the default output from pydantic by calling `to_dict()` of rr_id
        if self.rr_id:
            _dict['rrId'] = self.rr_id.to_dict()
        # override the default output from pydantic by calling `to_dict()` of addgene_id
        if self.addgene_id:
            _dict['addgeneId'] = self.addgene_id.to_dict()
        # override the default output from pydantic by calling `to_dict()` of mgi_id
        if self.mgi_id:
            _dict['mgiId'] = self.mgi_id.to_dict()
        # override the default output from pydantic by calling `to_dict()` of notes
        if self.notes:
            _dict['notes'] = self.notes.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in species (list)
        _items = []
        if self.species:
            for _item_species in self.species:
                if _item_species:
                    _items.append(_item_species.to_dict())
            _dict['species'] = _items
        # override the default output from pydantic by calling `to_dict()` of principal_investigator
        if self.principal_investigator:
            _dict['principalInvestigator'] = self.principal_investigator.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in targeted_cell_populations (list)
        _items = []
        if self.targeted_cell_populations:
            for _item_targeted_cell_populations in self.targeted_cell_populations:
                if _item_targeted_cell_populations:
                    _items.append(_item_targeted_cell_populations.to_dict())
            _dict['targetedCellPopulations'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in targeted_rois (list)
        _items = []
        if self.targeted_rois:
            for _item_targeted_rois in self.targeted_rois:
                if _item_targeted_rois:
                    _items.append(_item_targeted_rois.to_dict())
            _dict['targetedRois'] = _items
        # override the default output from pydantic by calling `to_dict()` of genome_coordinates
        if self.genome_coordinates:
            _dict['genomeCoordinates'] = self.genome_coordinates.to_dict()
        # set to None if created_at (nullable) is None
        # and model_fields_set contains the field
        if self.created_at is None and "created_at" in self.model_fields_set:
            _dict['createdAt'] = None

        # set to None if updated_at (nullable) is None
        # and model_fields_set contains the field
        if self.updated_at is None and "updated_at" in self.model_fields_set:
            _dict['updatedAt'] = None

        # set to None if created_by (nullable) is None
        # and model_fields_set contains the field
        if self.created_by is None and "created_by" in self.model_fields_set:
            _dict['createdBy'] = None

        # set to None if updated_by (nullable) is None
        # and model_fields_set contains the field
        if self.updated_by is None and "updated_by" in self.model_fields_set:
            _dict['updatedBy'] = None

        # set to None if id (nullable) is None
        # and model_fields_set contains the field
        if self.id is None and "id" in self.model_fields_set:
            _dict['id'] = None

        # set to None if molecule_type (nullable) is None
        # and model_fields_set contains the field
        if self.molecule_type is None and "molecule_type" in self.model_fields_set:
            _dict['moleculeType'] = None

        # set to None if state (nullable) is None
        # and model_fields_set contains the field
        if self.state is None and "state" in self.model_fields_set:
            _dict['state'] = None

        # set to None if rr_id (nullable) is None
        # and model_fields_set contains the field
        if self.rr_id is None and "rr_id" in self.model_fields_set:
            _dict['rrId'] = None

        # set to None if full_name (nullable) is None
        # and model_fields_set contains the field
        if self.full_name is None and "full_name" in self.model_fields_set:
            _dict['fullName'] = None

        # set to None if addgene_id (nullable) is None
        # and model_fields_set contains the field
        if self.addgene_id is None and "addgene_id" in self.model_fields_set:
            _dict['addgeneId'] = None

        # set to None if mgi_id (nullable) is None
        # and model_fields_set contains the field
        if self.mgi_id is None and "mgi_id" in self.model_fields_set:
            _dict['mgiId'] = None

        # set to None if notes (nullable) is None
        # and model_fields_set contains the field
        if self.notes is None and "notes" in self.model_fields_set:
            _dict['notes'] = None

        # set to None if sequence (nullable) is None
        # and model_fields_set contains the field
        if self.sequence is None and "sequence" in self.model_fields_set:
            _dict['sequence'] = None

        # set to None if principal_investigator (nullable) is None
        # and model_fields_set contains the field
        if self.principal_investigator is None and "principal_investigator" in self.model_fields_set:
            _dict['principalInvestigator'] = None

        # set to None if genome_coordinates (nullable) is None
        # and model_fields_set contains the field
        if self.genome_coordinates is None and "genome_coordinates" in self.model_fields_set:
            _dict['genomeCoordinates'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of MoleculeData from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "createdAt": obj.get("createdAt"),
            "updatedAt": obj.get("updatedAt"),
            "createdBy": obj.get("createdBy"),
            "updatedBy": obj.get("updatedBy"),
            "id": obj.get("id"),
            "moleculeType": MoleculeType.from_dict(obj["moleculeType"]) if obj.get("moleculeType") is not None else None,
            "state": AnyOf.from_dict(obj["state"]) if obj.get("state") is not None else None,
            "aliases": [Alias.from_dict(_item) for _item in obj["aliases"]] if obj.get("aliases") is not None else None,
            "citations": obj.get("citations"),
            "rrId": AnyOf.from_dict(obj["rrId"]) if obj.get("rrId") is not None else None,
            "fullName": obj.get("fullName"),
            "addgeneId": AnyOf.from_dict(obj["addgeneId"]) if obj.get("addgeneId") is not None else None,
            "mgiId": AnyOf.from_dict(obj["mgiId"]) if obj.get("mgiId") is not None else None,
            "notes": AnyOf.from_dict(obj["notes"]) if obj.get("notes") is not None else None,
            "sequence": obj.get("sequence"),
            "genes": obj.get("genes"),
            "loci": obj.get("loci"),
            "species": [Species.from_dict(_item) for _item in obj["species"]] if obj.get("species") is not None else None,
            "organizations": obj.get("organizations"),
            "shipments": obj.get("shipments"),
            "materialTransferAgreements": obj.get("materialTransferAgreements"),
            "genBankFiles": obj.get("genBankFiles"),
            "mapFiles": obj.get("mapFiles"),
            "fastaFiles": obj.get("fastaFiles"),
            "parents": obj.get("parents"),
            "children": obj.get("children"),
            "patents": obj.get("patents"),
            "creators": obj.get("creators"),
            "principalInvestigator": AnyOf.from_dict(obj["principalInvestigator"]) if obj.get("principalInvestigator") is not None else None,
            "targetedCellPopulations": [TargetedCellPopulation.from_dict(_item) for _item in obj["targetedCellPopulations"]] if obj.get("targetedCellPopulations") is not None else None,
            "validatedCellPopulations": obj.get("validatedCellPopulations"),
            "targetedRois": [TargetedRoi.from_dict(_item) for _item in obj["targetedRois"]] if obj.get("targetedRois") is not None else None,
            "validatedRois": obj.get("validatedRois"),
            "genomeCoordinates": AnyOf.from_dict(obj["genomeCoordinates"]) if obj.get("genomeCoordinates") is not None else None
        })
        return _obj


