# coding: utf-8

"""
    aind-tars-service

     ## aind-tars-service  Service to pull data from TARS.  

    The version of the OpenAPI document: 0.1.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from aind_tars_service_client.models.titers import Titers
from aind_tars_service_client.models.viral_prep import ViralPrep
from typing import Optional, Set
from typing_extensions import Self

class PrepLotData(BaseModel):
    """
    PrepLotData
    """ # noqa: E501
    created_at: Optional[datetime] = Field(default=None, alias="createdAt")
    updated_at: Optional[datetime] = Field(default=None, alias="updatedAt")
    created_by: Optional[StrictStr] = Field(default=None, alias="createdBy")
    updated_by: Optional[StrictStr] = Field(default=None, alias="updatedBy")
    id: Optional[StrictStr] = None
    lot: Optional[StrictStr] = None
    date_prepped: Optional[datetime] = Field(default=None, alias="datePrepped")
    viral_prep: Optional[ViralPrep] = Field(default=None, alias="viralPrep")
    titers: Optional[List[Titers]] = None
    __properties: ClassVar[List[str]] = ["createdAt", "updatedAt", "createdBy", "updatedBy", "id", "lot", "datePrepped", "viralPrep", "titers"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of PrepLotData from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of viral_prep
        if self.viral_prep:
            _dict['viralPrep'] = self.viral_prep.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in titers (list)
        _items = []
        if self.titers:
            for _item_titers in self.titers:
                if _item_titers:
                    _items.append(_item_titers.to_dict())
            _dict['titers'] = _items
        # set to None if created_at (nullable) is None
        # and model_fields_set contains the field
        if self.created_at is None and "created_at" in self.model_fields_set:
            _dict['createdAt'] = None

        # set to None if updated_at (nullable) is None
        # and model_fields_set contains the field
        if self.updated_at is None and "updated_at" in self.model_fields_set:
            _dict['updatedAt'] = None

        # set to None if created_by (nullable) is None
        # and model_fields_set contains the field
        if self.created_by is None and "created_by" in self.model_fields_set:
            _dict['createdBy'] = None

        # set to None if updated_by (nullable) is None
        # and model_fields_set contains the field
        if self.updated_by is None and "updated_by" in self.model_fields_set:
            _dict['updatedBy'] = None

        # set to None if id (nullable) is None
        # and model_fields_set contains the field
        if self.id is None and "id" in self.model_fields_set:
            _dict['id'] = None

        # set to None if lot (nullable) is None
        # and model_fields_set contains the field
        if self.lot is None and "lot" in self.model_fields_set:
            _dict['lot'] = None

        # set to None if date_prepped (nullable) is None
        # and model_fields_set contains the field
        if self.date_prepped is None and "date_prepped" in self.model_fields_set:
            _dict['datePrepped'] = None

        # set to None if viral_prep (nullable) is None
        # and model_fields_set contains the field
        if self.viral_prep is None and "viral_prep" in self.model_fields_set:
            _dict['viralPrep'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of PrepLotData from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "createdAt": obj.get("createdAt"),
            "updatedAt": obj.get("updatedAt"),
            "createdBy": obj.get("createdBy"),
            "updatedBy": obj.get("updatedBy"),
            "id": obj.get("id"),
            "lot": obj.get("lot"),
            "datePrepped": obj.get("datePrepped"),
            "viralPrep": ViralPrep.from_dict(obj["viralPrep"]) if obj.get("viralPrep") is not None else None,
            "titers": [Titers.from_dict(_item) for _item in obj["titers"]] if obj.get("titers") is not None else None
        })
        return _obj


