"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CfnServer = exports.toJson_CfnServerPropsVpcConfiguration = exports.toJson_CfnServerProps = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
// Generated by cdk-import
const cdk = require("aws-cdk-lib");
/**
 * Converts an object of type 'CfnServerProps' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_CfnServerProps(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'ClusterID': obj.clusterId,
        'KubeConfig': obj.kubeConfig,
        'RoleArn': obj.roleArn,
        'Namespace': obj.namespace,
        'Name': obj.name,
        'Values': obj.values,
        'ValueYaml': obj.valueYaml,
        'Version': obj.version,
        'ValueOverrideURL': obj.valueOverrideUrl,
        'TimeOut': obj.timeOut,
        'VPCConfiguration': toJson_CfnServerPropsVpcConfiguration(obj.vpcConfiguration),
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_CfnServerProps = toJson_CfnServerProps;
/**
 * Converts an object of type 'CfnServerPropsVpcConfiguration' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_CfnServerPropsVpcConfiguration(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'SecurityGroupIds': obj.securityGroupIds?.map(y => y),
        'SubnetIds': obj.subnetIds?.map(y => y),
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_CfnServerPropsVpcConfiguration = toJson_CfnServerPropsVpcConfiguration;
/* eslint-enable max-len, quote-props */
/**
 * A CloudFormation `Aqua::Enterprise::Server`
 *
 * @cloudformationResource Aqua::Enterprise::Server
 * @stability external
 * @link https://github.com/aquasecurity/aqua-helm.git
 */
class CfnServer extends cdk.CfnResource {
    /**
     * Create a new `Aqua::Enterprise::Server`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnServer.CFN_RESOURCE_TYPE_NAME, properties: toJson_CfnServerProps(props) });
        this.props = props;
        this.attrId = cdk.Token.asString(this.getAtt('ID'));
    }
}
exports.CfnServer = CfnServer;
_a = JSII_RTTI_SYMBOL_1;
CfnServer[_a] = { fqn: "@cdk-cloudformation/aqua-enterprise-server.CfnServer", version: "1.0.0-alpha.6" };
/**
* The CloudFormation resource type name for this resource class.
*/
CfnServer.CFN_RESOURCE_TYPE_NAME = "Aqua::Enterprise::Server";
//# sourceMappingURL=data:application/json;base64,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