# coding: utf-8

"""
    FreeClimb API

    FreeClimb is a cloud-based application programming interface (API) that puts the power of the Vail platform in your hands. FreeClimb simplifies the process of creating applications that can use a full range of telephony features without requiring specialized or on-site telephony equipment. Using the FreeClimb REST API to write applications is easy! You have the option to use the language of your choice or hit the API directly. Your application can execute a command by issuing a RESTful request to the FreeClimb API. The base URL to send HTTP requests to the FreeClimb REST API is: /apiserver. FreeClimb authenticates and processes your request.  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Contact: support@freeclimb.com
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from freeclimb.api_client import ApiClient
from freeclimb.exceptions import (
    ApiTypeError,
    ApiValueError
)


class DefaultApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None, account_id=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client
        if account_id is None:
            account_id = self.api_client.configuration.username
        self.accountId = account_id


    def get_an_account(self, **kwargs):  # noqa: E501
        """Get an Account  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_an_account(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: AccountResult
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_an_account_with_http_info(**kwargs)  # noqa: E501

    def get_an_account_with_http_info(self, **kwargs):  # noqa: E501
        """Get an Account  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_an_account_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(AccountResult, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_an_account" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}
        if 'account_id' in local_var_params:
            path_params['accountId'] = local_var_params['account_id']  # noqa: E501
        path_params['accountId'] = self.accountId

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['fc']  # noqa: E501

        return self.api_client.call_api(
            '/Accounts/{accountId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AccountResult',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def buy_a_phone_number(self, **kwargs):  # noqa: E501
        """Buy a Phone Number  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.buy_a_phone_number(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param BuyIncomingNumberRequest buy_incoming_number_request: Incoming Number transaction details
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: IncomingNumberResult
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.buy_a_phone_number_with_http_info(**kwargs)  # noqa: E501

    def buy_a_phone_number_with_http_info(self, **kwargs):  # noqa: E501
        """Buy a Phone Number  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.buy_a_phone_number_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param BuyIncomingNumberRequest buy_incoming_number_request: Incoming Number transaction details
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(IncomingNumberResult, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['buy_incoming_number_request']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method buy_a_phone_number" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}
        if 'account_id' in local_var_params:
            path_params['accountId'] = local_var_params['account_id']  # noqa: E501
        path_params['accountId'] = self.accountId

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'buy_incoming_number_request' in local_var_params:
            body_params = local_var_params['buy_incoming_number_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['fc']  # noqa: E501

        return self.api_client.call_api(
            '/Accounts/{accountId}/IncomingPhoneNumbers', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='IncomingNumberResult',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_a_conference(self, **kwargs):  # noqa: E501
        """Create a Conference  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_a_conference(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param CreateConferenceRequest create_conference_request: Conference to create
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ConferenceResult
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.create_a_conference_with_http_info(**kwargs)  # noqa: E501

    def create_a_conference_with_http_info(self, **kwargs):  # noqa: E501
        """Create a Conference  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_a_conference_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param CreateConferenceRequest create_conference_request: Conference to create
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ConferenceResult, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['create_conference_request']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_a_conference" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}
        if 'account_id' in local_var_params:
            path_params['accountId'] = local_var_params['account_id']  # noqa: E501
        path_params['accountId'] = self.accountId

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'create_conference_request' in local_var_params:
            body_params = local_var_params['create_conference_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['fc']  # noqa: E501

        return self.api_client.call_api(
            '/Accounts/{accountId}/Conferences', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ConferenceResult',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_a_queue(self, **kwargs):  # noqa: E501
        """Create a Queue  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_a_queue(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param QueueRequest queue_request: Queue details used to create a queue
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: QueueResult
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.create_a_queue_with_http_info(**kwargs)  # noqa: E501

    def create_a_queue_with_http_info(self, **kwargs):  # noqa: E501
        """Create a Queue  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_a_queue_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param QueueRequest queue_request: Queue details used to create a queue
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(QueueResult, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['queue_request']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_a_queue" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}
        if 'account_id' in local_var_params:
            path_params['accountId'] = local_var_params['account_id']  # noqa: E501
        path_params['accountId'] = self.accountId

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'queue_request' in local_var_params:
            body_params = local_var_params['queue_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['fc']  # noqa: E501

        return self.api_client.call_api(
            '/Accounts/{accountId}/Queues', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='QueueResult',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_an_application(self, **kwargs):  # noqa: E501
        """Create an application  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_an_application(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param ApplicationRequest application_request: Application Details
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ApplicationResult
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.create_an_application_with_http_info(**kwargs)  # noqa: E501

    def create_an_application_with_http_info(self, **kwargs):  # noqa: E501
        """Create an application  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_an_application_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param ApplicationRequest application_request: Application Details
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ApplicationResult, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['application_request']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_an_application" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}
        if 'account_id' in local_var_params:
            path_params['accountId'] = local_var_params['account_id']  # noqa: E501
        path_params['accountId'] = self.accountId

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'application_request' in local_var_params:
            body_params = local_var_params['application_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['fc']  # noqa: E501

        return self.api_client.call_api(
            '/Accounts/{accountId}/Applications', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApplicationResult',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_a_recording(self, recording_id, **kwargs):  # noqa: E501
        """Delete a Recording  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_a_recording(recording_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str recording_id: String that uniquely identifies this recording resource. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_a_recording_with_http_info(recording_id, **kwargs)  # noqa: E501

    def delete_a_recording_with_http_info(self, recording_id, **kwargs):  # noqa: E501
        """Delete a Recording  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_a_recording_with_http_info(recording_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str recording_id: String that uniquely identifies this recording resource. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['recording_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_a_recording" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'recording_id' is set
        if self.api_client.client_side_validation and ('recording_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['recording_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `recording_id` when calling `delete_a_recording`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'account_id' in local_var_params:
            path_params['accountId'] = local_var_params['account_id']  # noqa: E501
        if 'recording_id' in local_var_params:
            path_params['recordingId'] = local_var_params['recording_id']  # noqa: E501
        path_params['accountId'] = self.accountId

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['fc']  # noqa: E501

        return self.api_client.call_api(
            '/Accounts/{accountId}/Recordings/{recordingId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_an_application(self, application_id, **kwargs):  # noqa: E501
        """Delete an application  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_an_application(application_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str application_id: String that uniquely identifies this application resource. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_an_application_with_http_info(application_id, **kwargs)  # noqa: E501

    def delete_an_application_with_http_info(self, application_id, **kwargs):  # noqa: E501
        """Delete an application  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_an_application_with_http_info(application_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str application_id: String that uniquely identifies this application resource. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['application_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_an_application" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'application_id' is set
        if self.api_client.client_side_validation and ('application_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['application_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `application_id` when calling `delete_an_application`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'account_id' in local_var_params:
            path_params['accountId'] = local_var_params['account_id']  # noqa: E501
        if 'application_id' in local_var_params:
            path_params['applicationId'] = local_var_params['application_id']  # noqa: E501
        path_params['accountId'] = self.accountId

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['fc']  # noqa: E501

        return self.api_client.call_api(
            '/Accounts/{accountId}/Applications/{applicationId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_an_incoming_number(self, phone_number_id, **kwargs):  # noqa: E501
        """Delete an Incoming Number  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_an_incoming_number(phone_number_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str phone_number_id: String that uniquely identifies this phone number resource. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_an_incoming_number_with_http_info(phone_number_id, **kwargs)  # noqa: E501

    def delete_an_incoming_number_with_http_info(self, phone_number_id, **kwargs):  # noqa: E501
        """Delete an Incoming Number  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_an_incoming_number_with_http_info(phone_number_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str phone_number_id: String that uniquely identifies this phone number resource. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['phone_number_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_an_incoming_number" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'phone_number_id' is set
        if self.api_client.client_side_validation and ('phone_number_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['phone_number_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `phone_number_id` when calling `delete_an_incoming_number`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'account_id' in local_var_params:
            path_params['accountId'] = local_var_params['account_id']  # noqa: E501
        if 'phone_number_id' in local_var_params:
            path_params['phoneNumberId'] = local_var_params['phone_number_id']  # noqa: E501
        path_params['accountId'] = self.accountId

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['fc']  # noqa: E501

        return self.api_client.call_api(
            '/Accounts/{accountId}/IncomingPhoneNumbers/{phoneNumberId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def dequeue_a_member(self, queue_id, call_id, **kwargs):  # noqa: E501
        """Dequeue a Member  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.dequeue_a_member(queue_id, call_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str queue_id: String that uniquely identifies the Queue that the Member belongs to. (required)
        :param str call_id: ID if the Call that the Member belongs to (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: QueueMember
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.dequeue_a_member_with_http_info(queue_id, call_id, **kwargs)  # noqa: E501

    def dequeue_a_member_with_http_info(self, queue_id, call_id, **kwargs):  # noqa: E501
        """Dequeue a Member  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.dequeue_a_member_with_http_info(queue_id, call_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str queue_id: String that uniquely identifies the Queue that the Member belongs to. (required)
        :param str call_id: ID if the Call that the Member belongs to (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(QueueMember, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['queue_id', 'call_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method dequeue_a_member" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'queue_id' is set
        if self.api_client.client_side_validation and ('queue_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['queue_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `queue_id` when calling `dequeue_a_member`")  # noqa: E501
        # verify the required parameter 'call_id' is set
        if self.api_client.client_side_validation and ('call_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['call_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `call_id` when calling `dequeue_a_member`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'account_id' in local_var_params:
            path_params['accountId'] = local_var_params['account_id']  # noqa: E501
        if 'queue_id' in local_var_params:
            path_params['queueId'] = local_var_params['queue_id']  # noqa: E501
        if 'call_id' in local_var_params:
            path_params['callId'] = local_var_params['call_id']  # noqa: E501
        path_params['accountId'] = self.accountId

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['fc']  # noqa: E501

        return self.api_client.call_api(
            '/Accounts/{accountId}/Queues/{queueId}/Members/{callId}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='QueueMember',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def dequeue_head_member(self, queue_id, **kwargs):  # noqa: E501
        """Dequeue Head Member  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.dequeue_head_member(queue_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str queue_id: String that uniquely identifies this queue resource. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: QueueMember
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.dequeue_head_member_with_http_info(queue_id, **kwargs)  # noqa: E501

    def dequeue_head_member_with_http_info(self, queue_id, **kwargs):  # noqa: E501
        """Dequeue Head Member  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.dequeue_head_member_with_http_info(queue_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str queue_id: String that uniquely identifies this queue resource. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(QueueMember, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['queue_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method dequeue_head_member" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'queue_id' is set
        if self.api_client.client_side_validation and ('queue_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['queue_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `queue_id` when calling `dequeue_head_member`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'account_id' in local_var_params:
            path_params['accountId'] = local_var_params['account_id']  # noqa: E501
        if 'queue_id' in local_var_params:
            path_params['queueId'] = local_var_params['queue_id']  # noqa: E501
        path_params['accountId'] = self.accountId

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['fc']  # noqa: E501

        return self.api_client.call_api(
            '/Accounts/{accountId}/Queues/{queueId}/Members/Front', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='QueueMember',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def download_a_recording_file(self, recording_id, **kwargs):  # noqa: E501
        """Download a Recording File  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.download_a_recording_file(recording_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str recording_id: String that uniquely identifies this recording resource. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.download_a_recording_file_with_http_info(recording_id, **kwargs)  # noqa: E501

    def download_a_recording_file_with_http_info(self, recording_id, **kwargs):  # noqa: E501
        """Download a Recording File  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.download_a_recording_file_with_http_info(recording_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str recording_id: String that uniquely identifies this recording resource. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(file, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['recording_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method download_a_recording_file" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'recording_id' is set
        if self.api_client.client_side_validation and ('recording_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['recording_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `recording_id` when calling `download_a_recording_file`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'account_id' in local_var_params:
            path_params['accountId'] = local_var_params['account_id']  # noqa: E501
        if 'recording_id' in local_var_params:
            path_params['recordingId'] = local_var_params['recording_id']  # noqa: E501
        path_params['accountId'] = self.accountId

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['audio/x-wav'])  # noqa: E501

        # Authentication setting
        auth_settings = ['fc']  # noqa: E501

        return self.api_client.call_api(
            '/Accounts/{accountId}/Recordings/{recordingId}/Download', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='file',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def filter_logs(self, **kwargs):  # noqa: E501
        """Filter Logs  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.filter_logs(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param FilterLogsRequest filter_logs_request: Filter logs request paramters
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: LogList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.filter_logs_with_http_info(**kwargs)  # noqa: E501

    def filter_logs_with_http_info(self, **kwargs):  # noqa: E501
        """Filter Logs  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.filter_logs_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param FilterLogsRequest filter_logs_request: Filter logs request paramters
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(LogList, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['filter_logs_request']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method filter_logs" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}
        if 'account_id' in local_var_params:
            path_params['accountId'] = local_var_params['account_id']  # noqa: E501
        path_params['accountId'] = self.accountId

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'filter_logs_request' in local_var_params:
            body_params = local_var_params['filter_logs_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['fc']  # noqa: E501

        return self.api_client.call_api(
            '/Accounts/{accountId}/Logs', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='LogList',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_a_call(self, call_id, **kwargs):  # noqa: E501
        """Get a Call  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_a_call(call_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str call_id: String that uniquely identifies this call resource. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: CallResult
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_a_call_with_http_info(call_id, **kwargs)  # noqa: E501

    def get_a_call_with_http_info(self, call_id, **kwargs):  # noqa: E501
        """Get a Call  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_a_call_with_http_info(call_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str call_id: String that uniquely identifies this call resource. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(CallResult, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['call_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_a_call" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'call_id' is set
        if self.api_client.client_side_validation and ('call_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['call_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `call_id` when calling `get_a_call`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'account_id' in local_var_params:
            path_params['accountId'] = local_var_params['account_id']  # noqa: E501
        if 'call_id' in local_var_params:
            path_params['callId'] = local_var_params['call_id']  # noqa: E501
        path_params['accountId'] = self.accountId

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['fc']  # noqa: E501

        return self.api_client.call_api(
            '/Accounts/{accountId}/Calls/{callId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CallResult',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_a_conference(self, conference_id, **kwargs):  # noqa: E501
        """Get a Conference  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_a_conference(conference_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str conference_id: A string that uniquely identifies this conference resource. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ConferenceResult
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_a_conference_with_http_info(conference_id, **kwargs)  # noqa: E501

    def get_a_conference_with_http_info(self, conference_id, **kwargs):  # noqa: E501
        """Get a Conference  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_a_conference_with_http_info(conference_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str conference_id: A string that uniquely identifies this conference resource. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ConferenceResult, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['conference_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_a_conference" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'conference_id' is set
        if self.api_client.client_side_validation and ('conference_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['conference_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `conference_id` when calling `get_a_conference`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'account_id' in local_var_params:
            path_params['accountId'] = local_var_params['account_id']  # noqa: E501
        if 'conference_id' in local_var_params:
            path_params['conferenceId'] = local_var_params['conference_id']  # noqa: E501
        path_params['accountId'] = self.accountId

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['fc']  # noqa: E501

        return self.api_client.call_api(
            '/Accounts/{accountId}/Conferences/{conferenceId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ConferenceResult',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_a_member(self, queue_id, call_id, **kwargs):  # noqa: E501
        """Get a Member  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_a_member(queue_id, call_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str queue_id: String that uniquely identifies the Queue that the Member belongs to. (required)
        :param str call_id: ID of the Call that the Member belongs to (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: QueueMember
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_a_member_with_http_info(queue_id, call_id, **kwargs)  # noqa: E501

    def get_a_member_with_http_info(self, queue_id, call_id, **kwargs):  # noqa: E501
        """Get a Member  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_a_member_with_http_info(queue_id, call_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str queue_id: String that uniquely identifies the Queue that the Member belongs to. (required)
        :param str call_id: ID of the Call that the Member belongs to (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(QueueMember, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['queue_id', 'call_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_a_member" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'queue_id' is set
        if self.api_client.client_side_validation and ('queue_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['queue_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `queue_id` when calling `get_a_member`")  # noqa: E501
        # verify the required parameter 'call_id' is set
        if self.api_client.client_side_validation and ('call_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['call_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `call_id` when calling `get_a_member`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'account_id' in local_var_params:
            path_params['accountId'] = local_var_params['account_id']  # noqa: E501
        if 'queue_id' in local_var_params:
            path_params['queueId'] = local_var_params['queue_id']  # noqa: E501
        if 'call_id' in local_var_params:
            path_params['callId'] = local_var_params['call_id']  # noqa: E501
        path_params['accountId'] = self.accountId

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['fc']  # noqa: E501

        return self.api_client.call_api(
            '/Accounts/{accountId}/Queues/{queueId}/Members/{callId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='QueueMember',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_a_participant(self, conference_id, call_id, **kwargs):  # noqa: E501
        """Get a Participant  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_a_participant(conference_id, call_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str conference_id: ID of the conference this participant is in. (required)
        :param str call_id: ID of the Call associated with this participant. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ConferenceParticipantResult
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_a_participant_with_http_info(conference_id, call_id, **kwargs)  # noqa: E501

    def get_a_participant_with_http_info(self, conference_id, call_id, **kwargs):  # noqa: E501
        """Get a Participant  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_a_participant_with_http_info(conference_id, call_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str conference_id: ID of the conference this participant is in. (required)
        :param str call_id: ID of the Call associated with this participant. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ConferenceParticipantResult, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['conference_id', 'call_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_a_participant" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'conference_id' is set
        if self.api_client.client_side_validation and ('conference_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['conference_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `conference_id` when calling `get_a_participant`")  # noqa: E501
        # verify the required parameter 'call_id' is set
        if self.api_client.client_side_validation and ('call_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['call_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `call_id` when calling `get_a_participant`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'account_id' in local_var_params:
            path_params['accountId'] = local_var_params['account_id']  # noqa: E501
        if 'conference_id' in local_var_params:
            path_params['conferenceId'] = local_var_params['conference_id']  # noqa: E501
        if 'call_id' in local_var_params:
            path_params['callId'] = local_var_params['call_id']  # noqa: E501
        path_params['accountId'] = self.accountId

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['fc']  # noqa: E501

        return self.api_client.call_api(
            '/Accounts/{accountId}/Conferences/{conferenceId}/Participants/{callId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ConferenceParticipantResult',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_a_queue(self, queue_id, **kwargs):  # noqa: E501
        """Get a Queue  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_a_queue(queue_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str queue_id: A string that uniquely identifies this queue resource. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: QueueResult
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_a_queue_with_http_info(queue_id, **kwargs)  # noqa: E501

    def get_a_queue_with_http_info(self, queue_id, **kwargs):  # noqa: E501
        """Get a Queue  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_a_queue_with_http_info(queue_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str queue_id: A string that uniquely identifies this queue resource. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(QueueResult, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['queue_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_a_queue" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'queue_id' is set
        if self.api_client.client_side_validation and ('queue_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['queue_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `queue_id` when calling `get_a_queue`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'account_id' in local_var_params:
            path_params['accountId'] = local_var_params['account_id']  # noqa: E501
        if 'queue_id' in local_var_params:
            path_params['queueId'] = local_var_params['queue_id']  # noqa: E501
        path_params['accountId'] = self.accountId

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['fc']  # noqa: E501

        return self.api_client.call_api(
            '/Accounts/{accountId}/Queues/{queueId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='QueueResult',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_a_recording(self, recording_id, **kwargs):  # noqa: E501
        """Get a Recording  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_a_recording(recording_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str recording_id: String that uniquely identifies this recording resource. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: RecordingResult
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_a_recording_with_http_info(recording_id, **kwargs)  # noqa: E501

    def get_a_recording_with_http_info(self, recording_id, **kwargs):  # noqa: E501
        """Get a Recording  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_a_recording_with_http_info(recording_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str recording_id: String that uniquely identifies this recording resource. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(RecordingResult, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['recording_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_a_recording" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'recording_id' is set
        if self.api_client.client_side_validation and ('recording_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['recording_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `recording_id` when calling `get_a_recording`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'account_id' in local_var_params:
            path_params['accountId'] = local_var_params['account_id']  # noqa: E501
        if 'recording_id' in local_var_params:
            path_params['recordingId'] = local_var_params['recording_id']  # noqa: E501
        path_params['accountId'] = self.accountId

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['fc']  # noqa: E501

        return self.api_client.call_api(
            '/Accounts/{accountId}/Recordings/{recordingId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RecordingResult',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_an_application(self, application_id, **kwargs):  # noqa: E501
        """Get an Application  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_an_application(application_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str application_id: A string that uniquely identifies this application resource. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ApplicationResult
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_an_application_with_http_info(application_id, **kwargs)  # noqa: E501

    def get_an_application_with_http_info(self, application_id, **kwargs):  # noqa: E501
        """Get an Application  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_an_application_with_http_info(application_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str application_id: A string that uniquely identifies this application resource. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ApplicationResult, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['application_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_an_application" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'application_id' is set
        if self.api_client.client_side_validation and ('application_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['application_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `application_id` when calling `get_an_application`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'account_id' in local_var_params:
            path_params['accountId'] = local_var_params['account_id']  # noqa: E501
        if 'application_id' in local_var_params:
            path_params['applicationId'] = local_var_params['application_id']  # noqa: E501
        path_params['accountId'] = self.accountId

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['fc']  # noqa: E501

        return self.api_client.call_api(
            '/Accounts/{accountId}/Applications/{applicationId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApplicationResult',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_an_incoming_number(self, phone_number_id, **kwargs):  # noqa: E501
        """Get an Incoming Number  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_an_incoming_number(phone_number_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str phone_number_id: String that uniquely identifies this phone number resource. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: IncomingNumberResult
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_an_incoming_number_with_http_info(phone_number_id, **kwargs)  # noqa: E501

    def get_an_incoming_number_with_http_info(self, phone_number_id, **kwargs):  # noqa: E501
        """Get an Incoming Number  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_an_incoming_number_with_http_info(phone_number_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str phone_number_id: String that uniquely identifies this phone number resource. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(IncomingNumberResult, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['phone_number_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_an_incoming_number" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'phone_number_id' is set
        if self.api_client.client_side_validation and ('phone_number_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['phone_number_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `phone_number_id` when calling `get_an_incoming_number`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'account_id' in local_var_params:
            path_params['accountId'] = local_var_params['account_id']  # noqa: E501
        if 'phone_number_id' in local_var_params:
            path_params['phoneNumberId'] = local_var_params['phone_number_id']  # noqa: E501
        path_params['accountId'] = self.accountId

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['fc']  # noqa: E501

        return self.api_client.call_api(
            '/Accounts/{accountId}/IncomingPhoneNumbers/{phoneNumberId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='IncomingNumberResult',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_an_sms_message(self, message_id, **kwargs):  # noqa: E501
        """Get an SMS Message  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_an_sms_message(message_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str message_id: String that uniquely identifies this Message resource. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: MessageResult
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_an_sms_message_with_http_info(message_id, **kwargs)  # noqa: E501

    def get_an_sms_message_with_http_info(self, message_id, **kwargs):  # noqa: E501
        """Get an SMS Message  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_an_sms_message_with_http_info(message_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str message_id: String that uniquely identifies this Message resource. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(MessageResult, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['message_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_an_sms_message" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'message_id' is set
        if self.api_client.client_side_validation and ('message_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['message_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `message_id` when calling `get_an_sms_message`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'account_id' in local_var_params:
            path_params['accountId'] = local_var_params['account_id']  # noqa: E501
        if 'message_id' in local_var_params:
            path_params['messageId'] = local_var_params['message_id']  # noqa: E501
        path_params['accountId'] = self.accountId

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['fc']  # noqa: E501

        return self.api_client.call_api(
            '/Accounts/{accountId}/Messages/{messageId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='MessageResult',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_head_member(self, queue_id, **kwargs):  # noqa: E501
        """Get Head Member  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_head_member(queue_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str queue_id: String that uniquely identifies the Queue that the Member belongs to. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: QueueMember
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_head_member_with_http_info(queue_id, **kwargs)  # noqa: E501

    def get_head_member_with_http_info(self, queue_id, **kwargs):  # noqa: E501
        """Get Head Member  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_head_member_with_http_info(queue_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str queue_id: String that uniquely identifies the Queue that the Member belongs to. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(QueueMember, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['queue_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_head_member" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'queue_id' is set
        if self.api_client.client_side_validation and ('queue_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['queue_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `queue_id` when calling `get_head_member`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'account_id' in local_var_params:
            path_params['accountId'] = local_var_params['account_id']  # noqa: E501
        if 'queue_id' in local_var_params:
            path_params['queueId'] = local_var_params['queue_id']  # noqa: E501
        path_params['accountId'] = self.accountId

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['fc']  # noqa: E501

        return self.api_client.call_api(
            '/Accounts/{accountId}/Queues/{queueId}/Members/Front', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='QueueMember',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_active_queues(self, **kwargs):  # noqa: E501
        """List Active Queues  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_active_queues(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str alias: Return only the Queue resources with aliases that exactly match this name.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: QueueList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.list_active_queues_with_http_info(**kwargs)  # noqa: E501

    def list_active_queues_with_http_info(self, **kwargs):  # noqa: E501
        """List Active Queues  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_active_queues_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str alias: Return only the Queue resources with aliases that exactly match this name.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(QueueList, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['alias']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_active_queues" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}
        if 'account_id' in local_var_params:
            path_params['accountId'] = local_var_params['account_id']  # noqa: E501
        path_params['accountId'] = self.accountId

        query_params = []
        if 'alias' in local_var_params and local_var_params['alias'] is not None:  # noqa: E501
            query_params.append(('alias', local_var_params['alias']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['fc']  # noqa: E501

        return self.api_client.call_api(
            '/Accounts/{accountId}/Queues', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='QueueList',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_all_account_logs(self, **kwargs):  # noqa: E501
        """List All Account Logs  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_all_account_logs(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: LogList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.list_all_account_logs_with_http_info(**kwargs)  # noqa: E501

    def list_all_account_logs_with_http_info(self, **kwargs):  # noqa: E501
        """List All Account Logs  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_all_account_logs_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(LogList, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_all_account_logs" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}
        if 'account_id' in local_var_params:
            path_params['accountId'] = local_var_params['account_id']  # noqa: E501
        path_params['accountId'] = self.accountId

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['fc']  # noqa: E501

        return self.api_client.call_api(
            '/Accounts/{accountId}/Logs', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='LogList',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_an_application(self, **kwargs):  # noqa: E501
        """List applications  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_an_application(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str alias: Return only applications with aliases that exactly match this value.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ApplicationList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.list_an_application_with_http_info(**kwargs)  # noqa: E501

    def list_an_application_with_http_info(self, **kwargs):  # noqa: E501
        """List applications  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_an_application_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str alias: Return only applications with aliases that exactly match this value.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ApplicationList, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['alias']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_an_application" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}
        if 'account_id' in local_var_params:
            path_params['accountId'] = local_var_params['account_id']  # noqa: E501
        path_params['accountId'] = self.accountId

        query_params = []
        if 'alias' in local_var_params and local_var_params['alias'] is not None:  # noqa: E501
            query_params.append(('alias', local_var_params['alias']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['fc']  # noqa: E501

        return self.api_client.call_api(
            '/Accounts/{accountId}/Applications', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApplicationList',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_available_numbers(self, **kwargs):  # noqa: E501
        """List available numbers  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_available_numbers(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str alias: Filter on numbers based on the formatted string of the phone number.
        :param str phone_number: PCRE-compatible regular expression to filter against `phoneNumber` field, which is in E.164 format.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: AvailableNumberList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.list_available_numbers_with_http_info(**kwargs)  # noqa: E501

    def list_available_numbers_with_http_info(self, **kwargs):  # noqa: E501
        """List available numbers  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_available_numbers_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str alias: Filter on numbers based on the formatted string of the phone number.
        :param str phone_number: PCRE-compatible regular expression to filter against `phoneNumber` field, which is in E.164 format.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(AvailableNumberList, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['alias', 'phone_number']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_available_numbers" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}
        path_params['accountId'] = self.accountId

        query_params = []
        if 'alias' in local_var_params and local_var_params['alias'] is not None:  # noqa: E501
            query_params.append(('alias', local_var_params['alias']))  # noqa: E501
        if 'phone_number' in local_var_params and local_var_params['phone_number'] is not None:  # noqa: E501
            query_params.append(('phoneNumber', local_var_params['phone_number']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['fc']  # noqa: E501

        return self.api_client.call_api(
            '/AvailablePhoneNumbers', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AvailableNumberList',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_call_logs(self, call_id, **kwargs):  # noqa: E501
        """List Call Logs  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_call_logs(call_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str call_id: String that uniquely identifies this call resource. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: LogList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.list_call_logs_with_http_info(call_id, **kwargs)  # noqa: E501

    def list_call_logs_with_http_info(self, call_id, **kwargs):  # noqa: E501
        """List Call Logs  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_call_logs_with_http_info(call_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str call_id: String that uniquely identifies this call resource. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(LogList, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['call_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_call_logs" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'call_id' is set
        if self.api_client.client_side_validation and ('call_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['call_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `call_id` when calling `list_call_logs`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'account_id' in local_var_params:
            path_params['accountId'] = local_var_params['account_id']  # noqa: E501
        if 'call_id' in local_var_params:
            path_params['callId'] = local_var_params['call_id']  # noqa: E501
        path_params['accountId'] = self.accountId

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['fc']  # noqa: E501

        return self.api_client.call_api(
            '/Accounts/{accountId}/Calls/{callId}/Logs', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='LogList',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_call_recordings(self, call_id, **kwargs):  # noqa: E501
        """List Call Recordings  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_call_recordings(call_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str call_id: String that uniquely identifies this call resource. (required)
        :param str date_created: Only show recordings created on the specified date, in the form *YYYY-MM-DD*.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: RecordingList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.list_call_recordings_with_http_info(call_id, **kwargs)  # noqa: E501

    def list_call_recordings_with_http_info(self, call_id, **kwargs):  # noqa: E501
        """List Call Recordings  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_call_recordings_with_http_info(call_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str call_id: String that uniquely identifies this call resource. (required)
        :param str date_created: Only show recordings created on the specified date, in the form *YYYY-MM-DD*.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(RecordingList, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['call_id', 'date_created']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_call_recordings" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'call_id' is set
        if self.api_client.client_side_validation and ('call_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['call_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `call_id` when calling `list_call_recordings`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'account_id' in local_var_params:
            path_params['accountId'] = local_var_params['account_id']  # noqa: E501
        if 'call_id' in local_var_params:
            path_params['callId'] = local_var_params['call_id']  # noqa: E501
        path_params['accountId'] = self.accountId

        query_params = []
        if 'date_created' in local_var_params and local_var_params['date_created'] is not None:  # noqa: E501
            query_params.append(('dateCreated', local_var_params['date_created']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['fc']  # noqa: E501

        return self.api_client.call_api(
            '/Accounts/{accountId}/Calls/{callId}/Recordings', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RecordingList',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_calls(self, **kwargs):  # noqa: E501
        """List Calls  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_calls(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str to: Only show Calls to this phone number.
        :param str _from: Only show Calls from this phone number.
        :param str status: Only show Calls currently in this status. May be `queued`, `ringing`, `inProgress`, `canceled`, `completed`, `failed`, `busy`, or `noAnswer`.
        :param str start_time: Only show Calls that started at or after this time, given as YYYY-MM-DD hh:mm:ss.
        :param str end_time: Only show Calls that ended at or before this time, given as YYYY-MM- DD hh:mm:ss.
        :param str parent_call_id: Only show Calls spawned by the call with this ID.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: CallList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.list_calls_with_http_info(**kwargs)  # noqa: E501

    def list_calls_with_http_info(self, **kwargs):  # noqa: E501
        """List Calls  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_calls_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str to: Only show Calls to this phone number.
        :param str _from: Only show Calls from this phone number.
        :param str status: Only show Calls currently in this status. May be `queued`, `ringing`, `inProgress`, `canceled`, `completed`, `failed`, `busy`, or `noAnswer`.
        :param str start_time: Only show Calls that started at or after this time, given as YYYY-MM-DD hh:mm:ss.
        :param str end_time: Only show Calls that ended at or before this time, given as YYYY-MM- DD hh:mm:ss.
        :param str parent_call_id: Only show Calls spawned by the call with this ID.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(CallList, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['to', '_from', 'status', 'start_time', 'end_time', 'parent_call_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_calls" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}
        if 'account_id' in local_var_params:
            path_params['accountId'] = local_var_params['account_id']  # noqa: E501
        path_params['accountId'] = self.accountId

        query_params = []
        if 'to' in local_var_params and local_var_params['to'] is not None:  # noqa: E501
            query_params.append(('to', local_var_params['to']))  # noqa: E501
        if '_from' in local_var_params and local_var_params['_from'] is not None:  # noqa: E501
            query_params.append(('from', local_var_params['_from']))  # noqa: E501
        if 'status' in local_var_params and local_var_params['status'] is not None:  # noqa: E501
            query_params.append(('status', local_var_params['status']))  # noqa: E501
        if 'start_time' in local_var_params and local_var_params['start_time'] is not None:  # noqa: E501
            query_params.append(('startTime', local_var_params['start_time']))  # noqa: E501
        if 'end_time' in local_var_params and local_var_params['end_time'] is not None:  # noqa: E501
            query_params.append(('endTime', local_var_params['end_time']))  # noqa: E501
        if 'parent_call_id' in local_var_params and local_var_params['parent_call_id'] is not None:  # noqa: E501
            query_params.append(('parentCallId', local_var_params['parent_call_id']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['fc']  # noqa: E501

        return self.api_client.call_api(
            '/Accounts/{accountId}/Calls', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CallList',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_conferences(self, **kwargs):  # noqa: E501
        """List Conferences  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_conferences(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str status: Only show conferences that currently have the specified status. Valid values: `empty`, `populated`, `inProgress`, or `terminated`.
        :param str alias: List Conferences whose alias exactly matches this string.
        :param str date_created: Only show Conferences that were created on the specified date, in the form *YYYY-MM-DD*.
        :param str date_updated: Only show Conferences that were last updated on the specified date, in the form *YYYY-MM-DD*.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ConferenceList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.list_conferences_with_http_info(**kwargs)  # noqa: E501

    def list_conferences_with_http_info(self, **kwargs):  # noqa: E501
        """List Conferences  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_conferences_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str status: Only show conferences that currently have the specified status. Valid values: `empty`, `populated`, `inProgress`, or `terminated`.
        :param str alias: List Conferences whose alias exactly matches this string.
        :param str date_created: Only show Conferences that were created on the specified date, in the form *YYYY-MM-DD*.
        :param str date_updated: Only show Conferences that were last updated on the specified date, in the form *YYYY-MM-DD*.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ConferenceList, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['status', 'alias', 'date_created', 'date_updated']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_conferences" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}
        if 'account_id' in local_var_params:
            path_params['accountId'] = local_var_params['account_id']  # noqa: E501
        path_params['accountId'] = self.accountId

        query_params = []
        if 'status' in local_var_params and local_var_params['status'] is not None:  # noqa: E501
            query_params.append(('status', local_var_params['status']))  # noqa: E501
        if 'alias' in local_var_params and local_var_params['alias'] is not None:  # noqa: E501
            query_params.append(('alias', local_var_params['alias']))  # noqa: E501
        if 'date_created' in local_var_params and local_var_params['date_created'] is not None:  # noqa: E501
            query_params.append(('dateCreated', local_var_params['date_created']))  # noqa: E501
        if 'date_updated' in local_var_params and local_var_params['date_updated'] is not None:  # noqa: E501
            query_params.append(('dateUpdated', local_var_params['date_updated']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['fc']  # noqa: E501

        return self.api_client.call_api(
            '/Accounts/{accountId}/Conferences', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ConferenceList',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_incoming_numbers(self, **kwargs):  # noqa: E501
        """List Incoming Numbers  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_incoming_numbers(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str phone_number: Only show incoming phone number resources that match this PCRE-compatible regular expression.
        :param str alias: Only show incoming phone numbers with aliases that exactly match this value.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: IncomingNumberList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.list_incoming_numbers_with_http_info(**kwargs)  # noqa: E501

    def list_incoming_numbers_with_http_info(self, **kwargs):  # noqa: E501
        """List Incoming Numbers  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_incoming_numbers_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str phone_number: Only show incoming phone number resources that match this PCRE-compatible regular expression.
        :param str alias: Only show incoming phone numbers with aliases that exactly match this value.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(IncomingNumberList, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['phone_number', 'alias']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_incoming_numbers" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}
        if 'account_id' in local_var_params:
            path_params['accountId'] = local_var_params['account_id']  # noqa: E501
        path_params['accountId'] = self.accountId

        query_params = []
        if 'phone_number' in local_var_params and local_var_params['phone_number'] is not None:  # noqa: E501
            query_params.append(('phoneNumber', local_var_params['phone_number']))  # noqa: E501
        if 'alias' in local_var_params and local_var_params['alias'] is not None:  # noqa: E501
            query_params.append(('alias', local_var_params['alias']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['fc']  # noqa: E501

        return self.api_client.call_api(
            '/Accounts/{accountId}/IncomingPhoneNumbers', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='IncomingNumberList',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_members(self, queue_id, **kwargs):  # noqa: E501
        """List Members  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_members(queue_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str queue_id: String that uniquely identifies the Queue that the Member belongs to. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: QueueMemberList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.list_members_with_http_info(queue_id, **kwargs)  # noqa: E501

    def list_members_with_http_info(self, queue_id, **kwargs):  # noqa: E501
        """List Members  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_members_with_http_info(queue_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str queue_id: String that uniquely identifies the Queue that the Member belongs to. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(QueueMemberList, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['queue_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_members" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'queue_id' is set
        if self.api_client.client_side_validation and ('queue_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['queue_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `queue_id` when calling `list_members`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'account_id' in local_var_params:
            path_params['accountId'] = local_var_params['account_id']  # noqa: E501
        if 'queue_id' in local_var_params:
            path_params['queueId'] = local_var_params['queue_id']  # noqa: E501
        path_params['accountId'] = self.accountId

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['fc']  # noqa: E501

        return self.api_client.call_api(
            '/Accounts/{accountId}/Queues/{queueId}/Members', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='QueueMemberList',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_participants(self, conference_id, **kwargs):  # noqa: E501
        """List Participants  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_participants(conference_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str conference_id: ID of the conference this participant is in. (required)
        :param bool talk: Only show Participants with the talk privilege.
        :param bool listen: Only show Participants with the listen privilege.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ConferenceParticipantList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.list_participants_with_http_info(conference_id, **kwargs)  # noqa: E501

    def list_participants_with_http_info(self, conference_id, **kwargs):  # noqa: E501
        """List Participants  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_participants_with_http_info(conference_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str conference_id: ID of the conference this participant is in. (required)
        :param bool talk: Only show Participants with the talk privilege.
        :param bool listen: Only show Participants with the listen privilege.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ConferenceParticipantList, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['conference_id', 'talk', 'listen']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_participants" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'conference_id' is set
        if self.api_client.client_side_validation and ('conference_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['conference_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `conference_id` when calling `list_participants`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'account_id' in local_var_params:
            path_params['accountId'] = local_var_params['account_id']  # noqa: E501
        if 'conference_id' in local_var_params:
            path_params['conferenceId'] = local_var_params['conference_id']  # noqa: E501
        path_params['accountId'] = self.accountId

        query_params = []
        if 'talk' in local_var_params and local_var_params['talk'] is not None:  # noqa: E501
            query_params.append(('talk', local_var_params['talk']))  # noqa: E501
        if 'listen' in local_var_params and local_var_params['listen'] is not None:  # noqa: E501
            query_params.append(('listen', local_var_params['listen']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['fc']  # noqa: E501

        return self.api_client.call_api(
            '/Accounts/{accountId}/Conferences/{conferenceId}/Participants', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ConferenceParticipantList',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_recordings(self, **kwargs):  # noqa: E501
        """List Recordings  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_recordings(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str call_id: Show only Recordings made during the Call with this ID.
        :param str conference_id: Show only Recordings made during the conference with this ID.
        :param str date_created: Only show Recordings created on this date, formatted as *YYYY-MM-DD*.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: RecordingList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.list_recordings_with_http_info(**kwargs)  # noqa: E501

    def list_recordings_with_http_info(self, **kwargs):  # noqa: E501
        """List Recordings  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_recordings_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str call_id: Show only Recordings made during the Call with this ID.
        :param str conference_id: Show only Recordings made during the conference with this ID.
        :param str date_created: Only show Recordings created on this date, formatted as *YYYY-MM-DD*.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(RecordingList, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['call_id', 'conference_id', 'date_created']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_recordings" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}
        if 'account_id' in local_var_params:
            path_params['accountId'] = local_var_params['account_id']  # noqa: E501
        path_params['accountId'] = self.accountId

        query_params = []
        if 'call_id' in local_var_params and local_var_params['call_id'] is not None:  # noqa: E501
            query_params.append(('callId', local_var_params['call_id']))  # noqa: E501
        if 'conference_id' in local_var_params and local_var_params['conference_id'] is not None:  # noqa: E501
            query_params.append(('conferenceId', local_var_params['conference_id']))  # noqa: E501
        if 'date_created' in local_var_params and local_var_params['date_created'] is not None:  # noqa: E501
            query_params.append(('dateCreated', local_var_params['date_created']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['fc']  # noqa: E501

        return self.api_client.call_api(
            '/Accounts/{accountId}/Recordings', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RecordingList',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_sms_messages(self, **kwargs):  # noqa: E501
        """List SMS Messages  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_sms_messages(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str to: Only show Messages to this phone number.
        :param str _from: Only show Messages from this phone number.
        :param str begin_time: Only show Messages sent at or after this time (GMT), given as *YYYY-MM-DD hh:mm:ss*.
        :param str end_time: Only show messages sent at or before this time (GMT), given as *YYYY-MM-DD hh:mm*..
        :param str direction: Either `inbound` or `outbound`. Only show Messages that were either *sent from* or *received by* FreeClimb.
        :param str account_id: String that uniquely identifies this account resource.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: MessagesList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.list_sms_messages_with_http_info(**kwargs)  # noqa: E501

    def list_sms_messages_with_http_info(self, **kwargs):  # noqa: E501
        """List SMS Messages  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_sms_messages_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str to: Only show Messages to this phone number.
        :param str _from: Only show Messages from this phone number.
        :param str begin_time: Only show Messages sent at or after this time (GMT), given as *YYYY-MM-DD hh:mm:ss*.
        :param str end_time: Only show messages sent at or before this time (GMT), given as *YYYY-MM-DD hh:mm*..
        :param str direction: Either `inbound` or `outbound`. Only show Messages that were either *sent from* or *received by* FreeClimb.
        :param str account_id: String that uniquely identifies this account resource.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(MessagesList, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['to', '_from', 'begin_time', 'end_time', 'direction', 'account_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_sms_messages" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}
        if 'account_id' in local_var_params:
            path_params['accountId'] = local_var_params['account_id']  # noqa: E501
        path_params['accountId'] = self.accountId

        query_params = []
        if 'to' in local_var_params and local_var_params['to'] is not None:  # noqa: E501
            query_params.append(('to', local_var_params['to']))  # noqa: E501
        if '_from' in local_var_params and local_var_params['_from'] is not None:  # noqa: E501
            query_params.append(('from', local_var_params['_from']))  # noqa: E501
        if 'begin_time' in local_var_params and local_var_params['begin_time'] is not None:  # noqa: E501
            query_params.append(('beginTime', local_var_params['begin_time']))  # noqa: E501
        if 'end_time' in local_var_params and local_var_params['end_time'] is not None:  # noqa: E501
            query_params.append(('endTime', local_var_params['end_time']))  # noqa: E501
        if 'direction' in local_var_params and local_var_params['direction'] is not None:  # noqa: E501
            query_params.append(('direction', local_var_params['direction']))  # noqa: E501
        if 'account_id' in local_var_params and local_var_params['account_id'] is not None:  # noqa: E501
            query_params.append(('accountID', local_var_params['account_id']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['fc']  # noqa: E501

        return self.api_client.call_api(
            '/Accounts/{accountId}/Messages', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='MessagesList',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def make_a_call(self, **kwargs):  # noqa: E501
        """Make a Call  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.make_a_call(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param MakeCallRequest make_call_request: Call details for making a call
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: CallResult
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.make_a_call_with_http_info(**kwargs)  # noqa: E501

    def make_a_call_with_http_info(self, **kwargs):  # noqa: E501
        """Make a Call  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.make_a_call_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param MakeCallRequest make_call_request: Call details for making a call
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(CallResult, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['make_call_request']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method make_a_call" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}
        if 'account_id' in local_var_params:
            path_params['accountId'] = local_var_params['account_id']  # noqa: E501
        path_params['accountId'] = self.accountId

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'make_call_request' in local_var_params:
            body_params = local_var_params['make_call_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['fc']  # noqa: E501

        return self.api_client.call_api(
            '/Accounts/{accountId}/Calls', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CallResult',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def remove_a_participant(self, conference_id, call_id, **kwargs):  # noqa: E501
        """Remove a Participant  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.remove_a_participant(conference_id, call_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str conference_id: ID of the conference this participant is in. (required)
        :param str call_id: ID of the Call associated with this participant. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.remove_a_participant_with_http_info(conference_id, call_id, **kwargs)  # noqa: E501

    def remove_a_participant_with_http_info(self, conference_id, call_id, **kwargs):  # noqa: E501
        """Remove a Participant  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.remove_a_participant_with_http_info(conference_id, call_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str conference_id: ID of the conference this participant is in. (required)
        :param str call_id: ID of the Call associated with this participant. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['conference_id', 'call_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method remove_a_participant" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'conference_id' is set
        if self.api_client.client_side_validation and ('conference_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['conference_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `conference_id` when calling `remove_a_participant`")  # noqa: E501
        # verify the required parameter 'call_id' is set
        if self.api_client.client_side_validation and ('call_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['call_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `call_id` when calling `remove_a_participant`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'account_id' in local_var_params:
            path_params['accountId'] = local_var_params['account_id']  # noqa: E501
        if 'conference_id' in local_var_params:
            path_params['conferenceId'] = local_var_params['conference_id']  # noqa: E501
        if 'call_id' in local_var_params:
            path_params['callId'] = local_var_params['call_id']  # noqa: E501
        path_params['accountId'] = self.accountId

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['fc']  # noqa: E501

        return self.api_client.call_api(
            '/Accounts/{accountId}/Conferences/{conferenceId}/Participants/{callId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def send_an_sms_message(self, **kwargs):  # noqa: E501
        """Send an SMS Message  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.send_an_sms_message(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param MessageRequest message_request: Details to create a message
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: MessageResult
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.send_an_sms_message_with_http_info(**kwargs)  # noqa: E501

    def send_an_sms_message_with_http_info(self, **kwargs):  # noqa: E501
        """Send an SMS Message  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.send_an_sms_message_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param MessageRequest message_request: Details to create a message
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(MessageResult, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['message_request']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method send_an_sms_message" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}
        if 'account_id' in local_var_params:
            path_params['accountId'] = local_var_params['account_id']  # noqa: E501
        path_params['accountId'] = self.accountId

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'message_request' in local_var_params:
            body_params = local_var_params['message_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['fc']  # noqa: E501

        return self.api_client.call_api(
            '/Accounts/{accountId}/Messages', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='MessageResult',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def stream_a_recording_file(self, recording_id, **kwargs):  # noqa: E501
        """Stream a Recording File  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.stream_a_recording_file(recording_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str recording_id: String that uniquely identifies this recording resource. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.stream_a_recording_file_with_http_info(recording_id, **kwargs)  # noqa: E501

    def stream_a_recording_file_with_http_info(self, recording_id, **kwargs):  # noqa: E501
        """Stream a Recording File  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.stream_a_recording_file_with_http_info(recording_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str recording_id: String that uniquely identifies this recording resource. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(file, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['recording_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method stream_a_recording_file" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'recording_id' is set
        if self.api_client.client_side_validation and ('recording_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['recording_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `recording_id` when calling `stream_a_recording_file`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'account_id' in local_var_params:
            path_params['accountId'] = local_var_params['account_id']  # noqa: E501
        if 'recording_id' in local_var_params:
            path_params['recordingId'] = local_var_params['recording_id']  # noqa: E501
        path_params['accountId'] = self.accountId

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['audio/x-wav'])  # noqa: E501

        # Authentication setting
        auth_settings = ['fc']  # noqa: E501

        return self.api_client.call_api(
            '/Accounts/{accountId}/Recordings/{recordingId}/Stream', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='file',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_a_conference(self, conference_id, **kwargs):  # noqa: E501
        """Update a Conference  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_a_conference(conference_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str conference_id: String that uniquely identifies this conference resource. (required)
        :param UpdateConferenceRequest update_conference_request: Conference Details to update
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ConferenceResult
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.update_a_conference_with_http_info(conference_id, **kwargs)  # noqa: E501

    def update_a_conference_with_http_info(self, conference_id, **kwargs):  # noqa: E501
        """Update a Conference  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_a_conference_with_http_info(conference_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str conference_id: String that uniquely identifies this conference resource. (required)
        :param UpdateConferenceRequest update_conference_request: Conference Details to update
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ConferenceResult, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['conference_id', 'update_conference_request']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_a_conference" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'conference_id' is set
        if self.api_client.client_side_validation and ('conference_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['conference_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `conference_id` when calling `update_a_conference`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'account_id' in local_var_params:
            path_params['accountId'] = local_var_params['account_id']  # noqa: E501
        if 'conference_id' in local_var_params:
            path_params['conferenceId'] = local_var_params['conference_id']  # noqa: E501
        path_params['accountId'] = self.accountId

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'update_conference_request' in local_var_params:
            body_params = local_var_params['update_conference_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['fc']  # noqa: E501

        return self.api_client.call_api(
            '/Accounts/{accountId}/Conferences/{conferenceId}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ConferenceResult',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_a_live_call(self, call_id, **kwargs):  # noqa: E501
        """Update a Live Call  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_a_live_call(call_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str call_id: String that uniquely identifies this call resource. (required)
        :param UpdateCallRequest update_call_request: Call details to update
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.update_a_live_call_with_http_info(call_id, **kwargs)  # noqa: E501

    def update_a_live_call_with_http_info(self, call_id, **kwargs):  # noqa: E501
        """Update a Live Call  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_a_live_call_with_http_info(call_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str call_id: String that uniquely identifies this call resource. (required)
        :param UpdateCallRequest update_call_request: Call details to update
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['call_id', 'update_call_request']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_a_live_call" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'call_id' is set
        if self.api_client.client_side_validation and ('call_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['call_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `call_id` when calling `update_a_live_call`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'account_id' in local_var_params:
            path_params['accountId'] = local_var_params['account_id']  # noqa: E501
        if 'call_id' in local_var_params:
            path_params['callId'] = local_var_params['call_id']  # noqa: E501
        path_params['accountId'] = self.accountId

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'update_call_request' in local_var_params:
            body_params = local_var_params['update_call_request']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['fc']  # noqa: E501

        return self.api_client.call_api(
            '/Accounts/{accountId}/Calls/{callId}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_a_participant(self, conference_id, call_id, **kwargs):  # noqa: E501
        """Update a Participant  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_a_participant(conference_id, call_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str conference_id: ID of the conference this participant is in. (required)
        :param str call_id: ID of the Call associated with this participant. (required)
        :param UpdateConferenceParticipantRequest update_conference_participant_request: Conference participant details to update
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ConferenceParticipantResult
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.update_a_participant_with_http_info(conference_id, call_id, **kwargs)  # noqa: E501

    def update_a_participant_with_http_info(self, conference_id, call_id, **kwargs):  # noqa: E501
        """Update a Participant  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_a_participant_with_http_info(conference_id, call_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str conference_id: ID of the conference this participant is in. (required)
        :param str call_id: ID of the Call associated with this participant. (required)
        :param UpdateConferenceParticipantRequest update_conference_participant_request: Conference participant details to update
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ConferenceParticipantResult, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['conference_id', 'call_id', 'update_conference_participant_request']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_a_participant" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'conference_id' is set
        if self.api_client.client_side_validation and ('conference_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['conference_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `conference_id` when calling `update_a_participant`")  # noqa: E501
        # verify the required parameter 'call_id' is set
        if self.api_client.client_side_validation and ('call_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['call_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `call_id` when calling `update_a_participant`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'account_id' in local_var_params:
            path_params['accountId'] = local_var_params['account_id']  # noqa: E501
        if 'conference_id' in local_var_params:
            path_params['conferenceId'] = local_var_params['conference_id']  # noqa: E501
        if 'call_id' in local_var_params:
            path_params['callId'] = local_var_params['call_id']  # noqa: E501
        path_params['accountId'] = self.accountId

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'update_conference_participant_request' in local_var_params:
            body_params = local_var_params['update_conference_participant_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['fc']  # noqa: E501

        return self.api_client.call_api(
            '/Accounts/{accountId}/Conferences/{conferenceId}/Participants/{callId}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ConferenceParticipantResult',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_a_queue(self, queue_id, **kwargs):  # noqa: E501
        """Update a Queue  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_a_queue(queue_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str queue_id: A string that uniquely identifies this Queue resource. (required)
        :param QueueRequest queue_request: Queue Details to update
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: QueueResult
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.update_a_queue_with_http_info(queue_id, **kwargs)  # noqa: E501

    def update_a_queue_with_http_info(self, queue_id, **kwargs):  # noqa: E501
        """Update a Queue  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_a_queue_with_http_info(queue_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str queue_id: A string that uniquely identifies this Queue resource. (required)
        :param QueueRequest queue_request: Queue Details to update
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(QueueResult, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['queue_id', 'queue_request']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_a_queue" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'queue_id' is set
        if self.api_client.client_side_validation and ('queue_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['queue_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `queue_id` when calling `update_a_queue`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'account_id' in local_var_params:
            path_params['accountId'] = local_var_params['account_id']  # noqa: E501
        if 'queue_id' in local_var_params:
            path_params['queueId'] = local_var_params['queue_id']  # noqa: E501
        path_params['accountId'] = self.accountId

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'queue_request' in local_var_params:
            body_params = local_var_params['queue_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['fc']  # noqa: E501

        return self.api_client.call_api(
            '/Accounts/{accountId}/Queues/{queueId}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='QueueResult',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_an_account(self, **kwargs):  # noqa: E501
        """Manage an account  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_an_account(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param AccountRequest account_request: Account details to update
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.update_an_account_with_http_info(**kwargs)  # noqa: E501

    def update_an_account_with_http_info(self, **kwargs):  # noqa: E501
        """Manage an account  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_an_account_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param AccountRequest account_request: Account details to update
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['account_request']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_an_account" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}
        if 'account_id' in local_var_params:
            path_params['accountId'] = local_var_params['account_id']  # noqa: E501
        path_params['accountId'] = self.accountId

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'account_request' in local_var_params:
            body_params = local_var_params['account_request']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['fc']  # noqa: E501

        return self.api_client.call_api(
            '/Accounts/{accountId}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_an_application(self, application_id, **kwargs):  # noqa: E501
        """Update an application  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_an_application(application_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str application_id: A string that uniquely identifies this application resource. (required)
        :param ApplicationRequest application_request: Application details to update.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ApplicationResult
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.update_an_application_with_http_info(application_id, **kwargs)  # noqa: E501

    def update_an_application_with_http_info(self, application_id, **kwargs):  # noqa: E501
        """Update an application  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_an_application_with_http_info(application_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str application_id: A string that uniquely identifies this application resource. (required)
        :param ApplicationRequest application_request: Application details to update.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ApplicationResult, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['application_id', 'application_request']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_an_application" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'application_id' is set
        if self.api_client.client_side_validation and ('application_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['application_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `application_id` when calling `update_an_application`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'account_id' in local_var_params:
            path_params['accountId'] = local_var_params['account_id']  # noqa: E501
        if 'application_id' in local_var_params:
            path_params['applicationId'] = local_var_params['application_id']  # noqa: E501
        path_params['accountId'] = self.accountId

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'application_request' in local_var_params:
            body_params = local_var_params['application_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['fc']  # noqa: E501

        return self.api_client.call_api(
            '/Accounts/{accountId}/Applications/{applicationId}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApplicationResult',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_an_incoming_number(self, phone_number_id, **kwargs):  # noqa: E501
        """Update an Incoming Number  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_an_incoming_number(phone_number_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str phone_number_id: String that uniquely identifies this phone number resource. (required)
        :param IncomingNumberRequest incoming_number_request: Incoming Number details to update
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: IncomingNumberResult
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.update_an_incoming_number_with_http_info(phone_number_id, **kwargs)  # noqa: E501

    def update_an_incoming_number_with_http_info(self, phone_number_id, **kwargs):  # noqa: E501
        """Update an Incoming Number  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_an_incoming_number_with_http_info(phone_number_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str phone_number_id: String that uniquely identifies this phone number resource. (required)
        :param IncomingNumberRequest incoming_number_request: Incoming Number details to update
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(IncomingNumberResult, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['phone_number_id', 'incoming_number_request']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_an_incoming_number" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'phone_number_id' is set
        if self.api_client.client_side_validation and ('phone_number_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['phone_number_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `phone_number_id` when calling `update_an_incoming_number`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'account_id' in local_var_params:
            path_params['accountId'] = local_var_params['account_id']  # noqa: E501
        if 'phone_number_id' in local_var_params:
            path_params['phoneNumberId'] = local_var_params['phone_number_id']  # noqa: E501
        path_params['accountId'] = self.accountId

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'incoming_number_request' in local_var_params:
            body_params = local_var_params['incoming_number_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['fc']  # noqa: E501

        return self.api_client.call_api(
            '/Accounts/{accountId}/IncomingPhoneNumbers/{phoneNumberId}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='IncomingNumberResult',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)
