# coding: utf-8

"""
    FreeClimb API

    FreeClimb is a cloud-based application programming interface (API) that puts the power of the Vail platform in your hands. FreeClimb simplifies the process of creating applications that can use a full range of telephony features without requiring specialized or on-site telephony equipment. Using the FreeClimb REST API to write applications is easy! You have the option to use the language of your choice or hit the API directly. Your application can execute a command by issuing a RESTful request to the FreeClimb API. The base URL to send HTTP requests to the FreeClimb REST API is: /apiserver. FreeClimb authenticates and processes your request.  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Contact: support@freeclimb.com
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from freeclimb.configuration import Configuration


class CreateConference(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'action_url': 'str',
        'alias': 'bool',
        'play_beep': 'str',
        'record': 'bool',
        'status_callback_url': 'bool',
        'wait_url': 'str'
    }

    attribute_map = {
        'action_url': 'actionUrl',
        'alias': 'alias',
        'play_beep': 'playBeep',
        'record': 'record',
        'status_callback_url': 'statusCallbackUrl',
        'wait_url': 'waitUrl'
    }

    def __init__(self, action_url=None, alias=None, play_beep=None, record=None, status_callback_url=None, wait_url=None, local_vars_configuration=None):  # noqa: E501
        """CreateConference - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._action_url = None
        self._alias = None
        self._play_beep = None
        self._record = None
        self._status_callback_url = None
        self._wait_url = None
        self.discriminator = None

        self.action_url = action_url
        if alias is not None:
            self.alias = alias
        if play_beep is not None:
            self.play_beep = play_beep
        if record is not None:
            self.record = record
        if status_callback_url is not None:
            self.status_callback_url = status_callback_url
        if wait_url is not None:
            self.wait_url = wait_url

    @property
    def action_url(self):
        """Gets the action_url of this CreateConference.  # noqa: E501

         This URL is invoked once the Conference is successfully created. Actions on the Conference, such as adding Participants, can be performed via the PerCL script returned in the response.   # noqa: E501

        :return: The action_url of this CreateConference.  # noqa: E501
        :rtype: str
        """
        return self._action_url

    @action_url.setter
    def action_url(self, action_url):
        """Sets the action_url of this CreateConference.

         This URL is invoked once the Conference is successfully created. Actions on the Conference, such as adding Participants, can be performed via the PerCL script returned in the response.   # noqa: E501

        :param action_url: The action_url of this CreateConference.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and action_url is None:  # noqa: E501
            raise ValueError("Invalid value for `action_url`, must not be `None`")  # noqa: E501

        self._action_url = action_url

    @property
    def alias(self):
        """Gets the alias of this CreateConference.  # noqa: E501

        Descriptive name for the Conference.   # noqa: E501

        :return: The alias of this CreateConference.  # noqa: E501
        :rtype: bool
        """
        return self._alias

    @alias.setter
    def alias(self, alias):
        """Sets the alias of this CreateConference.

        Descriptive name for the Conference.   # noqa: E501

        :param alias: The alias of this CreateConference.  # noqa: E501
        :type: bool
        """

        self._alias = alias

    @property
    def play_beep(self):
        """Gets the play_beep of this CreateConference.  # noqa: E501

        Indicates whether to play a beep when a Participant enters or leaves the Conference. either `always`, `never`, `entryOnly`, or `exitOnly`. Leaving this unset will make conference default to `always`   # noqa: E501

        :return: The play_beep of this CreateConference.  # noqa: E501
        :rtype: str
        """
        return self._play_beep

    @play_beep.setter
    def play_beep(self, play_beep):
        """Sets the play_beep of this CreateConference.

        Indicates whether to play a beep when a Participant enters or leaves the Conference. either `always`, `never`, `entryOnly`, or `exitOnly`. Leaving this unset will make conference default to `always`   # noqa: E501

        :param play_beep: The play_beep of this CreateConference.  # noqa: E501
        :type: str
        """

        self._play_beep = play_beep

    @property
    def record(self):
        """Gets the record of this CreateConference.  # noqa: E501

        When set to `true`, the entire Conference is recorded. The `statusCallbackUrl` of the Conference will receive a `conferenceRecordingEnded` Webhook when the Conference transitions from the `inProgress` to empty state.  # noqa: E501

        :return: The record of this CreateConference.  # noqa: E501
        :rtype: bool
        """
        return self._record

    @record.setter
    def record(self, record):
        """Sets the record of this CreateConference.

        When set to `true`, the entire Conference is recorded. The `statusCallbackUrl` of the Conference will receive a `conferenceRecordingEnded` Webhook when the Conference transitions from the `inProgress` to empty state.  # noqa: E501

        :param record: The record of this CreateConference.  # noqa: E501
        :type: bool
        """

        self._record = record

    @property
    def status_callback_url(self):
        """Gets the status_callback_url of this CreateConference.  # noqa: E501

        This URL is invoked when the status of the Conference changes or when a recording of the Conference has become available.  # noqa: E501

        :return: The status_callback_url of this CreateConference.  # noqa: E501
        :rtype: bool
        """
        return self._status_callback_url

    @status_callback_url.setter
    def status_callback_url(self, status_callback_url):
        """Sets the status_callback_url of this CreateConference.

        This URL is invoked when the status of the Conference changes or when a recording of the Conference has become available.  # noqa: E501

        :param status_callback_url: The status_callback_url of this CreateConference.  # noqa: E501
        :type: bool
        """

        self._status_callback_url = status_callback_url

    @property
    def wait_url(self):
        """Gets the wait_url of this CreateConference.  # noqa: E501

        If specified, this URL provides the custom hold music for the Conference when it is in the populated state. This attribute is always fetched using HTTP GET and is fetched just once – when the Conference is created. The URL must be an audio file that is reachable and readable by FreeClimb.  # noqa: E501

        :return: The wait_url of this CreateConference.  # noqa: E501
        :rtype: str
        """
        return self._wait_url

    @wait_url.setter
    def wait_url(self, wait_url):
        """Sets the wait_url of this CreateConference.

        If specified, this URL provides the custom hold music for the Conference when it is in the populated state. This attribute is always fetched using HTTP GET and is fetched just once – when the Conference is created. The URL must be an audio file that is reachable and readable by FreeClimb.  # noqa: E501

        :param wait_url: The wait_url of this CreateConference.  # noqa: E501
        :type: str
        """

        self._wait_url = wait_url

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.to_camel_case(attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            elif value is None:
                continue
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, CreateConference):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, CreateConference):
            return True

        return self.to_dict() != other.to_dict()

    def to_camel_case(self, snake_str):
        components = snake_str.split('_')
        return components[0] + ''.join(x.title() for x in components[1:])
