# coding: utf-8

"""
    FreeClimb API

    FreeClimb is a cloud-based application programming interface (API) that puts the power of the Vail platform in your hands. FreeClimb simplifies the process of creating applications that can use a full range of telephony features without requiring specialized or on-site telephony equipment. Using the FreeClimb REST API to write applications is easy! You have the option to use the language of your choice or hit the API directly. Your application can execute a command by issuing a RESTful request to the FreeClimb API. The base URL to send HTTP requests to the FreeClimb REST API is: /apiserver. FreeClimb authenticates and processes your request.  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Contact: support@freeclimb.com
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from freeclimb.configuration import Configuration


class MessageResult(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'uri': 'str',
        'date_created': 'str',
        'date_updated': 'str',
        'revision': 'int',
        'account_id': 'str',
        'message_id': 'str',
        'status': 'str',
        '_from': 'str',
        'to': 'str',
        'text': 'str',
        'direction': 'str',
        'notification_url': 'str'
    }

    attribute_map = {
        'uri': 'uri',
        'date_created': 'dateCreated',
        'date_updated': 'dateUpdated',
        'revision': 'revision',
        'account_id': 'accountId',
        'message_id': 'messageId',
        'status': 'status',
        '_from': 'from',
        'to': 'to',
        'text': 'text',
        'direction': 'direction',
        'notification_url': 'notificationUrl'
    }

    def __init__(self, uri=None, date_created=None, date_updated=None, revision=None, account_id=None, message_id=None, status=None, _from=None, to=None, text=None, direction=None, notification_url=None, local_vars_configuration=None):  # noqa: E501
        """MessageResult - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._uri = None
        self._date_created = None
        self._date_updated = None
        self._revision = None
        self._account_id = None
        self._message_id = None
        self._status = None
        self.__from = None
        self._to = None
        self._text = None
        self._direction = None
        self._notification_url = None
        self.discriminator = None

        if uri is not None:
            self.uri = uri
        if date_created is not None:
            self.date_created = date_created
        if date_updated is not None:
            self.date_updated = date_updated
        if revision is not None:
            self.revision = revision
        if account_id is not None:
            self.account_id = account_id
        if message_id is not None:
            self.message_id = message_id
        if status is not None:
            self.status = status
        if _from is not None:
            self._from = _from
        if to is not None:
            self.to = to
        if text is not None:
            self.text = text
        if direction is not None:
            self.direction = direction
        if notification_url is not None:
            self.notification_url = notification_url

    @property
    def uri(self):
        """Gets the uri of this MessageResult.  # noqa: E501

        The URI for this resource, relative to /apiserver.  # noqa: E501

        :return: The uri of this MessageResult.  # noqa: E501
        :rtype: str
        """
        return self._uri

    @uri.setter
    def uri(self, uri):
        """Sets the uri of this MessageResult.

        The URI for this resource, relative to /apiserver.  # noqa: E501

        :param uri: The uri of this MessageResult.  # noqa: E501
        :type: str
        """

        self._uri = uri

    @property
    def date_created(self):
        """Gets the date_created of this MessageResult.  # noqa: E501

        The date that this resource was created (GMT) in RFC 1123 format (e.g., Mon, 15 Jun 2009 20:45:30 GMT).  # noqa: E501

        :return: The date_created of this MessageResult.  # noqa: E501
        :rtype: str
        """
        return self._date_created

    @date_created.setter
    def date_created(self, date_created):
        """Sets the date_created of this MessageResult.

        The date that this resource was created (GMT) in RFC 1123 format (e.g., Mon, 15 Jun 2009 20:45:30 GMT).  # noqa: E501

        :param date_created: The date_created of this MessageResult.  # noqa: E501
        :type: str
        """

        self._date_created = date_created

    @property
    def date_updated(self):
        """Gets the date_updated of this MessageResult.  # noqa: E501

        The date that this resource was last updated (GMT) in RFC 1123 format (e.g., Mon, 15 Jun 2009 20:45:30 GMT).  # noqa: E501

        :return: The date_updated of this MessageResult.  # noqa: E501
        :rtype: str
        """
        return self._date_updated

    @date_updated.setter
    def date_updated(self, date_updated):
        """Sets the date_updated of this MessageResult.

        The date that this resource was last updated (GMT) in RFC 1123 format (e.g., Mon, 15 Jun 2009 20:45:30 GMT).  # noqa: E501

        :param date_updated: The date_updated of this MessageResult.  # noqa: E501
        :type: str
        """

        self._date_updated = date_updated

    @property
    def revision(self):
        """Gets the revision of this MessageResult.  # noqa: E501

        Revision count for the resource. This count is set to 1 on creation and is incremented every time it is updated.  # noqa: E501

        :return: The revision of this MessageResult.  # noqa: E501
        :rtype: int
        """
        return self._revision

    @revision.setter
    def revision(self, revision):
        """Sets the revision of this MessageResult.

        Revision count for the resource. This count is set to 1 on creation and is incremented every time it is updated.  # noqa: E501

        :param revision: The revision of this MessageResult.  # noqa: E501
        :type: int
        """

        self._revision = revision

    @property
    def account_id(self):
        """Gets the account_id of this MessageResult.  # noqa: E501

        String that uniquely identifies this account resource.  # noqa: E501

        :return: The account_id of this MessageResult.  # noqa: E501
        :rtype: str
        """
        return self._account_id

    @account_id.setter
    def account_id(self, account_id):
        """Sets the account_id of this MessageResult.

        String that uniquely identifies this account resource.  # noqa: E501

        :param account_id: The account_id of this MessageResult.  # noqa: E501
        :type: str
        """

        self._account_id = account_id

    @property
    def message_id(self):
        """Gets the message_id of this MessageResult.  # noqa: E501

        String that uniquely identifies this message resource  # noqa: E501

        :return: The message_id of this MessageResult.  # noqa: E501
        :rtype: str
        """
        return self._message_id

    @message_id.setter
    def message_id(self, message_id):
        """Sets the message_id of this MessageResult.

        String that uniquely identifies this message resource  # noqa: E501

        :param message_id: The message_id of this MessageResult.  # noqa: E501
        :type: str
        """

        self._message_id = message_id

    @property
    def status(self):
        """Gets the status of this MessageResult.  # noqa: E501

        Indicates the state of the message through the message lifecycle including: new, queued, rejected, sending, sent, failed, received  # noqa: E501

        :return: The status of this MessageResult.  # noqa: E501
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status):
        """Sets the status of this MessageResult.

        Indicates the state of the message through the message lifecycle including: new, queued, rejected, sending, sent, failed, received  # noqa: E501

        :param status: The status of this MessageResult.  # noqa: E501
        :type: str
        """
        allowed_values = ["new", "queued", "rejected", "sending", "sent", "failed", "received", "undelivered"]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and status not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `status` ({0}), must be one of {1}"  # noqa: E501
                .format(status, allowed_values)
            )

        self._status = status

    @property
    def _from(self):
        """Gets the _from of this MessageResult.  # noqa: E501

        Phone number in E.164 format that sent the message.  # noqa: E501

        :return: The _from of this MessageResult.  # noqa: E501
        :rtype: str
        """
        return self.__from

    @_from.setter
    def _from(self, _from):
        """Sets the _from of this MessageResult.

        Phone number in E.164 format that sent the message.  # noqa: E501

        :param _from: The _from of this MessageResult.  # noqa: E501
        :type: str
        """

        self.__from = _from

    @property
    def to(self):
        """Gets the to of this MessageResult.  # noqa: E501

        Phone number in E.164 format that received the message.  # noqa: E501

        :return: The to of this MessageResult.  # noqa: E501
        :rtype: str
        """
        return self._to

    @to.setter
    def to(self, to):
        """Sets the to of this MessageResult.

        Phone number in E.164 format that received the message.  # noqa: E501

        :param to: The to of this MessageResult.  # noqa: E501
        :type: str
        """

        self._to = to

    @property
    def text(self):
        """Gets the text of this MessageResult.  # noqa: E501

        Message contents  # noqa: E501

        :return: The text of this MessageResult.  # noqa: E501
        :rtype: str
        """
        return self._text

    @text.setter
    def text(self, text):
        """Sets the text of this MessageResult.

        Message contents  # noqa: E501

        :param text: The text of this MessageResult.  # noqa: E501
        :type: str
        """

        self._text = text

    @property
    def direction(self):
        """Gets the direction of this MessageResult.  # noqa: E501

        Noting whether the message was inbound or outbound  # noqa: E501

        :return: The direction of this MessageResult.  # noqa: E501
        :rtype: str
        """
        return self._direction

    @direction.setter
    def direction(self, direction):
        """Sets the direction of this MessageResult.

        Noting whether the message was inbound or outbound  # noqa: E501

        :param direction: The direction of this MessageResult.  # noqa: E501
        :type: str
        """

        self._direction = direction

    @property
    def notification_url(self):
        """Gets the notification_url of this MessageResult.  # noqa: E501

        URL invoked when message sent  # noqa: E501

        :return: The notification_url of this MessageResult.  # noqa: E501
        :rtype: str
        """
        return self._notification_url

    @notification_url.setter
    def notification_url(self, notification_url):
        """Sets the notification_url of this MessageResult.

        URL invoked when message sent  # noqa: E501

        :param notification_url: The notification_url of this MessageResult.  # noqa: E501
        :type: str
        """

        self._notification_url = notification_url

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.to_camel_case(attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            elif value is None:
                continue
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, MessageResult):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, MessageResult):
            return True

        return self.to_dict() != other.to_dict()

    def to_camel_case(self, snake_str):
        components = snake_str.split('_')
        return components[0] + ''.join(x.title() for x in components[1:])
