# coding: utf-8

"""
    FreeClimb API

    FreeClimb is a cloud-based application programming interface (API) that puts the power of the Vail platform in your hands. FreeClimb simplifies the process of creating applications that can use a full range of telephony features without requiring specialized or on-site telephony equipment. Using the FreeClimb REST API to write applications is easy! You have the option to use the language of your choice or hit the API directly. Your application can execute a command by issuing a RESTful request to the FreeClimb API. The base URL to send HTTP requests to the FreeClimb REST API is: /apiserver. FreeClimb authenticates and processes your request.  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Contact: support@freeclimb.com
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from freeclimb.configuration import Configuration


class RecordUtterance(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'action_url': 'str',
        'silence_timeout_ms': 'int',
        'finish_on_key': 'str',
        'max_length_sec': 'int',
        'play_beep': 'bool',
        'auto_start': 'bool'
    }

    attribute_map = {
        'action_url': 'actionUrl',
        'silence_timeout_ms': 'silenceTimeoutMs',
        'finish_on_key': 'finishOnKey',
        'max_length_sec': 'maxLengthSec',
        'play_beep': 'playBeep',
        'auto_start': 'autoStart'
    }

    def __init__(self, action_url=None, silence_timeout_ms=None, finish_on_key=None, max_length_sec=None, play_beep=None, auto_start=None, local_vars_configuration=None):  # noqa: E501
        """RecordUtterance - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._action_url = None
        self._silence_timeout_ms = None
        self._finish_on_key = None
        self._max_length_sec = None
        self._play_beep = None
        self._auto_start = None
        self.discriminator = None

        self.action_url = action_url
        if silence_timeout_ms is not None:
            self.silence_timeout_ms = silence_timeout_ms
        if finish_on_key is not None:
            self.finish_on_key = finish_on_key
        if max_length_sec is not None:
            self.max_length_sec = max_length_sec
        if play_beep is not None:
            self.play_beep = play_beep
        if auto_start is not None:
            self.auto_start = auto_start

    @property
    def action_url(self):
        """Gets the action_url of this RecordUtterance.  # noqa: E501

        URL to which information on the completed recording is submitted. The PerCL received in response is then used to continue with Call processing.  # noqa: E501

        :return: The action_url of this RecordUtterance.  # noqa: E501
        :rtype: str
        """
        return self._action_url

    @action_url.setter
    def action_url(self, action_url):
        """Sets the action_url of this RecordUtterance.

        URL to which information on the completed recording is submitted. The PerCL received in response is then used to continue with Call processing.  # noqa: E501

        :param action_url: The action_url of this RecordUtterance.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and action_url is None:  # noqa: E501
            raise ValueError("Invalid value for `action_url`, must not be `None`")  # noqa: E501

        self._action_url = action_url

    @property
    def silence_timeout_ms(self):
        """Gets the silence_timeout_ms of this RecordUtterance.  # noqa: E501

        Interval of silence that should elapse before ending the recording.  # noqa: E501

        :return: The silence_timeout_ms of this RecordUtterance.  # noqa: E501
        :rtype: int
        """
        return self._silence_timeout_ms

    @silence_timeout_ms.setter
    def silence_timeout_ms(self, silence_timeout_ms):
        """Sets the silence_timeout_ms of this RecordUtterance.

        Interval of silence that should elapse before ending the recording.  # noqa: E501

        :param silence_timeout_ms: The silence_timeout_ms of this RecordUtterance.  # noqa: E501
        :type: int
        """

        self._silence_timeout_ms = silence_timeout_ms

    @property
    def finish_on_key(self):
        """Gets the finish_on_key of this RecordUtterance.  # noqa: E501

        Key that triggers the end of the recording. any digit, '#', or '*'  # noqa: E501

        :return: The finish_on_key of this RecordUtterance.  # noqa: E501
        :rtype: str
        """
        return self._finish_on_key

    @finish_on_key.setter
    def finish_on_key(self, finish_on_key):
        """Sets the finish_on_key of this RecordUtterance.

        Key that triggers the end of the recording. any digit, '#', or '*'  # noqa: E501

        :param finish_on_key: The finish_on_key of this RecordUtterance.  # noqa: E501
        :type: str
        """

        self._finish_on_key = finish_on_key

    @property
    def max_length_sec(self):
        """Gets the max_length_sec of this RecordUtterance.  # noqa: E501

        Maximum length for the command execution in seconds.  # noqa: E501

        :return: The max_length_sec of this RecordUtterance.  # noqa: E501
        :rtype: int
        """
        return self._max_length_sec

    @max_length_sec.setter
    def max_length_sec(self, max_length_sec):
        """Sets the max_length_sec of this RecordUtterance.

        Maximum length for the command execution in seconds.  # noqa: E501

        :param max_length_sec: The max_length_sec of this RecordUtterance.  # noqa: E501
        :type: int
        """

        self._max_length_sec = max_length_sec

    @property
    def play_beep(self):
        """Gets the play_beep of this RecordUtterance.  # noqa: E501

        Indicates whether to play a beep sound before the start of the recording. If set to `false`, no beep is played.  # noqa: E501

        :return: The play_beep of this RecordUtterance.  # noqa: E501
        :rtype: bool
        """
        return self._play_beep

    @play_beep.setter
    def play_beep(self, play_beep):
        """Sets the play_beep of this RecordUtterance.

        Indicates whether to play a beep sound before the start of the recording. If set to `false`, no beep is played.  # noqa: E501

        :param play_beep: The play_beep of this RecordUtterance.  # noqa: E501
        :type: bool
        """

        self._play_beep = play_beep

    @property
    def auto_start(self):
        """Gets the auto_start of this RecordUtterance.  # noqa: E501

        If `false`, recording begins immediately after the RecordUtterance command is processed. If `true`, recording begins when audio is present and if audio begins before the `maxLengthSec` timeout. If no audio begins before `maxLengthSec`, no recording is generated.  # noqa: E501

        :return: The auto_start of this RecordUtterance.  # noqa: E501
        :rtype: bool
        """
        return self._auto_start

    @auto_start.setter
    def auto_start(self, auto_start):
        """Sets the auto_start of this RecordUtterance.

        If `false`, recording begins immediately after the RecordUtterance command is processed. If `true`, recording begins when audio is present and if audio begins before the `maxLengthSec` timeout. If no audio begins before `maxLengthSec`, no recording is generated.  # noqa: E501

        :param auto_start: The auto_start of this RecordUtterance.  # noqa: E501
        :type: bool
        """

        self._auto_start = auto_start

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.to_camel_case(attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            elif value is None:
                continue
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, RecordUtterance):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, RecordUtterance):
            return True

        return self.to_dict() != other.to_dict()

    def to_camel_case(self, snake_str):
        components = snake_str.split('_')
        return components[0] + ''.join(x.title() for x in components[1:])
