<p align="center">
<b>DISCLAIMER: </b>EDS-TeVa is intended to be a module of <a href="https://github.com/aphp/EDS-Scikit">EDS-Scikit</a>
</p>

<div align="center">

<p align="center">
  <a href="https://aphp.github.io/edsteva/latest/"><img src="https://aphp.github.io/edsteva/latest/assets/logo/edsteva_logo_small.svg" alt="EDS-TeVa"></a>
</p>

# EDS-TeVa

<p align="center">
<a href="https://aphp.github.io/edsteva/latest/" target="_blank">
    <img src="https://img.shields.io/github/workflow/status/aphp/edsteva/Tests%20and%20Linting?label=tests&style=flat-square" alt="Tests">
</a>
<a href="https://aphp.github.io/edsteva/latest/" target="_blank">
    <img src="https://img.shields.io/github/workflow/status/aphp/edsteva/Documentation?label=docs&style=flat-square" alt="Documentation">
</a>
<a href="https://pypi.org/project/edsteva/" target="_blank">
    <img src="https://img.shields.io/pypi/v/edsteva?color=blue&style=flat-square" alt="PyPI">
</a>
<a href="https://codecov.io/gh/aphp/edsteva" target="_blank">
    <img src="https://img.shields.io/codecov/c/github/aphp/edsteva?logo=codecov&style=flat-square" alt="Codecov">
</a>
<a href="https://github.com/psf/black" target="_blank">
    <img src="https://img.shields.io/badge/code%20style-black-000000.svg" alt="Black">
</a>
<a href="https://python-poetry.org/" target="_blank">
    <img src="https://img.shields.io/badge/reproducibility-poetry-blue" alt="Poetry">
</a>
<a href="https://www.python.org/" target="_blank">
    <img src="https://img.shields.io/badge/python-%3E%3D%203.7.1%20%7C%20%3C%203.8-brightgreen" alt="Supported Python versions">
</a>
</p>
</div>

**Documentation**: <a href="https://aphp.github.io/edsteva/latest/" target="_blank">https://aphp.github.io/edsteva/latest/</a>

**Source Code**: <a href="https://github.com/aphp/edsteva" target="_blank">https://github.com/aphp/edsteva</a>

---

EDS-TeVa provides a set of tools that aims at modeling the adoption over time and across space of the Electronic Health Records.

## Requirements
EDS-TeVa stands on the shoulders of [Spark 2.4](https://spark.apache.org/docs/2.4.8/index.html) which requires:

- Python ~3.7.1
- Java 8

## Installation

You can install EDS-TeVa through ``pip``:

```shell
pip install edsteva
```
We recommend pinning the library version in your projects, or use a strict package manager like [Poetry](https://python-poetry.org/).

```shell
pip install edsteva==0.1.0
```
## Example

A scientific paper is currently being written that describes extensively the use of the library on the study of pulmonary embolism of cancer patients.

## Contributing

Contributions are welcome, and they are greatly appreciated! Every little bit helps, and credit will always be given.

## Acknowledgement

We would like to thank [Assistance Publique – Hôpitaux de Paris](https://www.aphp.fr/) and [AP-HP Foundation](https://fondationrechercheaphp.fr/) for funding this project.
