import { IBucket } from "aws-cdk-lib/aws-s3";
import { ApiGatewayIntegration, Integration, IntegrationGrantProps, IntegrationRenderProps } from "./integration";
import { IntegrationResponseSet } from "./integration-response-set";
import { Method } from "../spec";
/**
 * Options for S3Integration
 */
export interface S3IntegrationProps {
    /**
     * The S3 bucket to be invoked on integration
     */
    readonly bucket: IBucket;
    /**
     * The HTTP method to use when invoking the S3 bucket
     * @default - integration method is used
     */
    readonly method?: Method;
    /**
     * The path override to use when invoking the S3 bucket
     * @default - integration path is used
     */
    readonly path?: string;
    /**
     * Override the integration response set for the S3 integration
     * @default - a combination of IntegrationResponseSets.defaultPassthrough() and IntegrationResponseSets.s3JsonErrorMessage()
     */
    readonly integrationResponseSet?: IntegrationResponseSet;
}
/**
 * An S3 integration
 * @see https://docs.aws.amazon.com/apigateway/latest/developerguide/integrating-api-with-aws-services-s3.html
 */
export declare class S3Integration extends Integration {
    private readonly bucket;
    private readonly method?;
    private readonly path?;
    private readonly integrationResponseSet?;
    private readonly executionRoleId;
    constructor(props: S3IntegrationProps);
    private isRole;
    private executionRole;
    /**
     * Render the S3 integration as a snippet of OpenAPI
     */
    render(props: IntegrationRenderProps): ApiGatewayIntegration;
    /**
     * Grant API Gateway permissions to invoke the S3 bucket
     */
    grant({ scope, method, path }: IntegrationGrantProps): void;
}
