import { IWebSocketRouteAuthorizer, WebSocketApi, WebSocketRouteIntegration, WebSocketStage } from "aws-cdk-lib/aws-apigatewayv2";
import { Construct } from "constructs";
import { WebSocketApiProps } from "./websocket/websocket-api-props";
import { WebSocketStageProps } from "./websocket/websocket-stage-props";
/**
 * Represents an integration for a route
 */
export interface TypeSafeWebsocketApiIntegration {
    /**
     * The integration to service the route
     */
    readonly integration: WebSocketRouteIntegration;
}
export interface WebsocketOperationDetails {
    /**
     * Path in the OpenAPI spec for the operation
     */
    readonly path: string;
}
export type WebsocketOperationLookup = {
    [operationId: string]: WebsocketOperationDetails;
};
/**
 * Properties for a Type Safe WebSocket API
 */
export interface TypeSafeWebsocketApiProps extends WebSocketApiProps {
    /**
     * Path to the websocket api specification json file
     */
    readonly specPath: string;
    /**
     * Details about each operation
     */
    readonly operationLookup: WebsocketOperationLookup;
    /**
     * WebSocket routes and their corresponding integrations
     */
    readonly integrations: {
        [operationId: string]: TypeSafeWebsocketApiIntegration;
    };
    /**
     * Integration for the $connect route (invoked when a new client connects)
     * @default mocked
     */
    readonly connect?: TypeSafeWebsocketApiIntegration;
    /**
     * Integration for the $disconnect route (invoked when a client disconnects)
     * @default mocked
     */
    readonly disconnect?: TypeSafeWebsocketApiIntegration;
    /**
     * Authorizer to use for the API (applied to the $connect route)
     * @default NONE
     */
    readonly authorizer?: IWebSocketRouteAuthorizer;
    /**
     * Options for the default stage
     */
    readonly stageProps?: WebSocketStageProps;
    /**
     * By default, all lambda integrations are granted management API access for the websocket API to send messages, disconnect clients, etc.
     * Set to true if you would like to manage these permissions manually.
     * @default false
     */
    readonly disableGrantManagementAccessToLambdas?: boolean;
    /**
     * By default, all mock integrations will automatically be configured with integration responses such that the integration is considered
     * successful. Set to true to disable this (mock integrations will respond with errors)
     * @default false
     */
    readonly disableMockIntegrationResponses?: boolean;
    /**
     * Disable access logging
     * @default false
     */
    readonly disableAccessLogging?: boolean;
}
/**
 * A construct for creating a websocket API, based on the provided spec and integrations
 */
export declare class TypeSafeWebsocketApi extends Construct {
    /**
     * Reference to the websocket API
     */
    readonly api: WebSocketApi;
    /**
     * Reference to the default deploy stage
     */
    readonly defaultStage: WebSocketStage;
    private readonly _props;
    constructor(scope: Construct, id: string, props: TypeSafeWebsocketApiProps);
    /**
     * Add a route to the websocket api
     */
    private addRoute;
}
