import { OpenApiAsyncDefinition } from "./openapi/open-api-async-definition";
import { OpenApiProjectDefinition } from "./openapi/open-api-project-definition";
import { SmithyAsyncDefinition } from "./smithy/smithy-async-definition";
import { SmithyProjectDefinition } from "./smithy/smithy-project-definition";
import { TypeSafeApiModelProjectBase, TypeSafeApiModelProjectBaseOptions } from "./type-safe-api-model-project-base";
import { Language } from "../languages";
import { OpenApiModelOptions, SmithyModelOptions } from "../types";
export interface TypeSafeWebSocketApiModelProjectOptions extends TypeSafeApiModelProjectBaseOptions {
}
export declare class TypeSafeWebSocketApiModelProject extends TypeSafeApiModelProjectBase {
    /**
     * Reference to the Smithy definition component. Will be defined if the model language is Smithy
     */
    readonly smithy?: SmithyAsyncDefinition;
    /**
     * Reference to the OpenAPI definition component. Will be defined if the model language is OpenAPI
     */
    readonly openapi?: OpenApiAsyncDefinition;
    /**
     * Async API specification path, generated by Type Safe API for documentation generation
     */
    readonly asyncApiSpecFile: string;
    constructor(options: TypeSafeWebSocketApiModelProjectOptions);
    protected addSmithyApiDefinition(options: SmithyModelOptions, handlerLanguages?: Language[] | undefined): SmithyProjectDefinition;
    protected addOpenApiDefinition(options: OpenApiModelOptions, handlerLanguages?: Language[] | undefined): OpenApiProjectDefinition;
}
