"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.GENERAL_CATEGORY_ID = exports.findAwsCategoryDefinition = exports.AwsCategoryDefinitions = exports.CATEGORY_DEFAULT_FONT_COLOR = void 0;
/*! Copyright [Amazon.com](http://amazon.com/), Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0 */
const utils_1 = require("../../utils");
/** Default font color for categories */
exports.CATEGORY_DEFAULT_FONT_COLOR = "#232F3E";
/** Record of all category definitions keyed by id */
exports.AwsCategoryDefinitions = {
    analytics: {
        id: "analytics",
        name: "Analytics",
        fillColor: "#5A30B5",
        gradientColor: "#945DF2",
    },
    application_integration: {
        id: "application_integration",
        name: "Application Integration",
        fillColor: "#BC1356",
        gradientColor: "#F34482",
        variants: ["app_integration"],
    },
    blockchain: {
        id: "blockchain",
        name: "Blockchain",
        fillColor: "#D05C17",
        gradientColor: "#F78E04",
    },
    business_applications: {
        id: "business_applications",
        name: "Business Applications",
        fillColor: "#C7131F",
        gradientColor: "#F54749",
        variants: ["business_application"],
    },
    cloud_financial_management: {
        id: "cloud_financial_management",
        name: "Cloud Financial Management",
        fillColor: "#277116",
        gradientColor: "#60A337",
        variants: ["cost_management"],
    },
    compute: {
        id: "compute",
        name: "Compute",
        fillColor: "#D05C17",
        gradientColor: "#F78E04",
    },
    containers: {
        id: "containers",
        name: "Containers",
        fillColor: "#D05C17",
        gradientColor: "#F78E04",
    },
    customer_enablement: {
        id: "customer_enablement",
        name: "Customer Enablement",
        fillColor: "#3334B9",
        gradientColor: "#4D72F3",
        variants: ["customer_engagement"],
    },
    database: {
        id: "database",
        name: "Database",
        fillColor: "#3334B9",
        gradientColor: "#4D72F3",
    },
    developer_tools: {
        id: "developer_tools",
        name: "Developer Tools",
        fillColor: "#3334B9",
        gradientColor: "#4D72F3",
    },
    end_user_computing: {
        id: "end_user_computing",
        name: "End User Computing",
        fillColor: "#116D5B",
        gradientColor: "#4AB29A",
        variants: ["desktop_and_app_streaming"],
    },
    front_end_web_mobile: {
        id: "front_end_web_mobile",
        name: "Front-End Web & Mobile",
        fillColor: "#C7131F",
        gradientColor: "#F54749",
        variants: ["mobile"],
    },
    game_tech: {
        id: "game_tech",
        name: "Game Tech",
        fillColor: "#5A30B5",
        gradientColor: "#945DF2",
    },
    general: {
        id: "general",
        name: "General",
        fillColor: "#1E262E",
        gradientColor: "#505863",
        variants: ["general_resources", "general_icons", "illustrations"],
    },
    internet_of_things: {
        id: "internet_of_things",
        name: "Internet of Things",
        fillColor: "#277116",
        gradientColor: "#60A337",
        variants: ["iot", "lot"], // lot is miss spelling of some iot assets
    },
    machine_learning: {
        id: "machine_learning",
        name: "Machine Learning",
        fillColor: "#116D5B",
        gradientColor: "#4AB29A",
        variants: ["ml"],
    },
    management_governance: {
        id: "management_governance",
        name: "Management & Governance",
        fillColor: "#BC1356",
        gradientColor: "#F34482",
        variants: ["management_and_governance"],
    },
    media_services: {
        id: "media_services",
        name: "Media_services",
        fillColor: "#D05C17",
        gradientColor: "#F78E04",
    },
    migration_transfer: {
        id: "migration_transfer",
        name: "Migration & Transfer",
        fillColor: "#116D5B",
        gradientColor: "#4AB29A",
        variants: ["migration_and_transfer"],
    },
    networking_content_delivery: {
        id: "networking_content_delivery",
        name: "Networking & Content Delivery",
        fillColor: "#5A30B5",
        gradientColor: "#945DF2",
        variants: ["networking_and_content_delivery"],
    },
    quantum_technologies: {
        id: "quantum_technologies",
        name: "Quantum Technologies",
        fillColor: "#D05C17",
        gradientColor: "#F78E04",
    },
    robotics: {
        id: "robotics",
        name: "Robotics",
        fillColor: "#BE0917",
        gradientColor: "#FE5151",
    },
    satellite: {
        id: "satellite",
        name: "Satellite",
        fillColor: "#2F29AF",
        gradientColor: "#517DFD",
    },
    security_identity_compliance: {
        id: "security_identity_compliance",
        name: "Security, Identity, & Compliance",
        fillColor: "#C7131F",
        gradientColor: "#F54749",
        variants: ["security_identity_and_compliance"],
    },
    serverless: {
        id: "serverless",
        name: "Serverless",
        fillColor: "#5A30B5",
        gradientColor: "#945DF2",
    },
    storage: {
        id: "storage",
        name: "Storage",
        fillColor: "#277116",
        gradientColor: "#60A337",
    },
    vr_ar: {
        id: "vr_ar",
        name: "VR & AR",
        fillColor: "#BC1356",
        gradientColor: "#F34482",
        variants: ["ar_vr", "xr"],
    },
};
/** Find category definition for given value */
function findAwsCategoryDefinition(value) {
    value = (0, utils_1.normalizeIdentifier)(value);
    if (value in exports.AwsCategoryDefinitions) {
        return exports.AwsCategoryDefinitions[value];
    }
    const category = Object.values(exports.AwsCategoryDefinitions).find((_category) => {
        return _category.variants?.includes(value);
    });
    if (category == null) {
        throw new Error(`AwsCategorgies does not have match for ${value}`);
    }
    return category;
}
exports.findAwsCategoryDefinition = findAwsCategoryDefinition;
exports.GENERAL_CATEGORY_ID = exports.AwsCategoryDefinitions.general.id;
//# sourceMappingURL=data:application/json;base64,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