"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.PricingManifest = void 0;
/*! Copyright [Amazon.com](http://amazon.com/), Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0 */
const pricing_manifest_1 = require("../../generated/pricing-manifest");
const utils_1 = require("../../utils");
/** Service pricing manifest namespace */
var PricingManifest;
(function (PricingManifest) {
    /** Set of service slugs */
    PricingManifest.Slugs = new Set(pricing_manifest_1.PRICING_SLUGS);
    /** Record of all services defined in pricing manifest */
    PricingManifest.Services = pricing_manifest_1.PRICING_MANIFEST;
    const _ComparableTermCache = new Map(Object.values(PricingManifest.Services).flatMap((service) => {
        return service.comparableTerms.map((term) => [term, service]);
    }));
    /**
     * Find pricing service definition associated with a given term.
     */
    function findService(term) {
        // check if term is serviceCode
        if (term in PricingManifest.Services) {
            return PricingManifest.Services[term];
        }
        term = (0, utils_1.normalizeComparisonString)(term);
        if (_ComparableTermCache.has(term)) {
            return _ComparableTermCache.get(term);
        }
        return;
    }
    PricingManifest.findService = findService;
})(PricingManifest || (exports.PricingManifest = PricingManifest = {}));
//# sourceMappingURL=data:application/json;base64,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