"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.DEFAULT_DIAGRAM = exports.CONFIG_DEFAULTS = exports.DEFAULT_DIAGRAM_NAME = exports.DEFAULT_DIAGRAM_TITLE = exports.DiagramFormat = void 0;
/*! Copyright [Amazon.com](http://amazon.com/), Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0 */
const cdk_graph_1 = require("../cdk-graph");
/**
 * Supported diagram formats that can be generated.
 *
 * Extended formats are automatically generated, for example if you generate "png" which extends
 * "svg" which extends "dot", the resulting generated files will be all aforementioned.
 */
var DiagramFormat;
(function (DiagramFormat) {
    /**
     * Graphviz [DOT Language](https://graphviz.org/doc/info/lang.html)
     *
     * @default
     */
    DiagramFormat["DOT"] = "dot";
    /**
     * [SVG](https://developer.mozilla.org/en-US/docs/Web/SVG) generated
     * using [dot-wasm](https://hpcc-systems.github.io/hpcc-js-wasm/classes/graphviz.Graphviz.html)
     * from {@link DiagramFormat.DOT} file.
     *
     * @extends {DiagramFormat.DOT}
     */
    DiagramFormat["SVG"] = "svg";
    /**
     * [PNG](https://en.wikipedia.org/wiki/Portable_Network_Graphics) generated
     * using [sharp](https://sharp.pixelplumbing.com/api-output#png) from {@link DiagramFormat.SVG} file
     *
     * @extends {DiagramFormat.SVG}
     */
    DiagramFormat["PNG"] = "png";
    // TODO: add drawio support
})(DiagramFormat || (exports.DiagramFormat = DiagramFormat = {}));
/** Default diagram title */
exports.DEFAULT_DIAGRAM_TITLE = "Cloud Diagram";
/** Default diagram name */
exports.DEFAULT_DIAGRAM_NAME = "diagram";
/** Default configuration settings */
exports.CONFIG_DEFAULTS = {
    format: [DiagramFormat.PNG],
    filterPlan: {
        preset: cdk_graph_1.FilterPreset.COMPACT,
    },
};
/** Default diagram config */
exports.DEFAULT_DIAGRAM = {
    name: exports.DEFAULT_DIAGRAM_NAME,
    title: exports.DEFAULT_DIAGRAM_TITLE,
};
//# sourceMappingURL=data:application/json;base64,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