"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CdkGraphThreatComposerPlugin = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/*! Copyright [Amazon.com](http://amazon.com/), Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0 */
const fs = require("fs");
const threat_model_generator_1 = require("./model-generator/threat-model-generator");
/**
 * CdkGraphThreatComposerPlugin is a {@link ICdkGraphPlugin CdkGraph Plugin} implementation for generating
 * Threat Composer threat models.
 * @see https://github.com/awslabs/threat-composer
 */
class CdkGraphThreatComposerPlugin {
    /** @inheritdoc */
    get id() {
        return CdkGraphThreatComposerPlugin.ID;
    }
    /** @inheritdoc */
    get version() {
        return CdkGraphThreatComposerPlugin.VERSION;
    }
    /**
     * Retrieve the threat model artifact
     */
    get threatModelArtifact() {
        return this._threatModelArtifact;
    }
    constructor(options) {
        // TODO: consider graph plugin as dependency?
        /** @inheritdoc */
        this.dependencies = [];
        /** @internal */
        this._threatModelArtifact = undefined;
        /** @inheritdoc */
        this.bind = (graph) => {
            // Validate the top level node is a PDKNagApp, providing us with access to nag results
            if (!("extendedNagResults" in graph.root)) {
                throw new Error(`Threat Composer plugin requires the root CDK construct to be a PDKNagApp`);
            }
            this._app = graph.root;
        };
        /** @inheritdoc */
        this.report = async (context) => {
            if (!this._app) {
                throw new Error("Plugin has not been bound");
            }
            let architectureImageDataUri = undefined;
            const architectureDiagramArtifact = context.artifacts.DIAGRAM_SVG;
            if (architectureDiagramArtifact) {
                const diagramBinaryContent = fs.readFileSync(architectureDiagramArtifact.filepath);
                architectureImageDataUri = `data:image/svg+xml;base64,${diagramBinaryContent.toString("base64")}`;
            }
            const threatModel = new threat_model_generator_1.ThreatModelGenerator().generate(this._app.extendedNagResults(), {
                ...this._options,
                architectureImageDataUri,
            });
            this._threatModelArtifact = context.writeArtifact(this, "THREAT_MODEL", "threat-model.tc.json", JSON.stringify(threatModel, null, 2), "Threat Composer threat model.");
        };
        this._options = options;
    }
}
exports.CdkGraphThreatComposerPlugin = CdkGraphThreatComposerPlugin;
_a = JSII_RTTI_SYMBOL_1;
CdkGraphThreatComposerPlugin[_a] = { fqn: "@aws/pdk.cdk_graph_plugin_threat_composer.CdkGraphThreatComposerPlugin", version: "0.23.61" };
/**
 * Fixed ID of the threat-composer plugin
 */
CdkGraphThreatComposerPlugin.ID = "threat-composer";
/**
 * Curent semantic version of the threat-composer plugin
 */
CdkGraphThreatComposerPlugin.VERSION = "0.0.0";
//# sourceMappingURL=data:application/json;base64,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