"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.constructInfoFromConstruct = exports.addCustomSynthesis = void 0;
/**
 * Symbol for accessing jsii runtime information
 *
 * Introduced in jsii 1.19.0, cdk 1.90.0.
 *
 * @see https://github.com/aws/aws-cdk/blob/cea1039e3664fdfa89c6f00cdaeb1a0185a12678/packages/%40aws-cdk/core/lib/private/runtime-info.ts#L17
 *
 * @internal
 */
const JSII_RUNTIME_SYMBOL = Symbol.for("jsii.rtti");
/**
 * Symbol to identify custom cdk synthesis method.
 *
 * @internal
 */
const CUSTOM_SYNTHESIS_SYM = Symbol.for("@aws-cdk/core:customSynthesis");
/**
 * Cdk internal function for mapping construct synthesis property
 * for custom synthesis handling.
 *
 * @internal
 */
function addCustomSynthesis(construct, synthesis) {
    Object.defineProperty(construct, CUSTOM_SYNTHESIS_SYM, {
        value: synthesis,
        enumerable: false,
    });
}
exports.addCustomSynthesis = addCustomSynthesis;
/**
 * Retrieve {@link ConstructInfo} for a {@link IConstruct}
 * @see https://github.com/aws/aws-cdk/blob/cea1039e3664fdfa89c6f00cdaeb1a0185a12678/packages/%40aws-cdk/core/lib/private/runtime-info.ts#L46
 */
function constructInfoFromConstruct(construct) {
    const jsiiRuntimeInfo = Object.getPrototypeOf(construct).constructor[JSII_RUNTIME_SYMBOL];
    if (typeof jsiiRuntimeInfo === "object" &&
        jsiiRuntimeInfo !== null &&
        typeof jsiiRuntimeInfo.fqn === "string" &&
        typeof jsiiRuntimeInfo.version === "string") {
        return { fqn: jsiiRuntimeInfo.fqn, version: jsiiRuntimeInfo.version };
    }
    else if (jsiiRuntimeInfo) {
        // There is something defined, but doesn't match our expectations. Fail fast and hard.
        throw new Error(`malformed jsii runtime info for construct: '${construct.node.path}'`);
    }
    return undefined;
}
exports.constructInfoFromConstruct = constructInfoFromConstruct;
//# sourceMappingURL=data:application/json;base64,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