"use strict";
/*! Copyright [Amazon.com](http://amazon.com/), Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.resolveOutdir = exports.resolveConfig = exports.DEFAULT_OUTDIR = exports.CDK_OUTDIR_VAR = exports.CDK_GRAPH_RC = void 0;
const findUp = require("find-up"); // eslint-disable-line @typescript-eslint/no-require-imports
/** CdkGraph config file name */
exports.CDK_GRAPH_RC = ".cdkgraphrc.js";
/** Variable replacement token for cdk.out directory */
exports.CDK_OUTDIR_VAR = "<cdk.out>";
/** Default graph artifact output directory */
exports.DEFAULT_OUTDIR = `${exports.CDK_OUTDIR_VAR}/cdkgraph`;
/** Default CdkGraph configuration */
const DEFAULT_CONFIG = {
    outdir: exports.DEFAULT_OUTDIR,
};
/**
 * Resolve CdkGraph runtime configuration. Will detect local file system config if available and
 * merge with default configuration.
 * @internal
 */
function resolveConfig(cwd) {
    const config = findUp.sync(exports.CDK_GRAPH_RC, { cwd });
    if (config) {
        return {
            ...DEFAULT_CONFIG,
            ...require(config), // eslint-disable-line @typescript-eslint/no-require-imports
        };
    }
    return { ...DEFAULT_CONFIG };
}
exports.resolveConfig = resolveConfig;
/**
 * Resolve CdkGraph output directory. Performs replacement of tokens in config path.
 * @internal
 */
function resolveOutdir(cdkOutdir, outdir = exports.DEFAULT_OUTDIR) {
    return outdir.replace(exports.CDK_OUTDIR_VAR, cdkOutdir);
}
exports.resolveOutdir = resolveOutdir;
//# sourceMappingURL=data:application/json;base64,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