"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Counter = void 0;
/**
 * Counter class provides utils for adding/subtracting key based counts.
 *
 * For example, you can create a counter to track number of each CfnResourceType based on resource type key.
 *
 * @internal
 */
class Counter {
    constructor() {
        /** @internal */
        this._counts = new Map();
    }
    /** Gets record of keyed counts */
    get counts() {
        return Object.fromEntries(this._counts);
    }
    /** Increment key count by 1 */
    add(key) {
        const count = (this._counts.get(key) || 0) + 1;
        this._counts.set(key, count);
        return count;
    }
    /** Decrement key count by 1 */
    subtract(key) {
        const count = (this._counts.get(key) || 0) - 1;
        if (count < 0) {
            throw new Error(`Attempt to subtract count from zero`);
        }
        this._counts.set(key, count);
        return count;
    }
    /** Gets the current count for given key */
    getCount(key) {
        return this._counts.get(key) || 0;
    }
}
exports.Counter = Counter;
//# sourceMappingURL=data:application/json;base64,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