"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.performGraphFilterPlan = void 0;
/*! Copyright [Amazon.com](http://amazon.com/), Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0 */
const constructs_1 = require("constructs");
const filters_1 = require("./filters");
const presets = require("./presets");
const types_1 = require("./types");
const core_1 = require("../core");
__exportStar(require("./types"), exports);
__exportStar(require("./filters"), exports);
/**
 * Perform graph filter plan on store.
 *
 * This operation is performed *in-place* and is destructive, therefore can only be applied
 * on stores that allow destructive mutations.
 * @param {Graph.Store} store - The store to perform filter plan against
 * @param {IGraphFilterPlan} plan - The filter plan to apply
 * @throws Error is store does not allow destructive mutations
 * @destructive
 */
function performGraphFilterPlan(store, plan) {
    filters_1.Filters.verifyFilterable(store);
    if (plan.focus) {
        presets.focusFilter(store, plan);
    }
    if (plan.preset) {
        switch (plan.preset) {
            case types_1.FilterPreset.NON_EXTRANEOUS: {
                presets.nonExtraneousFilterPreset(store);
                break;
            }
            case types_1.FilterPreset.COMPACT: {
                presets.compactFilterPreset(store);
                break;
            }
        }
    }
    if (plan.filters) {
        for (const filter of plan.filters) {
            if (filter.store) {
                // IGraphStoreFilter
                filter.store.filter(store);
            }
            else if (filter.graph) {
                // IGraphFilter
                const _filter = filter.graph;
                const inverse = _filter.inverse === true;
                const allNodes = _filter.allNodes != null ? _filter.allNodes : plan.allNodes === true;
                const nodes = store.root.findAll({
                    order: plan.order || constructs_1.ConstructOrder.PREORDER,
                    predicate: {
                        filter: (node) => {
                            if (allNodes)
                                return true;
                            // by default only return Resources and CfnResources
                            return core_1.Graph.isResourceLike(node);
                        },
                    },
                });
                if (_filter.node) {
                    for (const node of nodes) {
                        if (node.isDestroyed)
                            continue;
                        const match = _filter.node.filter(node);
                        if ((match && inverse) || (!match && !inverse)) {
                            switch (_filter.strategy || types_1.FilterStrategy.PRUNE) {
                                case types_1.FilterStrategy.PRUNE: {
                                    node.mutateDestroy();
                                    break;
                                }
                                case types_1.FilterStrategy.COLLAPSE: {
                                    node.mutateCollapse();
                                    break;
                                }
                                case types_1.FilterStrategy.COLLAPSE_TO_PARENT: {
                                    node.mutateCollapseToParent();
                                    break;
                                }
                            }
                        }
                    }
                }
                if (_filter.edge) {
                    const edges = store.edges;
                    for (const edge of edges) {
                        if (edge.isDestroyed)
                            continue;
                        const match = _filter.edge.filter(edge);
                        if ((match && inverse) || (!match && !inverse)) {
                            edge.mutateDestroy();
                        }
                    }
                }
            }
        }
    }
}
exports.performGraphFilterPlan = performGraphFilterPlan;
//# sourceMappingURL=data:application/json;base64,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