"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.bucketInvocationUri = exports.functionInvocationUri = void 0;
/*! Copyright [Amazon.com](http://amazon.com/), Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0 */
const aws_cdk_lib_1 = require("aws-cdk-lib");
/**
 * Generate the lambda function invocation uri for the given lambda within the given scope
 * @param lambdaFunction the lambda function to be invoked
 */
const functionInvocationUri = (lambdaFunction) => {
    const stack = aws_cdk_lib_1.Stack.of(lambdaFunction);
    return `arn:${stack.partition}:apigateway:${stack.region}:lambda:path/2015-03-31/functions/${lambdaFunction.functionArn}/invocations`;
};
exports.functionInvocationUri = functionInvocationUri;
/**
 * Generate the s3 bucket invocation uri for the given s3 within the given scope
 * @param bucket the s3 bucket to be invoked
 * @param path? the path to object to invoke, default to none
 */
const bucketInvocationUri = (bucket, path) => {
    const stack = bucket.stack;
    return `arn:${stack.partition}:apigateway:${stack.region}:s3:path/${bucket.bucketName}/${path ?? ""}`;
};
exports.bucketInvocationUri = bucketInvocationUri;
//# sourceMappingURL=data:application/json;base64,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