import { Component, Project } from "projen";
/**
 * Component for setting up the environemnt for type safe api commands
 */
export declare class TypeSafeApiCommandEnvironment extends Component {
    /**
     * Retrieves an instance of TypeSafeApiCommandEnvironment if one is associated to the given project.
     *
     * @param project project instance.
     */
    static of(project: Project): TypeSafeApiCommandEnvironment | undefined;
    /**
     * Retrieves an instance of TypeSafeApiCommandEnvironment if one is associated to the given project,
     * otherwise creates a TypeSafeApiCommandEnvironment instance for the project.
     *
     * @param project project instance.
     */
    static ensure(project: Project): TypeSafeApiCommandEnvironment;
    constructor(project: Project);
}
