"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.GeneratedAsyncApiHtmlDocumentationProject = void 0;
/*! Copyright [Amazon.com](http://amazon.com/), Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0 */
const projen_1 = require("projen");
const type_safe_api_command_environment_1 = require("../components/type-safe-api-command-environment");
const utils_1 = require("../components/utils");
class GeneratedAsyncApiHtmlDocumentationProject extends projen_1.Project {
    constructor(options) {
        super(options);
        type_safe_api_command_environment_1.TypeSafeApiCommandEnvironment.ensure(this);
        this.generateTask = this.addTask("generate");
        this.generateTask.exec((0, utils_1.buildTypeSafeApiExecCommand)(utils_1.TypeSafeApiScript.GENERATE_ASYNCAPI_HTML_DOCS, `--spec-path ${options.specPath} --output-path .`));
        this.compileTask.spawn(this.generateTask);
        if (!options.commitGeneratedCode) {
            this.gitignore.addPatterns("index.html");
        }
    }
}
exports.GeneratedAsyncApiHtmlDocumentationProject = GeneratedAsyncApiHtmlDocumentationProject;
//# sourceMappingURL=data:application/json;base64,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