"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.GeneratedAsyncApiMarkdownDocumentationProject = void 0;
/*! Copyright [Amazon.com](http://amazon.com/), Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0 */
const projen_1 = require("projen");
const type_safe_api_command_environment_1 = require("../components/type-safe-api-command-environment");
const utils_1 = require("../components/utils");
class GeneratedAsyncApiMarkdownDocumentationProject extends projen_1.Project {
    constructor(options) {
        super(options);
        type_safe_api_command_environment_1.TypeSafeApiCommandEnvironment.ensure(this);
        this.generateTask = this.addTask("generate");
        this.generateTask.exec((0, utils_1.buildTypeSafeApiExecCommand)(utils_1.TypeSafeApiScript.GENERATE_ASYNCAPI_MARKDOWN_DOCS, `--spec-path ${options.specPath} --output-path .`));
        this.compileTask.spawn(this.generateTask);
        if (!options.commitGeneratedCode) {
            this.gitignore.addPatterns("index.md");
        }
    }
}
exports.GeneratedAsyncApiMarkdownDocumentationProject = GeneratedAsyncApiMarkdownDocumentationProject;
//# sourceMappingURL=data:application/json;base64,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