"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.GeneratedJavaHandlersProject = void 0;
/*! Copyright [Amazon.com](http://amazon.com/), Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0 */
const generated_java_handlers_base_project_1 = require("./generated-java-handlers-base-project");
const utils_1 = require("../components/utils");
class GeneratedJavaHandlersProject extends generated_java_handlers_base_project_1.GeneratedJavaHandlersBaseProject {
    constructor(options) {
        super(options);
    }
    buildOpenApiGeneratorOptions() {
        return {
            generator: "java",
            specPath: this.options.specPath,
            generatorDirectory: utils_1.OtherGenerators.JAVA_LAMBDA_HANDLERS,
            srcDir: this.srcDir,
            tstDir: this.tstDir,
            normalizers: {
                KEEP_ONLY_FIRST_TAG_IN_OPERATION: true,
            },
            extraVendorExtensions: {
                "x-handlers-package": this.packageName,
                "x-runtime-package": this.options.generatedJavaTypes.packageName,
            },
            // Do not generate map/list types. Generator will use built in HashMap, ArrayList instead
            generateAliasAsModel: false,
        };
    }
}
exports.GeneratedJavaHandlersProject = GeneratedJavaHandlersProject;
//# sourceMappingURL=data:application/json;base64,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