"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.GeneratedPythonAsyncHandlersProject = void 0;
/*! Copyright [Amazon.com](http://amazon.com/), Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0 */
const generated_python_handlers_base_project_1 = require("./generated-python-handlers-base-project");
const utils_1 = require("../components/utils");
class GeneratedPythonAsyncHandlersProject extends generated_python_handlers_base_project_1.GeneratedPythonHandlersBaseProject {
    constructor(options) {
        super(options);
    }
    buildOpenApiGeneratorOptions() {
        return {
            generator: "python-nextgen",
            specPath: this.options.specPath,
            generatorDirectory: utils_1.OtherGenerators.PYTHON_ASYNC_LAMBDA_HANDLERS,
            // Tell the generator where python source files live
            srcDir: this.moduleName,
            tstDir: this.tstDir,
            additionalProperties: {
                packageName: this.moduleName,
                projectName: this.name,
            },
            normalizers: {
                KEEP_ONLY_FIRST_TAG_IN_OPERATION: true,
            },
            extraVendorExtensions: {
                "x-runtime-module-name": this.options.generatedPythonTypes.moduleName,
            },
        };
    }
}
exports.GeneratedPythonAsyncHandlersProject = GeneratedPythonAsyncHandlersProject;
//# sourceMappingURL=data:application/json;base64,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