"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.GeneratedJavaCdkInfrastructureProject = void 0;
/*! Copyright [Amazon.com](http://amazon.com/), Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0 */
const generated_java_cdk_infrastructure_base_project_1 = require("./generated-java-cdk-infrastructure-base-project");
const utils_1 = require("../../components/utils");
class GeneratedJavaCdkInfrastructureProject extends generated_java_cdk_infrastructure_base_project_1.GeneratedJavaCdkInfrastructureBaseProject {
    constructor(options) {
        super(options);
        this.buildGenerateMockDataCommand = () => {
            return (0, utils_1.buildInvokeMockDataGeneratorCommand)({
                specPath: this.options.specPath,
                // Write the mocks to the resources directory
                outputSubDir: "src/main/resources",
                ...this.options.mockDataOptions,
            });
        };
        this.options = options;
        if (!this.options.mockDataOptions?.disable) {
            this.generateTask.exec(this.buildGenerateMockDataCommand());
        }
        this.openapiGeneratorIgnore.addPatterns(`!${this.srcDir}/MockIntegrations.java`);
    }
    buildOpenApiGeneratorOptions() {
        return {
            generator: "java",
            specPath: this.options.specPath,
            generatorDirectory: utils_1.OtherGenerators.JAVA_CDK_INFRASTRUCTURE,
            srcDir: this.srcDir,
            normalizers: {
                KEEP_ONLY_FIRST_TAG_IN_OPERATION: true,
            },
            extraVendorExtensions: {
                "x-infrastructure-package": this.packageName,
                "x-runtime-package": this.options.generatedJavaTypes.packageName,
                // Enable mock integration generation by default
                "x-enable-mock-integrations": !this.options.mockDataOptions?.disable,
                ...(0, utils_1.getHandlersProjectVendorExtensions)(this, this.options.generatedHandlers),
            },
            // Do not generate map/list types. Generator will use built in HashMap, ArrayList instead
            generateAliasAsModel: false,
        };
    }
}
exports.GeneratedJavaCdkInfrastructureProject = GeneratedJavaCdkInfrastructureProject;
//# sourceMappingURL=data:application/json;base64,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