"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.GeneratedPythonCdkInfrastructureProject = void 0;
/*! Copyright [Amazon.com](http://amazon.com/), Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0 */
const path = require("path");
const generated_python_cdk_infrastructure_base_project_1 = require("./generated-python-cdk-infrastructure-base-project");
const utils_1 = require("../../components/utils");
class GeneratedPythonCdkInfrastructureProject extends generated_python_cdk_infrastructure_base_project_1.GeneratedPythonCdkInfrastructureBaseProject {
    constructor(options) {
        super(options);
        this.buildGenerateMockDataCommand = () => {
            return (0, utils_1.buildInvokeMockDataGeneratorCommand)({
                specPath: this.options.specPath,
                ...this.options.mockDataOptions,
            });
        };
        this.options = options;
        if (!this.options.mockDataOptions?.disable) {
            this.generateTask.exec(this.buildGenerateMockDataCommand());
        }
        this.openapiGeneratorIgnore.addPatterns(`!${this.moduleName}/mock_integrations.py`);
    }
    buildOpenApiGeneratorOptions() {
        return {
            generator: "python-nextgen",
            specPath: this.options.specPath,
            generatorDirectory: utils_1.OtherGenerators.PYTHON_CDK_INFRASTRUCTURE,
            // Tell the generator where python source files live
            srcDir: this.moduleName,
            normalizers: {
                KEEP_ONLY_FIRST_TAG_IN_OPERATION: true,
            },
            extraVendorExtensions: {
                "x-runtime-module-name": this.options.generatedPythonTypes.moduleName,
                // Spec path relative to the source directory
                "x-relative-spec-path": path.join("..", this.options.specPath),
                // Enable mock integration generation by default
                "x-enable-mock-integrations": !this.options.mockDataOptions?.disable,
                ...(0, utils_1.getHandlersProjectVendorExtensions)(this, this.options.generatedHandlers),
            },
        };
    }
}
exports.GeneratedPythonCdkInfrastructureProject = GeneratedPythonCdkInfrastructureProject;
//# sourceMappingURL=data:application/json;base64,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