"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.GeneratedTypescriptAsyncCdkInfrastructureProject = void 0;
/*! Copyright [Amazon.com](http://amazon.com/), Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0 */
const path = require("path");
const generated_typescript_cdk_infrastructure_base_project_1 = require("./generated-typescript-cdk-infrastructure-base-project");
const utils_1 = require("../../components/utils");
class GeneratedTypescriptAsyncCdkInfrastructureProject extends generated_typescript_cdk_infrastructure_base_project_1.GeneratedTypescriptCdkInfrastructureBaseProject {
    constructor(options) {
        super(options);
    }
    buildCodegenOptions() {
        return {
            specPath: this.options.specPath,
            templateDirs: [utils_1.OtherGenerators.TYPESCRIPT_ASYNC_CDK_INFRASTRUCTURE],
            metadata: {
                srcDir: this.srcdir,
                runtimePackageName: this.options.generatedTypescriptTypes.package.packageName,
                // Spec path relative to the source directory
                relativeSpecPath: path.join("..", this.packagedSpecPath),
                ...(0, utils_1.getHandlersProjectVendorExtensions)(this, this.options.generatedHandlers),
            },
        };
    }
}
exports.GeneratedTypescriptAsyncCdkInfrastructureProject = GeneratedTypescriptAsyncCdkInfrastructureProject;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZ2VuZXJhdGVkLXR5cGVzY3JpcHQtYXN5bmMtY2RrLWluZnJhc3RydWN0dXJlLXByb2plY3QuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJnZW5lcmF0ZWQtdHlwZXNjcmlwdC1hc3luYy1jZGstaW5mcmFzdHJ1Y3R1cmUtcHJvamVjdC50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7QUFBQTtzQ0FDc0M7QUFDdEMsNkJBQTZCO0FBQzdCLGlJQUdnRTtBQUNoRSxrREFJZ0M7QUFLaEMsTUFBYSxnREFBaUQsU0FBUSxzR0FBK0M7SUFDbkgsWUFDRSxPQUFnRTtRQUVoRSxLQUFLLENBQUMsT0FBTyxDQUFDLENBQUM7SUFDakIsQ0FBQztJQUVNLG1CQUFtQjtRQUN4QixPQUFPO1lBQ0wsUUFBUSxFQUFFLElBQUksQ0FBQyxPQUFPLENBQUMsUUFBUTtZQUMvQixZQUFZLEVBQUUsQ0FBQyx1QkFBZSxDQUFDLG1DQUFtQyxDQUFDO1lBQ25FLFFBQVEsRUFBRTtnQkFDUixNQUFNLEVBQUUsSUFBSSxDQUFDLE1BQU07Z0JBQ25CLGtCQUFrQixFQUNoQixJQUFJLENBQUMsT0FBTyxDQUFDLHdCQUF3QixDQUFDLE9BQU8sQ0FBQyxXQUFXO2dCQUMzRCw2Q0FBNkM7Z0JBQzdDLGdCQUFnQixFQUFFLElBQUksQ0FBQyxJQUFJLENBQUMsSUFBSSxFQUFFLElBQUksQ0FBQyxnQkFBZ0IsQ0FBQztnQkFDeEQsR0FBRyxJQUFBLDBDQUFrQyxFQUNuQyxJQUFJLEVBQ0osSUFBSSxDQUFDLE9BQU8sQ0FBQyxpQkFBaUIsQ0FDL0I7YUFDRjtTQUNGLENBQUM7SUFDSixDQUFDO0NBQ0Y7QUF4QkQsNEdBd0JDIiwic291cmNlc0NvbnRlbnQiOlsiLyohIENvcHlyaWdodCBbQW1hem9uLmNvbV0oaHR0cDovL2FtYXpvbi5jb20vKSwgSW5jLiBvciBpdHMgYWZmaWxpYXRlcy4gQWxsIFJpZ2h0cyBSZXNlcnZlZC5cblNQRFgtTGljZW5zZS1JZGVudGlmaWVyOiBBcGFjaGUtMi4wICovXG5pbXBvcnQgKiBhcyBwYXRoIGZyb20gXCJwYXRoXCI7XG5pbXBvcnQge1xuICBHZW5lcmF0ZWRUeXBlc2NyaXB0Q2RrSW5mcmFzdHJ1Y3R1cmVCYXNlUHJvamVjdCxcbiAgR2VuZXJhdGVkVHlwZXNjcmlwdENka0luZnJhc3RydWN0dXJlQmFzZVByb2plY3RPcHRpb25zLFxufSBmcm9tIFwiLi9nZW5lcmF0ZWQtdHlwZXNjcmlwdC1jZGstaW5mcmFzdHJ1Y3R1cmUtYmFzZS1wcm9qZWN0XCI7XG5pbXBvcnQge1xuICBDb2RlZ2VuT3B0aW9ucyxcbiAgZ2V0SGFuZGxlcnNQcm9qZWN0VmVuZG9yRXh0ZW5zaW9ucyxcbiAgT3RoZXJHZW5lcmF0b3JzLFxufSBmcm9tIFwiLi4vLi4vY29tcG9uZW50cy91dGlsc1wiO1xuXG5leHBvcnQgaW50ZXJmYWNlIEdlbmVyYXRlZFR5cGVzY3JpcHRBc3luY0Nka0luZnJhc3RydWN0dXJlUHJvamVjdE9wdGlvbnNcbiAgZXh0ZW5kcyBHZW5lcmF0ZWRUeXBlc2NyaXB0Q2RrSW5mcmFzdHJ1Y3R1cmVCYXNlUHJvamVjdE9wdGlvbnMge31cblxuZXhwb3J0IGNsYXNzIEdlbmVyYXRlZFR5cGVzY3JpcHRBc3luY0Nka0luZnJhc3RydWN0dXJlUHJvamVjdCBleHRlbmRzIEdlbmVyYXRlZFR5cGVzY3JpcHRDZGtJbmZyYXN0cnVjdHVyZUJhc2VQcm9qZWN0IHtcbiAgY29uc3RydWN0b3IoXG4gICAgb3B0aW9uczogR2VuZXJhdGVkVHlwZXNjcmlwdEFzeW5jQ2RrSW5mcmFzdHJ1Y3R1cmVQcm9qZWN0T3B0aW9uc1xuICApIHtcbiAgICBzdXBlcihvcHRpb25zKTtcbiAgfVxuXG4gIHB1YmxpYyBidWlsZENvZGVnZW5PcHRpb25zKCk6IENvZGVnZW5PcHRpb25zIHtcbiAgICByZXR1cm4ge1xuICAgICAgc3BlY1BhdGg6IHRoaXMub3B0aW9ucy5zcGVjUGF0aCxcbiAgICAgIHRlbXBsYXRlRGlyczogW090aGVyR2VuZXJhdG9ycy5UWVBFU0NSSVBUX0FTWU5DX0NES19JTkZSQVNUUlVDVFVSRV0sXG4gICAgICBtZXRhZGF0YToge1xuICAgICAgICBzcmNEaXI6IHRoaXMuc3JjZGlyLFxuICAgICAgICBydW50aW1lUGFja2FnZU5hbWU6XG4gICAgICAgICAgdGhpcy5vcHRpb25zLmdlbmVyYXRlZFR5cGVzY3JpcHRUeXBlcy5wYWNrYWdlLnBhY2thZ2VOYW1lLFxuICAgICAgICAvLyBTcGVjIHBhdGggcmVsYXRpdmUgdG8gdGhlIHNvdXJjZSBkaXJlY3RvcnlcbiAgICAgICAgcmVsYXRpdmVTcGVjUGF0aDogcGF0aC5qb2luKFwiLi5cIiwgdGhpcy5wYWNrYWdlZFNwZWNQYXRoKSxcbiAgICAgICAgLi4uZ2V0SGFuZGxlcnNQcm9qZWN0VmVuZG9yRXh0ZW5zaW9ucyhcbiAgICAgICAgICB0aGlzLFxuICAgICAgICAgIHRoaXMub3B0aW9ucy5nZW5lcmF0ZWRIYW5kbGVyc1xuICAgICAgICApLFxuICAgICAgfSxcbiAgICB9O1xuICB9XG59XG4iXX0=