"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.TypescriptReactQueryHooksLibrary = void 0;
/*! Copyright [Amazon.com](http://amazon.com/), Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0 */
const javascript_1 = require("projen/lib/javascript");
const generated_typescript_library_project_1 = require("./generated-typescript-library-project");
const languages_1 = require("../../languages");
/**
 * Typescript project containing generated react-query hooks
 */
class TypescriptReactQueryHooksLibrary extends generated_typescript_library_project_1.GeneratedTypescriptLibraryProject {
    constructor(options) {
        super({
            ...options,
            tsconfig: options.tsconfig ?? {
                compilerOptions: {
                    jsx: javascript_1.TypeScriptJsxMode.REACT,
                },
            },
        });
        // Add dependencies on react-query and react
        this.addDeps("@tanstack/react-query@^4"); // Pin at 4 for now - requires generated code updates to upgrade to 5
        this.addDevDeps("react", "@types/react");
        this.addPeerDeps("react");
    }
    buildCodegenOptions() {
        return {
            specPath: this.options.specPath,
            // Include the typescript client code in the hooks library
            templateDirs: [
                `${languages_1.Language.TYPESCRIPT}/templates/client`,
                languages_1.Library.TYPESCRIPT_REACT_QUERY_HOOKS,
            ],
            metadata: {
                srcDir: this.srcdir,
            },
        };
    }
}
exports.TypescriptReactQueryHooksLibrary = TypescriptReactQueryHooksLibrary;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidHlwZXNjcmlwdC1yZWFjdC1xdWVyeS1ob29rcy1saWJyYXJ5LmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsidHlwZXNjcmlwdC1yZWFjdC1xdWVyeS1ob29rcy1saWJyYXJ5LnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7OztBQUFBO3NDQUNzQztBQUN0QyxzREFBMEQ7QUFDMUQsaUdBR2dEO0FBQ2hELCtDQUFvRDtBQVNwRDs7R0FFRztBQUNILE1BQWEsZ0NBQWlDLFNBQVEsd0VBQWlDO0lBQ3JGLFlBQVksT0FBeUQ7UUFDbkUsS0FBSyxDQUFDO1lBQ0osR0FBRyxPQUFPO1lBQ1YsUUFBUSxFQUFFLE9BQU8sQ0FBQyxRQUFRLElBQUk7Z0JBQzVCLGVBQWUsRUFBRTtvQkFDZixHQUFHLEVBQUUsOEJBQWlCLENBQUMsS0FBSztpQkFDN0I7YUFDRjtTQUNGLENBQUMsQ0FBQztRQUVILDRDQUE0QztRQUM1QyxJQUFJLENBQUMsT0FBTyxDQUFDLDBCQUEwQixDQUFDLENBQUMsQ0FBQyxxRUFBcUU7UUFDL0csSUFBSSxDQUFDLFVBQVUsQ0FBQyxPQUFPLEVBQUUsY0FBYyxDQUFDLENBQUM7UUFDekMsSUFBSSxDQUFDLFdBQVcsQ0FBQyxPQUFPLENBQUMsQ0FBQztJQUM1QixDQUFDO0lBRU0sbUJBQW1CO1FBQ3hCLE9BQU87WUFDTCxRQUFRLEVBQUUsSUFBSSxDQUFDLE9BQU8sQ0FBQyxRQUFRO1lBQy9CLDBEQUEwRDtZQUMxRCxZQUFZLEVBQUU7Z0JBQ1osR0FBRyxvQkFBUSxDQUFDLFVBQVUsbUJBQW1CO2dCQUN6QyxtQkFBTyxDQUFDLDRCQUE0QjthQUNyQztZQUNELFFBQVEsRUFBRTtnQkFDUixNQUFNLEVBQUUsSUFBSSxDQUFDLE1BQU07YUFDcEI7U0FDRixDQUFDO0lBQ0osQ0FBQztDQUNGO0FBOUJELDRFQThCQyIsInNvdXJjZXNDb250ZW50IjpbIi8qISBDb3B5cmlnaHQgW0FtYXpvbi5jb21dKGh0dHA6Ly9hbWF6b24uY29tLyksIEluYy4gb3IgaXRzIGFmZmlsaWF0ZXMuIEFsbCBSaWdodHMgUmVzZXJ2ZWQuXG5TUERYLUxpY2Vuc2UtSWRlbnRpZmllcjogQXBhY2hlLTIuMCAqL1xuaW1wb3J0IHsgVHlwZVNjcmlwdEpzeE1vZGUgfSBmcm9tIFwicHJvamVuL2xpYi9qYXZhc2NyaXB0XCI7XG5pbXBvcnQge1xuICBHZW5lcmF0ZWRUeXBlc2NyaXB0TGlicmFyeVByb2plY3QsXG4gIEdlbmVyYXRlZFR5cGVzY3JpcHRMaWJyYXJ5UHJvamVjdE9wdGlvbnMsXG59IGZyb20gXCIuL2dlbmVyYXRlZC10eXBlc2NyaXB0LWxpYnJhcnktcHJvamVjdFwiO1xuaW1wb3J0IHsgTGFuZ3VhZ2UsIExpYnJhcnkgfSBmcm9tIFwiLi4vLi4vbGFuZ3VhZ2VzXCI7XG5pbXBvcnQgeyBDb2RlZ2VuT3B0aW9ucyB9IGZyb20gXCIuLi9jb21wb25lbnRzL3V0aWxzXCI7XG5cbi8qKlxuICogQ29uZmlndXJhdGlvbiBmb3IgdGhlIGdlbmVyYXRlZCB0eXBlc2NyaXB0IGNsaWVudCBwcm9qZWN0XG4gKi9cbmV4cG9ydCBpbnRlcmZhY2UgR2VuZXJhdGVkVHlwZXNjcmlwdFJlYWN0UXVlcnlIb29rc1Byb2plY3RPcHRpb25zXG4gIGV4dGVuZHMgR2VuZXJhdGVkVHlwZXNjcmlwdExpYnJhcnlQcm9qZWN0T3B0aW9ucyB7fVxuXG4vKipcbiAqIFR5cGVzY3JpcHQgcHJvamVjdCBjb250YWluaW5nIGdlbmVyYXRlZCByZWFjdC1xdWVyeSBob29rc1xuICovXG5leHBvcnQgY2xhc3MgVHlwZXNjcmlwdFJlYWN0UXVlcnlIb29rc0xpYnJhcnkgZXh0ZW5kcyBHZW5lcmF0ZWRUeXBlc2NyaXB0TGlicmFyeVByb2plY3Qge1xuICBjb25zdHJ1Y3RvcihvcHRpb25zOiBHZW5lcmF0ZWRUeXBlc2NyaXB0UmVhY3RRdWVyeUhvb2tzUHJvamVjdE9wdGlvbnMpIHtcbiAgICBzdXBlcih7XG4gICAgICAuLi5vcHRpb25zLFxuICAgICAgdHNjb25maWc6IG9wdGlvbnMudHNjb25maWcgPz8ge1xuICAgICAgICBjb21waWxlck9wdGlvbnM6IHtcbiAgICAgICAgICBqc3g6IFR5cGVTY3JpcHRKc3hNb2RlLlJFQUNULFxuICAgICAgICB9LFxuICAgICAgfSxcbiAgICB9KTtcblxuICAgIC8vIEFkZCBkZXBlbmRlbmNpZXMgb24gcmVhY3QtcXVlcnkgYW5kIHJlYWN0XG4gICAgdGhpcy5hZGREZXBzKFwiQHRhbnN0YWNrL3JlYWN0LXF1ZXJ5QF40XCIpOyAvLyBQaW4gYXQgNCBmb3Igbm93IC0gcmVxdWlyZXMgZ2VuZXJhdGVkIGNvZGUgdXBkYXRlcyB0byB1cGdyYWRlIHRvIDVcbiAgICB0aGlzLmFkZERldkRlcHMoXCJyZWFjdFwiLCBcIkB0eXBlcy9yZWFjdFwiKTtcbiAgICB0aGlzLmFkZFBlZXJEZXBzKFwicmVhY3RcIik7XG4gIH1cblxuICBwdWJsaWMgYnVpbGRDb2RlZ2VuT3B0aW9ucygpOiBDb2RlZ2VuT3B0aW9ucyB7XG4gICAgcmV0dXJuIHtcbiAgICAgIHNwZWNQYXRoOiB0aGlzLm9wdGlvbnMuc3BlY1BhdGgsXG4gICAgICAvLyBJbmNsdWRlIHRoZSB0eXBlc2NyaXB0IGNsaWVudCBjb2RlIGluIHRoZSBob29rcyBsaWJyYXJ5XG4gICAgICB0ZW1wbGF0ZURpcnM6IFtcbiAgICAgICAgYCR7TGFuZ3VhZ2UuVFlQRVNDUklQVH0vdGVtcGxhdGVzL2NsaWVudGAsXG4gICAgICAgIExpYnJhcnkuVFlQRVNDUklQVF9SRUFDVF9RVUVSWV9IT09LUyxcbiAgICAgIF0sXG4gICAgICBtZXRhZGF0YToge1xuICAgICAgICBzcmNEaXI6IHRoaXMuc3JjZGlyLFxuICAgICAgfSxcbiAgICB9O1xuICB9XG59XG4iXX0=