"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.TypescriptWebsocketHooksLibrary = void 0;
/*! Copyright [Amazon.com](http://amazon.com/), Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0 */
const javascript_1 = require("projen/lib/javascript");
const generated_typescript_library_project_1 = require("./generated-typescript-library-project");
const languages_1 = require("../../languages");
/**
 * Typescript project containing generated websocket hooks
 */
class TypescriptWebsocketHooksLibrary extends generated_typescript_library_project_1.GeneratedTypescriptLibraryProject {
    constructor(options) {
        super({
            ...options,
            tsconfig: options.tsconfig ?? {
                compilerOptions: {
                    jsx: javascript_1.TypeScriptJsxMode.REACT,
                },
            },
        });
        this.options = options;
        this.addDevDeps("react", "@types/react");
        this.addPeerDeps("react");
    }
    buildCodegenOptions() {
        return {
            specPath: this.options.specPath,
            templateDirs: [languages_1.WebSocketLibrary.TYPESCRIPT_WEBSOCKET_HOOKS],
            metadata: {
                srcDir: this.srcdir,
                websocketClientPackageName: this.options.clientPackageName,
            },
        };
    }
}
exports.TypescriptWebsocketHooksLibrary = TypescriptWebsocketHooksLibrary;
//# sourceMappingURL=data:application/json;base64,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