"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.GeneratedJavaAsyncRuntimeProject = void 0;
/*! Copyright [Amazon.com](http://amazon.com/), Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0 */
const path = require("path");
const generated_java_runtime_base_project_1 = require("./generated-java-runtime-base-project");
const utils_1 = require("../components/utils");
/**
 * Java project containing types generated using OpenAPI Generator CLI
 */
class GeneratedJavaAsyncRuntimeProject extends generated_java_runtime_base_project_1.GeneratedJavaRuntimeBaseProject {
    constructor(options) {
        super(options);
    }
    buildOpenApiGeneratorOptions() {
        return {
            generator: "java",
            specPath: this.options.specPath,
            generatorDirectory: utils_1.OtherGenerators.JAVA_ASYNC_RUNTIME,
            additionalProperties: {
                useSingleRequestParameter: "true",
                groupId: this.pom.groupId,
                artifactId: this.pom.artifactId,
                artifactVersion: this.pom.version,
                invokerPackage: this.packageName,
                apiPackage: `${this.packageName}.api`,
                modelPackage: `${this.packageName}.model`,
                hideGenerationTimestamp: "true",
                additionalModelTypeAnnotations: [
                    "@lombok.AllArgsConstructor",
                    // Regular lombok builder is not used since an abstract base schema class is also annotated
                    "@lombok.experimental.SuperBuilder",
                ].join("\\ "),
            },
            srcDir: path.join("src", "main", "java", ...this.packageName.split(".")),
            normalizers: {
                KEEP_ONLY_FIRST_TAG_IN_OPERATION: true,
            },
            // Do not generate map/list types. Generator will use built in HashMap, ArrayList instead
            generateAliasAsModel: false,
        };
    }
}
exports.GeneratedJavaAsyncRuntimeProject = GeneratedJavaAsyncRuntimeProject;
//# sourceMappingURL=data:application/json;base64,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