"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.GeneratedPythonAsyncRuntimeProject = void 0;
/*! Copyright [Amazon.com](http://amazon.com/), Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0 */
const generated_python_runtime_base_project_1 = require("./generated-python-runtime-base-project");
const utils_1 = require("../components/utils");
/**
 * Python project containing types generated using OpenAPI Generator CLI
 */
class GeneratedPythonAsyncRuntimeProject extends generated_python_runtime_base_project_1.GeneratedPythonRuntimeBaseProject {
    constructor(options) {
        super(options);
    }
    buildOpenApiGeneratorOptions() {
        return {
            generator: "python",
            specPath: this.options.specPath,
            generatorDirectory: utils_1.OtherGenerators.PYTHON_ASYNC_RUNTIME,
            additionalProperties: {
                packageName: this.moduleName,
                projectName: this.name,
            },
            // Tell the generator where python source files live
            srcDir: this.moduleName,
            normalizers: {
                KEEP_ONLY_FIRST_TAG_IN_OPERATION: true,
            },
        };
    }
}
exports.GeneratedPythonAsyncRuntimeProject = GeneratedPythonAsyncRuntimeProject;
//# sourceMappingURL=data:application/json;base64,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