/*! Copyright [Amazon.com](http://amazon.com/), Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0 */
import { PythonProject } from "projen/lib/python";
import { CodeGenerationSourceOptions, GeneratedPythonRuntimeOptions } from "../../types";
import { OpenApiGeneratorIgnoreFile } from "../components/open-api-generator-ignore-file";
import { GenerationOptions } from "../components/utils";
/**
 * Configuration for the generated python types project
 */
export interface GeneratedPythonRuntimeBaseProjectOptions extends GeneratedPythonRuntimeOptions, CodeGenerationSourceOptions {
}
/**
 * Python project containing types generated using OpenAPI Generator CLI
 */
export declare abstract class GeneratedPythonRuntimeBaseProject extends PythonProject {
    /**
     * Patterns that are excluded from code generation
     */
    static openApiIgnorePatterns: string[];
    /**
     * Options configured for the project
     */
    protected readonly options: GeneratedPythonRuntimeBaseProjectOptions;
    protected readonly openapiGeneratorIgnore: OpenApiGeneratorIgnoreFile;
    constructor(options: GeneratedPythonRuntimeBaseProjectOptions);
    buildGenerateCommandArgs: () => string;
    protected abstract buildOpenApiGeneratorOptions(): GenerationOptions;
}
