"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.GeneratedPythonRuntimeProject = void 0;
/*! Copyright [Amazon.com](http://amazon.com/), Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0 */
const generated_python_runtime_base_project_1 = require("./generated-python-runtime-base-project");
const languages_1 = require("../../languages");
/**
 * Python project containing types generated using OpenAPI Generator CLI
 */
class GeneratedPythonRuntimeProject extends generated_python_runtime_base_project_1.GeneratedPythonRuntimeBaseProject {
    constructor(options) {
        super(options);
    }
    buildOpenApiGeneratorOptions() {
        return {
            generator: "python",
            specPath: this.options.specPath,
            generatorDirectory: languages_1.Language.PYTHON,
            additionalProperties: {
                packageName: this.moduleName,
                projectName: this.name,
            },
            // Tell the generator where python source files live
            srcDir: this.moduleName,
            normalizers: {
                KEEP_ONLY_FIRST_TAG_IN_OPERATION: true,
            },
        };
    }
}
exports.GeneratedPythonRuntimeProject = GeneratedPythonRuntimeProject;
//# sourceMappingURL=data:application/json;base64,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