"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.GeneratedTypescriptAsyncRuntimeProject = void 0;
/*! Copyright [Amazon.com](http://amazon.com/), Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0 */
const generated_typescript_runtime_base_project_1 = require("./generated-typescript-runtime-base-project");
const languages_1 = require("../../languages");
const utils_1 = require("../components/utils");
/**
 * Typescript project containing types generated using OpenAPI Generator CLI
 */
class GeneratedTypescriptAsyncRuntimeProject extends generated_typescript_runtime_base_project_1.GeneratedTypescriptRuntimeBaseProject {
    constructor(options) {
        super(options);
        this.addDeps("@aws-sdk/client-apigatewaymanagementapi");
    }
    buildCodegenOptions() {
        return {
            specPath: this.options.specPath,
            templateDirs: [
                utils_1.OtherGenerators.TYPESCRIPT_ASYNC_RUNTIME,
                `${languages_1.Language.TYPESCRIPT}/templates/client/models`,
            ],
            metadata: {
                srcDir: this.srcdir,
            },
        };
    }
}
exports.GeneratedTypescriptAsyncRuntimeProject = GeneratedTypescriptAsyncRuntimeProject;
//# sourceMappingURL=data:application/json;base64,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