"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.OpenApiDefinition = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/*! Copyright [Amazon.com](http://amazon.com/), Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0 */
const projen_1 = require("projen");
const open_api_project_definition_1 = require("./open-api-project-definition");
/**
 * The OpenAPI Spec
 */
class OpenApiDefinition extends open_api_project_definition_1.OpenApiProjectDefinition {
    constructor(project, options) {
        super(project, options);
        const firstHandlerLanguage = options.handlerLanguages?.[0];
        // Create a sample OpenAPI spec yaml if not defined
        new projen_1.SampleFile(project, this.openApiSpecificationPath, {
            contents: `openapi: 3.0.3
info:
  version: 1.0.0
  title: ${options.openApiOptions.title}
paths:
  /hello:
    get:
      operationId: sayHello${firstHandlerLanguage
                ? `
      x-handler:
        language: ${firstHandlerLanguage}`
                : ""}
      parameters:
        - in: query
          name: name
          schema:
            type: string
          required: true
      responses:
        200:
          description: Successful response
          content:
            'application/json':
              schema:
                $ref: '#/components/schemas/SayHelloResponseContent'
        500:
          description: An internal failure at the fault of the server
          content:
            'application/json':
              schema:
                $ref: '#/components/schemas/InternalFailureErrorResponseContent'
        400:
          description: An error at the fault of the client sending invalid input
          content:
            'application/json':
              schema:
                $ref: '#/components/schemas/BadRequestErrorResponseContent'
        403:
          description: An error due to the client not being authorized to access the resource
          content:
            'application/json':
              schema:
                $ref: '#/components/schemas/NotAuthorizedErrorResponseContent'
components:
  schemas:
    SayHelloResponseContent:
      type: object
      properties:
        message:
          type: string
      required:
        - message
    InternalFailureErrorResponseContent:
      type: object
      properties:
        message:
          type: string
      required:
        - message
    BadRequestErrorResponseContent:
      type: object
      properties:
        message:
          type: string
      required:
        - message
    NotAuthorizedErrorResponseContent:
      type: object
      properties:
        message:
          type: string
      required:
        - message
`,
        });
    }
}
exports.OpenApiDefinition = OpenApiDefinition;
_a = JSII_RTTI_SYMBOL_1;
OpenApiDefinition[_a] = { fqn: "@aws/pdk.type_safe_api.OpenApiDefinition", version: "0.23.61" };
//# sourceMappingURL=data:application/json;base64,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