"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.SmithyAsyncSampleCode = void 0;
/*! Copyright [Amazon.com](http://amazon.com/), Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0 */
const projen_1 = require("projen");
/**
 * Defines sample code for a Smithy async API
 */
class SmithyAsyncSampleCode extends projen_1.SampleDir {
    constructor(project, { modelDir, serviceName, serviceNamespace, firstHandlerLanguage, }) {
        super(project, modelDir, {
            files: {
                "main.smithy": `$version: "2"
namespace ${serviceNamespace}

/// A sample smithy websocket api
@websocketJson${firstHandlerLanguage
                    ? `\n@connectHandler(language: "${firstHandlerLanguage}")\n@disconnectHandler(language: "${firstHandlerLanguage}")`
                    : ""}
service ${serviceName} {
    version: "1.0"
    operations: [
      SubscribeToNotifications
      SendNotification
    ]
}`,
                "operations/subscribe-to-notifications.smithy": `$version: "2"
namespace ${serviceNamespace}

${firstHandlerLanguage ? `\n@handler(language: "${firstHandlerLanguage}")` : ""}
@async(direction: "client_to_server")
operation SubscribeToNotifications {
    input := {
        @required
        topic: String
    }
}
`,
                "operations/send-notification.smithy": `$version: "2"
namespace ${serviceNamespace}


@async(direction: "server_to_client")
operation SendNotification {
    input := {
        @required
        topic: String

        @required
        title: String

        @required
        message: String
    }
}
`,
            },
        });
    }
}
exports.SmithyAsyncSampleCode = SmithyAsyncSampleCode;
//# sourceMappingURL=data:application/json;base64,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