"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SmithyAsyncDefinition = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/*! Copyright [Amazon.com](http://amazon.com/), Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0 */
const smithy_async_sample_code_1 = require("./components/smithy-async-sample-code");
const smithy_aws_pdk_async_prelude_1 = require("./components/smithy-aws-pdk-async-prelude");
const smithy_project_definition_1 = require("./smithy-project-definition");
const utils_1 = require("../../codegen/components/utils");
/**
 * Creates a project which transforms a Smithy model for an async API to OpenAPI
 */
class SmithyAsyncDefinition extends smithy_project_definition_1.SmithyProjectDefinition {
    constructor(project, options) {
        super(project, {
            ...options,
            smithyOptions: {
                ...options.smithyOptions,
                smithyBuildOptions: {
                    ...options.smithyOptions.smithyBuildOptions,
                    projections: {
                        ...options.smithyOptions.smithyBuildOptions?.projections,
                        openapi: {
                            ...options.smithyOptions.smithyBuildOptions?.projections?.openapi,
                            transforms: [
                                // Add the async transform to the openapi projection
                                { name: "aws-pdk-async-transformer", args: {} },
                            ],
                        },
                    },
                },
            },
        });
        const { namespace: serviceNamespace, serviceName } = options.smithyOptions.serviceName;
        const firstHandlerLanguage = options.handlerLanguages?.[0];
        // Create the default smithy model
        new smithy_async_sample_code_1.SmithyAsyncSampleCode(project, {
            modelDir: this.modelDir,
            serviceName,
            serviceNamespace,
            firstHandlerLanguage,
        });
        // Add the additional async prelude
        new smithy_aws_pdk_async_prelude_1.SmithyAwsPdkAsyncPrelude(project, {
            generatedModelDir: this.generatedModelDir,
            serviceNamespace,
            handlerLanguages: options.handlerLanguages,
        });
        // Copy the async transformer jar
        project.generateTask.prependExec((0, utils_1.buildTypeSafeApiExecCommand)(utils_1.TypeSafeApiScript.COPY_ASYNC_SMITHY_TRANSFORMER));
        this.addDeps(`file://.smithy-async/aws-pdk-smithy-async-transformer.jar`);
        project.gitignore.addPatterns(".smithy-async");
    }
}
exports.SmithyAsyncDefinition = SmithyAsyncDefinition;
_a = JSII_RTTI_SYMBOL_1;
SmithyAsyncDefinition[_a] = { fqn: "@aws/pdk.type_safe_api.SmithyAsyncDefinition", version: "0.23.61" };
//# sourceMappingURL=data:application/json;base64,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